<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_custom_widget_13_scripts($hook)
{
  if ($hook !== 'index.php') {
    return;
  }

  wp_enqueue_style(
    'spss-custom-widget-13-css',
    plugin_dir_url(__FILE__) . '../assets/css/spss-custom-widget-13.css',
    [],
    '1.0.0'
  );

  wp_enqueue_script(
    'spss-custom-widget-13-js',
    plugin_dir_url(__FILE__) . '../assets/javascript/spss-custom-widget-13.js',
    array('jquery'),
    null,
    true
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_custom_widget_13_scripts');

function spss_render_custom_widget_content_widget_13()
{
  $name = get_option('spss_developer_name', '');
  $contact_email = get_option('spss_developer_email_address', '');
  $contact_phone = get_option('spss_developer_phone_number', '');
  $contact_address = get_option('spss_developer_site_address', '');

  $site_owner_email = get_option('admin_email');

  if (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['spss_contact_form_submit'])) {

    if (isset($_POST['_wpnonce']) && !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['_wpnonce'])), 'spss_contact_form_nonce')) {
      die('Nonce verification failed');
    }

    if (isset($_POST['spss_contact_email'], $_POST['spss_contact_message_title'], $_POST['spss_contact_message'])) {
      $email = sanitize_email(wp_unslash($_POST['spss_contact_email']));
      $message_title = sanitize_text_field(wp_unslash($_POST['spss_contact_message_title']));
      $message = sanitize_textarea_field(wp_unslash($_POST['spss_contact_message']));
    }

    if (is_email($email) && !empty($message)) {
      $subject = "Contact Form Submission: $message_title";
      $body = "Email: $email\nMessage Title: $message_title\nMessage:\n$message";
      $headers = array('Content-Type: text/plain; charset=UTF-8');
      wp_mail($contact_email, $subject, $body, $headers);
      $response_message = 'Thank you for contacting us! We will get back to you ASAP. 😊';
    } else {
      $response_message = 'Please fill in all fields correctly.';
    }
  }

  ob_start();
?>

  <div class="spss-widget-13">
    <div class="spss-widget-contact-info">
      <ul>
        <?php if ($name) : ?>
          <li><strong>👨‍💻 Developer:</strong> <?php echo esc_html($name) ?></li>
        <?php endif; ?>
        <?php if ($contact_email) : ?>
          <li><strong>📮 E-Mail:</strong> <a href="mailto:<?php echo esc_attr($contact_email) ?>"><?php echo esc_html($contact_email) ?></a></li>
        <?php endif; ?>
        <?php if ($contact_phone) : ?>
          <li><strong>📞 Phone:</strong> <?php echo esc_html($contact_phone) ?></li>
        <?php endif; ?>
        <?php if ($contact_address) : ?>
          <li><strong>🌐 Website:</strong> <?php echo esc_html($contact_address) ?></li>
        <?php endif; ?>
      </ul>

      <div class="contact-form">
        <h4>Need Assistance? Drop Us a Line.</h4>
        <form method="POST">
          <input type="hidden" name="spss_contact_email" value="<?php echo esc_attr($site_owner_email) ?>">
          <input type="hidden" name="_wpnonce" value="<?php echo esc_attr(wp_create_nonce('spss_contact_form_nonce')); ?>" />
          <input type="text" id="spss_contact_message_title" name="spss_contact_message_title" placeholder="Title" minlength="5" required>
          <textarea id="spss_contact_message" name="spss_contact_message" placeholder="Your Message" rows="4" minlength="10" required></textarea>
          <button type="submit" class="button-primary" name="spss_contact_form_submit" id="spss_submit_button" disabled>Send Message</button>
        </form>

        <?php if (isset($response_message)) : ?>
          <div class="response-message"><?php echo wp_kses_post($response_message) ?></div>
        <?php endif; ?>
      </div>
    </div>
  </div>

<?php
  $output = ob_get_clean();

  echo wp_kses($output, array(
    'div' => array('class' => array()),
    'form' => array('method' => array()),
    'ul' => array('class' => array()),
    'li' => array('class' => array()),
    'h4' => array(),
    'strong' => array(),
    'input' => array(
      'type' => array(),
      'name' => array(),
      'value' => array(),
      'class' => array(),
      'placeholder' => array(),
      'id' => array(),
      'required' => array()
    ),
    'textarea' => array(
      'name' => array(),
      'class' => array(),
      'rows' => array(),
      'cols' => array(),
      'placeholder' => array(),
      'id' => array(),
      'required' => array()
    ),
    'button' => array(
      'type' => array(),
      'class' => array(),
      'id' => array(),
      'name' => array(),
      'disabled' => array()
    ),
    'span' => array(
      'class' => array(),
      'id' => array(),
    ),
    'p' => array(),
    'br' => array(),
  ));
}
