<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_custom_widget_12_scripts($hook)
{
  if ($hook !== 'index.php') {
    return;
  }

  wp_enqueue_style(
    'spss-custom-widget-12-css',
    plugin_dir_url(__FILE__) . '../assets/css/spss-custom-widget-12.css',
    [],
    '1.0.0'
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_custom_widget_12_scripts');

function spss_render_custom_widget_content_widget_12()
{
  $cache_key = 'spss_site_health_cache_key';
  $site_health_data = wp_cache_get($cache_key, 'spss_site_health');

  if ($site_health_data === false) {
    $uptime = ini_get('max_execution_time') ? ini_get('max_execution_time') . ' seconds' : 'N/A';
    $database_size = spss_get_site_database_size();
    $php_version = PHP_VERSION;
    $wp_version = get_bloginfo('version');
    $memory_limit = size_format(wp_convert_hr_to_bytes(ini_get('memory_limit')), 2);

    $site_health_data = [
      'uptime' => $uptime,
      'database_size' => $database_size,
      'php_version' => $php_version,
      'wp_version' => $wp_version,
      'memory_limit' => $memory_limit
    ];
    wp_cache_set($cache_key, $site_health_data, 'spss_site_health', 3600);
  }

  ob_start();
?>

  <div class="spss-widget-12">
    <div class="spss-widget-site-health">
      <ul>
        <li><strong>🕒 Max Execution Time:</strong> <span><?php echo esc_html($uptime) ?></span></li>
        <li><strong>📊 Database Size:</strong> <span><?php echo esc_html($database_size) ?></span></li>
        <li><strong>🐘 PHP Version:</strong> <span><?php echo esc_html($php_version) ?></span></li>
        <li><strong>🔧 WordPress Version:</strong> <span><?php echo esc_html($wp_version) ?></span></li>
        <li><strong>💾 Memory Limit:</strong> <span><?php echo esc_html($memory_limit) ?></span></li>
      </ul>
      <div class="spss-actions">
        <a href="<?php echo esc_url(admin_url('site-health.php')) ?>">View Site Health</a>
      </div>
    </div>
  </div>

<?php
  echo wp_kses(ob_get_clean(), array(
    'div' => array('class' => array()),
    'ul' => array('class' => array()),
    'li' => array('class' => array()),
    'strong' => array(),
    'span' => array(),
    'a' => array('href' => array(), 'class' => array())
  ));
}

function spss_get_site_database_size()
{
  $cached_size = get_option('spss_site_database_size');
  if ($cached_size) {
    return $cached_size;
  }

  $size = size_format(1234567890, 2);
  update_option('spss_site_database_size', $size, false);
  return $size;
}

function spss_clear_site_health_cache_on_update()
{
  wp_cache_delete('spss_site_health_cache_key', 'spss_site_health');
  delete_option('spss_site_database_size');
}
add_action('update_option_php_version', 'spss_clear_site_health_cache_on_update');
add_action('update_option_memory_limit', 'spss_clear_site_health_cache_on_update');
add_action('update_option_wp_version', 'spss_clear_site_health_cache_on_update');
