<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_custom_widget_11_scripts($hook)
{
  if ($hook !== 'index.php') {
    return;
  }

  wp_enqueue_style(
    'spss-custom-widget-11-css',
    plugin_dir_url(__FILE__) . '../assets/css/spss-custom-widget-11.css',
    [],
    '1.0.0'
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_custom_widget_11_scripts');

function spss_render_custom_widget_content_widget_11()
{
  $media_files = get_posts(array(
    'post_type' => 'attachment',
    'posts_per_page' => -1,
  ));

  $media_count = count($media_files);
  $image_count = 0;
  $video_count = 0;
  $audio_count = 0;
  $total_size = 0;
  $largest_file = null;
  $smallest_file = null;

  foreach ($media_files as $file) {
    $file_path = get_attached_file($file->ID);
    $file_size = filesize($file_path);
    $total_size += $file_size;

    $mime_type = get_post_mime_type($file);
    if (strpos($mime_type, 'image') !== false) {
      $image_count++;
    } elseif (strpos($mime_type, 'video') !== false) {
      $video_count++;
    } elseif (strpos($mime_type, 'audio') !== false) {
      $audio_count++;
    }

    if (!$largest_file || $file_size > filesize(get_attached_file($largest_file->ID))) {
      $largest_file = $file;
    }

    if (!$smallest_file || $file_size < filesize(get_attached_file($smallest_file->ID))) {
      $smallest_file = $file;
    }
  }

  $total_size_human = size_format($total_size, 2);
  $largest_file_size = size_format(filesize(get_attached_file($largest_file->ID)), 2);
  $smallest_file_size = size_format(filesize(get_attached_file($smallest_file->ID)), 2);

  $view_all_media_url = esc_url(admin_url('upload.php'));

  ob_start();
?>

  <div class="spss-widget-11">
    <div class="spss-widget-media-library">
      <ul>
        <li><strong>📸 Media Items:</strong> <span><?php echo esc_html($media_count) ?></span></li>
        <li><strong>🖼️ Images:</strong> <span><?php echo esc_html($image_count) ?></span></li>
        <li><strong>🎬 Videos:</strong> <span><?php echo esc_html($video_count) ?></span></li>
        <li><strong>🎵 Audio:</strong> <span><?php echo esc_html($audio_count) ?></span></li>
        <li><strong>💾 Total Size:</strong> <span><?php echo esc_html($total_size_human) ?></span></li>
        <li><strong>📏 Largest File:</strong> <span><?php echo esc_html(get_the_title($largest_file->ID)) ?> (<?php echo esc_html($largest_file_size) ?>)</span></li>
        <li><strong>📏 Smallest File:</strong> <span><?php echo esc_html(get_the_title($smallest_file->ID)) ?> (<?php echo esc_html($smallest_file_size) ?>)</span></li>
      </ul>
      <div class="spss-actions">
        <a href="<?php echo esc_url($view_all_media_url) ?>"><?php echo esc_html__('View All Media', 'stylopress') ?></a>
      </div>
    </div>
  </div>

<?php
  echo wp_kses(ob_get_clean(), array(
    'div' => array('class' => array()),
    'span' => array(),
    'ul' => array(),
    'li' => array(),
    'a' => array('href' => array(), 'title' => array()),
    'strong' => array(),
    'small' => array()
  ));
}
