<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_custom_widget_10_scripts($hook)
{
  if ($hook !== 'index.php') {
    return;
  }

  wp_enqueue_style(
    'spss-custom-widget-10-css',
    plugin_dir_url(__FILE__) . '../assets/css/spss-custom-widget-10.css',
    [],
    '1.0.0'
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_custom_widget_10_scripts');

function spss_render_custom_widget_content_widget_10()
{
  $args = array(
    'post_type' => 'post',
    'post_status' => 'draft',
    'posts_per_page' => 5,
  );
  $drafts_query = new WP_Query($args);

  ob_start(); ?>

  <div class="spss-widget-10">
    <ul class="spss-draft-posts-list">
      <?php if ($drafts_query->have_posts()) :
        while ($drafts_query->have_posts()) : $drafts_query->the_post();
          $saved_date = get_the_date();
      ?>
          <li class="spss-draft-post-item">
            <div class="spss-draft-post-thumbnail">
              <img src="<?php echo esc_url(get_the_post_thumbnail_url()); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" class="spss-draft-post-thumbnail-img" />
            </div>
            <div class="spss-draft-post-details">
              <strong><a href="<?php echo esc_url(get_edit_post_link()); ?>" class="spss-draft-post-title"><?php echo esc_html(get_the_title()); ?></a></strong>
              <br><small class="spss-draft-post-date">Saved on: <?php echo esc_html($saved_date); ?></small>
            </div>
          </li>
        <?php endwhile; ?>
      <?php else : ?>
        <p class="spss-no-draft-posts"><?php echo esc_html__('No post drafts found.', 'stylopress'); ?></p>
      <?php endif; ?>
    </ul>
  </div>
<?php
}

echo wp_kses(ob_get_clean(), array(
  'ul' => array('class' => array()),
  'li' => array('class' => array()),
  'a' => array('href' => array(), 'class' => array()),
  'strong' => array(),
  'small' => array(),
));
