<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_custom_widget_1_scripts($hook)
{
  if ($hook !== 'index.php') {
    return;
  }

  wp_enqueue_style(
    'spss-custom-widget-1-css',
    plugin_dir_url(__FILE__) . '../assets/css/spss-custom-widget-1.css',
    [],
    '1.0.0'
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_custom_widget_1_scripts');

function spss_render_custom_widget_content_widget_1()
{
  $post_counts = wp_count_posts();
  $published_count = esc_html($post_counts->publish);
  $draft_count = esc_html($post_counts->draft);
  $pending_count = esc_html($post_counts->pending);

  $view_all_posts_url = esc_url(admin_url('edit.php'));
  $add_new_post_url = esc_url(admin_url('post-new.php'));

  ob_start();
?>

  <div class="spss-widget-1">
    <div class="spss-widget-post-stats">
      <ul>
        <li><strong>📄 Published:</strong> <span><?php echo esc_html($published_count) ?></span></li>
        <li><strong>✍️ Drafts:</strong> <span><?php echo esc_html($draft_count) ?></span></li>
        <li><strong>⏳ Pending Review:</strong> <span><?php echo esc_html($pending_count) ?></span></li>
      </ul>
      <div class="spss-actions">
        <a href="<?php echo esc_url($view_all_posts_url) ?>">View All Posts</a>
        <a href="<?php echo esc_url($add_new_post_url) ?>">Add New Post</a>
      </div>
    </div>
  </div>

<?php
  echo wp_kses(ob_get_clean(), array(
    'div' => array('class' => array()),
    'span' => array(),
    'ul' => array(),
    'li' => array(),
    'a' => array('href' => array()),
    'strong' => array(),
    'span' => array()
  ));
}
