<?php

if (! defined('ABSPATH')) {
  exit;
}

define('SPSS_WIDGET_SETTINGS_PATH', plugin_dir_path(__FILE__) . 'widgets/');

require_once SPSS_WIDGET_SETTINGS_PATH . 'enqueue-scripts.php';
require_once SPSS_WIDGET_SETTINGS_PATH . 'wd-settings.php';

function spss_widgets_settings_page()
{
?>
  <div class="spss-widget-settings-container wrap">
    <h1 class="header">
      <?php esc_html_e('Widget Settings', 'stylopress'); ?>
    </h1>
    <p class="description">
      <?php esc_html_e('Select which custom widgets you want to display in the admin/user dashboard.', 'stylopress'); ?>
    </p>

    <?php
    if (isset($_POST['spss_widgets_settings_nonce'])) {
      if (!wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['spss_widgets_settings_nonce'])), 'spss_widgets_settings_action')) {
        wp_die('Security check failed');
      }
    }
    ?>

    <?php if (isset($_GET['settings-updated']) && sanitize_text_field(wp_unslash($_GET['settings-updated'])) === 'true') : ?>
      <div class="notice notice-success is-dismissible">
        <p><?php esc_html_e('Settings saved successfully.', 'stylopress'); ?></p>
      </div>
    <?php endif; ?>

    <form method="post" action="options.php">
      <?php
      settings_fields('spss_widgets_settings');
      wp_nonce_field('spss_widgets_settings_action', 'spss_widgets_settings_nonce');
      do_settings_sections('spss_widgets-settings');
      submit_button(__('Save Changes', 'stylopress'));
      ?>
    </form>
  </div>
<?php
}
