<?php

if (! defined('ABSPATH')) {
  exit;
}

function spss_get_color_scheme_css()
{
  $selected_scheme = get_option('spss_selected_color_scheme', []);
  $font_weight = get_option('spss_admin_menu_font_weight', '400');

  $default_colors = ['#1d2327', '#2c3338', '#2271b1', '#ffffff', '#72aee6'];

  $colors = isset($selected_scheme['colors']) ? $selected_scheme['colors'] : $default_colors;

  $main_menu_color = isset($colors[0]) ? $colors[0] : $default_colors[0];
  $sub_menu_color = isset($colors[1]) ? $colors[1] : $default_colors[1];
  $hover_color = isset($colors[2]) ? $colors[2] : $default_colors[2];
  $text_color = isset($colors[3]) ? $colors[3] : $default_colors[3];
  $notification_color = isset($colors[4]) ? $colors[4] : $default_colors[4];

  $dashboard_color_option = get_option('spss_custom_color_scheme_dashboard_option', '');
  $dashboard_color = empty(! $dashboard_color_option) ? $dashboard_color_option : '#f1f1f1';

  return ":root {
    --spss-admin-main-menu-color: {$main_menu_color};
    --spss-admin-sub-menu-color: {$sub_menu_color};
    --spss-admin-hover-color: {$hover_color};
    --spss-admin-text-color: {$text_color};
    --spss-admin-notification-color: {$notification_color};
    --spss-admin-text-font-weight: {$font_weight};
    --spss-admin-dashboard-color: {$dashboard_color};
  }";
}

function spss_modify_admin_menu_base64_icons_colors()
{
  global $menu;

  $color = get_option('spss_selected_scheme_icons_color', '');
  if (empty($color)) {
    $color = '#f0f0f1';
    update_option('spss_selected_scheme_icons_color', '#f0f0f1');
  }

  $custom_css = "";

  foreach ($menu as $key => $item) {
    if (isset($item[6]) && strpos($item[6], 'data:image/svg+xml;base64') !== false) {
      preg_match('/data:image\/svg\+xml;base64,([^"]+)/', $item[6], $matches);
      if (isset($matches[1])) {
        $decoded_svg = base64_decode($matches[1]);

        if ($decoded_svg !== false) {
          $updated_svg = preg_replace(
            '/(fill|stroke)="[^"]*"/i',
            '$1="' . $color . '"',
            $decoded_svg
          );

          $updated_svg = preg_replace_callback(
            '/<style[^>]*>(.*?)<\/style>/is',
            function ($matches) use ($color) {
              return preg_replace(
                '/(fill|stroke):\s*[^;]+;/i',
                '$1:' . $color . ';',
                $matches[1]
              );
            },
            $updated_svg
          );

          if (!preg_match('/fill="/i', $updated_svg) && !preg_match('/stroke="/i', $updated_svg)) {
            $updated_svg = preg_replace(
              '/<svg[^>]*>/i',
              '$0<path style="fill:' . $color . '; stroke:' . $color . ';" />',
              $updated_svg
            );
          }

          if (!preg_match('/<path.*fill=".*?"/i', $updated_svg)) {
            $updated_svg = preg_replace(
              '/<path/i',
              '<path fill="' . $color . '"',
              $updated_svg
            );
          }

          $new_base64_svg = base64_encode($updated_svg);
          if ($new_base64_svg !== false) {
            $menu[$key][6] = 'data:image/svg+xml;base64,' . $new_base64_svg;
          }

          $custom_css .= "img[src*='{$menu[$key][6]}'] { fill: {$color} !important; stroke: {$color} !important; } ";
        }
      }
    }
  }

  if (!empty($custom_css)) {
    add_action('admin_enqueue_scripts', function () use ($custom_css) {
      wp_add_inline_style('wp-admin', $custom_css);
    });
  }
}
add_action('admin_menu', 'spss_modify_admin_menu_base64_icons_colors', 999);

function spss_save_color_scheme()
{
  check_ajax_referer('spss-color-scheme-nonce', 'nonce');

  if (!current_user_can('manage_options')) {
    wp_send_json_error('Unauthorized');
  }

  if (isset($_POST['selected_scheme'])) {
    $selected_key = sanitize_text_field(wp_unslash($_POST['selected_scheme']));
    $all_schemes = get_option('spss_color_scheme_options', []);

    if (isset($all_schemes[$selected_key])) {
      $selected_scheme = $all_schemes[$selected_key];
      update_option('spss_selected_color_scheme', $selected_scheme);

      $colors = isset($selected_scheme['colors']) ? $selected_scheme['colors'] : [];

      if (!empty($colors)) {
        update_option('spss_selected_scheme_icons_color', $colors[3]);
        wp_send_json_success(['colors' => $colors]);
      }
    }
  }

  wp_send_json_error('Invalid Scheme');
}
add_action('wp_ajax_spss_save_color_scheme', 'spss_save_color_scheme');

function spss_toggle_scheme_action()
{
  check_ajax_referer('spss_nonce_action', 'nonce');
  $scheme_key = isset($_POST['scheme_key']) ? sanitize_text_field(wp_unslash($_POST['scheme_key'])) : '';
  $action_type = isset($_POST['action_type']) ? sanitize_text_field(wp_unslash($_POST['action_type'])) : '';
  $all_schemes = get_option('spss_color_scheme_options', []);

  if (isset($all_schemes[$scheme_key])) {
    if ($action_type === 'favorite') {
      $is_favourite = !($all_schemes[$scheme_key]['favourite']);
      $all_schemes[$scheme_key]['favourite'] = $is_favourite;
      update_option('spss_color_scheme_options', $all_schemes);
      wp_send_json_success([
        'favourite' => $is_favourite,
        'message' => 'Favorite status updated.',
      ]);
    } elseif ($action_type === 'delete') {
      if ($all_schemes[$scheme_key]['undeletable']) {
        wp_send_json_error([
          'message' => 'This scheme cannot be deleted.',
        ]);
      } else {
        unset($all_schemes[$scheme_key]);
        update_option('spss_color_scheme_options', $all_schemes);

        wp_send_json_success([
          'deleted' => true,
          'message' => 'Scheme deleted successfully.',
        ]);
      }
    }
  } else {
    wp_send_json_error([
      'message' => 'Scheme not found.',
    ]);
  }
  wp_die();
}
add_action('wp_ajax_toggle_scheme_action', 'spss_toggle_scheme_action');
