<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_get_or_initialize_schemes($legacy_schemes)
{
  $user_schemes = get_option('spss_color_scheme_options', []);

  if (empty($user_schemes)) {
    foreach ($legacy_schemes as $key => $scheme) {
      if (!array_key_exists($key, $user_schemes) || $user_schemes[$key] !== $scheme) {
        $user_schemes[$key] = $scheme;
      }
    }
  }

  update_option('spss_color_scheme_options', $user_schemes);
  return $user_schemes;
}

function spss_handle_form_submission()
{
  if (isset($_POST['spss_selected_color_scheme'])) {

    if (
      !isset($_POST['spss_color_scheme_nonce']) ||
      !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['spss_color_scheme_nonce'])), 'spss_color_scheme_action')
    ) {
      wp_die('Security check failed');
    }

    $selected_key = sanitize_text_field(wp_unslash($_POST['spss_selected_color_scheme']));

    $all_schemes = get_option('spss_color_scheme_options', []);

    if (isset($all_schemes[$selected_key])) {
      $selected_scheme = $all_schemes[$selected_key];
      update_option('spss_selected_color_scheme', $selected_scheme);
      $colors = isset($selected_scheme['colors']) ? $selected_scheme['colors'] : [];

      if (isset($_POST['spss_color_scheme_icons_nonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['spss_color_scheme_icons_nonce'])), 'spss_color_scheme_icons_action')) {
        if (!empty($colors)) {
          update_option('spss_selected_scheme_icons_color', $colors[3]);
        }
      } else {
        wp_die('Security check failed');
      }
    }
  }

  if (isset($_POST['spss_color_scheme_submit'])) {
    spss_color_schemes_success_message(__('Your changes have been saved!', 'stylopress'));
  }
}

function spss_color_schemes_success_message($message)
{
  echo '<div class="notice notice-success is-dismissible"><p>' . esc_html($message) . '</p></div>';
}

function spss_sort_and_update_schemes()
{
  $user_schemes = get_option('spss_color_scheme_options', []);
  $favourites = array_column($user_schemes, 'favourite');
  array_multisort($favourites, SORT_DESC, $user_schemes);
  update_option('spss_color_scheme_options', $user_schemes);
  return $user_schemes;
}

function spss_render_color_collections_page($user_schemes)
{
  $current_scheme = get_option('spss_selected_color_scheme', []);
  ob_start();
?>
  <div class="spss-color-scheme-container wrap">
    <h1 class="header">
      <?php esc_html_e('Select Color Scheme', 'stylopress'); ?>
    </h1>
    <p class="description">
      <?php esc_html_e('Choose and manage dashboard color schemes by favoriting or deleting custom ones.', 'stylopress'); ?>
    </p>
    <form id="spss-color-scheme-form" method="post">
      <?php wp_nonce_field('spss_color_scheme_action', 'spss_color_scheme_nonce'); ?>
      <?php wp_nonce_field('spss_color_scheme_icons_action', 'spss_color_scheme_icons_nonce'); ?>
      <div class="color-scheme">
        <?php
        foreach ($user_schemes as $key => $scheme):
          if (is_array($scheme) && isset($scheme['label'], $scheme['colors'])):
        ?>
            <div class="color-label-container">
              <label class="color-label">
                <input
                  type="radio"
                  name="spss_selected_color_scheme"
                  value="<?php echo esc_attr($key); ?>"
                  class="hidden-radio"
                  <?php echo ($current_scheme['label'] ?? '') === $scheme['label'] ? 'checked' : ''; ?>>
                <div class="top <?php echo ($current_scheme['label'] ?? '') === $scheme['label'] ? 'selected' : ''; ?>">
                  <?php echo esc_html($scheme['label']); ?>
                </div>
                <div class="color-squares">
                  <?php foreach ($scheme['colors'] as $color): ?>
                    <span class="color-square" data-color="<?php echo esc_attr($color); ?>"></span>
                  <?php endforeach; ?>
                </div>
              </label>
              <div class="bottom">
                <i class="fa fa-heart icon-heart <?php echo $scheme['favourite'] ? 'favorite' : ''; ?>"
                  data-scheme_color_key="<?php echo esc_attr($key); ?>" data-action="favorite" aria-hidden="true"></i>
                <input type="hidden" name="spss_favourite_status[<?php echo esc_attr($key); ?>]"
                  value="<?php echo $scheme['favourite'] ? 'true' : 'false'; ?>">
                <i class="fa fa-times icon-trash 
                  <?php echo $scheme['undeletable'] ? 'hidden' : ''; ?>
                  <?php echo $scheme['delete'] ? 'delete' : ''; ?>" data-scheme_color_key="<?php echo esc_attr($key); ?>"
                  data-action="delete" aria-hidden="true"></i>
                <input type="hidden" name="spss_delete_schemes[<?php echo esc_attr($key); ?>]"
                  value="<?php echo $scheme['delete'] ? 'true' : 'false'; ?>">
              </div>
            </div>
          <?php endif; ?>
        <?php endforeach; ?>
      </div>
      <input
        id="color-scheme-submit"
        type="submit"
        name="spss_color_scheme_submit"
        value="Save Settings"
        class="button-primary"
        disabled>
    </form>
  </div>
<?php

  $allowed_html = array(
    'div' => array('class' => array(), 'id' => array()),
    'form' => array('id' => array(), 'method' => array(), 'name' => array()),
    'h1' => array('class' => array()),
    'p' => array('class' => array()),
    'label' => array('class' => array(), 'for' => array()),
    'input' => array(
      'type' => array(),
      'name' => array(),
      'value' => array(),
      'class' => array(),
      'id' => array(),
      'checked' => array(),
      'disabled' => array()
    ),
    'span' => array('class' => array(), 'data-color' => array()),
    'i' => array(
      'class' => array(),
      'data-scheme_color_key' => array(),
      'data-action' => array(),
      'aria-hidden' => array()
    ),
    'br' => array(),
  );

  echo wp_kses(ob_get_clean(), $allowed_html);
}

function spss_disable_svg_painter_script()
{
  wp_dequeue_script('svg-painter');
  wp_add_inline_script('jquery', 'console.log("svg-painter.js script has been disabled. (StyloPress plugin)");');
}
add_action('admin_enqueue_scripts', 'spss_disable_svg_painter_script', 100);
