<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_color_scheme_styles()
{

  $plugin_dir = plugin_dir_path(__FILE__);
  $css_file = 'assets/css/spss-color-schemes-styles.css';
  $css_url = plugin_dir_url(__FILE__) . $css_file;

  wp_enqueue_style(
    'spss-color-schemes-styles',
    $css_url,
    array(),
    file_exists($plugin_dir . $css_file) ? filemtime($plugin_dir . $css_file) : false
  );

  $custom_css = spss_get_color_scheme_css();
  wp_add_inline_style('spss-color-schemes-styles', $custom_css);
}
add_action('admin_enqueue_scripts', 'spss_enqueue_color_scheme_styles');

function spss_enqueue_color_scheme_settings_scripts($hook)
{
  if ('stylopress_page_spss_color_collections' !== $hook) {
    return;
  }

  $plugin_dir = plugin_dir_path(__FILE__);
  $is_css_file_exists = file_exists($plugin_dir . 'assets/css/spss-color-schemes-page-styles.css');
  $is_js_file_exists = file_exists($plugin_dir . 'assets/javascript/spss-color-schemes-page-script.js');

  wp_enqueue_style(
    'spss-color-schemes-page-styles',
    plugin_dir_url(__FILE__) . 'assets/css/spss-color-schemes-page-styles.css',
    array(),
    $is_css_file_exists ? filemtime($plugin_dir . 'assets/css/spss-color-schemes-page-styles.css') : false
  );

  wp_enqueue_script(
    'spss-color-schemes-page-script-javascript',
    plugin_dir_url(__FILE__) . 'assets/javascript/spss-color-schemes-page-script.js',
    array('jquery'),
    $is_js_file_exists ? filemtime($plugin_dir . 'assets/javascript/spss-color-schemes-page-script.js') : false,
    true
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_color_scheme_settings_scripts');

function spss_enqueue_color_scheme_dynamic_scripts($hook)
{
  if ('stylopress_page_spss_color_collections' !== $hook) {
    return;
  }

  $plugin_dir = plugin_dir_path(__FILE__);
  $is_file_exists = file_exists($plugin_dir . 'assets/javascript/spss-color-schemes-dynamic-styles.js');

  global $spss_legacy;

  $all_schemes = get_option('spss_color_scheme_options', []);

  if (empty($all_schemes)) {
    foreach ($spss_legacy as $key => $scheme) {
      if (!array_key_exists($key, $all_schemes) || $all_schemes[$key] !== $scheme) {
        $all_schemes[$key] = $scheme;
      }
    }
  }

  $schemes_with_colors = array_map(function ($scheme) {
    return isset($scheme['colors']) ? $scheme['colors'] : [];
  }, $all_schemes);

  wp_enqueue_script(
    'spss-color-scheme-dynamic-scripts',
    plugin_dir_url(__FILE__) . 'assets/javascript/spss-color-schemes-dynamic-styles.js',
    array('jquery'),
    $is_file_exists ? filemtime($plugin_dir . 'assets/javascript/spss-color-schemes-dynamic-styles.js') : false,
    true
  );

  wp_localize_script('spss-color-scheme-dynamic-scripts', 'spssSchemes', $schemes_with_colors);
}
add_action('admin_enqueue_scripts', 'spss_enqueue_color_scheme_dynamic_scripts');

function spss_enqueue_font_awesome_icons($hook)
{
  if ('stylopress_page_spss_color_collections' !== $hook) {
    return;
  }

  $plugin_dir = plugin_dir_path(__FILE__);
  $is_file_exists = file_exists($plugin_dir . 'assets/font-awesome/css/font-awesome.min.css');

  wp_enqueue_style(
    'spss-font-awesome',
    plugin_dir_url(__FILE__) . 'assets/font-awesome/css/font-awesome.min.css',
    array(),
    $is_file_exists ? filemtime($plugin_dir . 'assets/font-awesome/css/font-awesome.min.css') : false
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_font_awesome_icons');

function spss_enqueue_ajax_color_scheme_scripts($hook)
{
  if ('stylopress_page_spss_color_collections' !== $hook) {
    return;
  }

  wp_enqueue_script(
    'spss-ajax-color-scheme',
    plugin_dir_url(__FILE__) . 'assets/javascript/spss-ajax-color-scheme.js',
    ['jquery'],
    filemtime(plugin_dir_path(__FILE__) . 'assets/javascript/spss-ajax-color-scheme.js'),
    true
  );

  wp_localize_script('spss-ajax-color-scheme', 'spss_ajax_object', [
    'ajax_url' => admin_url('admin-ajax.php'),
    'nonce' => wp_create_nonce('spss-color-scheme-nonce'),
  ]);
}
add_action('admin_enqueue_scripts', 'spss_enqueue_ajax_color_scheme_scripts');

function spss_enqueue_ajax_color_scheme_favorite_scripts($hook)
{
  if ('stylopress_page_spss_color_collections' !== $hook) {
    return;
  }

  wp_enqueue_script(
    'spss-color-scheme-action-js',
    plugin_dir_url(__FILE__) . 'assets/javascript/spss-ajax-color-scheme-action.js',
    ['jquery'],
    filemtime(plugin_dir_path(__FILE__) . 'assets/javascript/spss-ajax-color-scheme-action.js'),
    true
  );

  wp_localize_script('spss-color-scheme-action-js', 'spss_action_ajax_object', array(
    'ajax_url' => admin_url('admin-ajax.php'),
    'nonce' => wp_create_nonce('spss_nonce_action'),
  ));
}
add_action('admin_enqueue_scripts', 'spss_enqueue_ajax_color_scheme_favorite_scripts');
