/*!
 * Copyright (c) 2024 StyloPress - CodeWS.online
 * This file is part of StyloPress.
 *
 * This file is licensed under the same terms as the main plugin (GNU GPL v2 or later).
 */

jQuery(document).ready(function ($) {
	var rootDiv = '.spss-color-scheme-container';
	var isUnsaved = false;

	$(`${rootDiv} .color-square`).each(function () {
		$(this).css('background-color', $(this).attr('data-color'));
	});

	$(`${rootDiv} .color-label`).on('click', function () {
		isUnsaved = true;
		$(`${rootDiv} .color-label`).removeClass('selected');
		$(this).addClass('selected');
	});

	$(`${rootDiv} #color-scheme-submit`).prop('disabled', true);

	$(`${rootDiv} .color-label input`).on('change', function () {
		if ($(`${rootDiv} .color-label input:checked`).length > 0) {
			$(`${rootDiv} #color-scheme-submit`).prop('disabled', false);
		} else {
			$(`${rootDiv} #color-scheme-submit`).prop('disabled', true);
		}
	});

	$(`${rootDiv} .icon-trash`).on('click', function () {
		isUnsaved = true;
		const schemeKey = $(this).data('scheme_color_key');
		const hiddenInput = $(
			`input[name="spss_delete_schemes[${schemeKey}]"]`
		);
		$(this).toggleClass('delete');
		const heartIcon = $(
			`${rootDiv} .icon-heart[data-scheme_color_key="${schemeKey}"]`
		);
		if ($(this).hasClass('delete')) {
			heartIcon.removeClass('favorite');
			heartIcon.css('color', 'lightgrey');
		} else {
			heartIcon.css('color', '');
		}
		hiddenInput.val($(this).hasClass('delete') ? 'true' : 'false');
		$(`${rootDiv} #color-scheme-submit`).prop('disabled', false);
	});

	$(`${rootDiv} .icon-heart`).on('click', function () {
		isUnsaved = true;
		const schemeKey = $(this).data('scheme_color_key');
		const hiddenInput = $(
			`input[name="spss_favourite_status[${schemeKey}]"]`
		);
		const trashIcon = $(
			`${rootDiv} .icon-trash[data-scheme_color_key="${schemeKey}"]`
		);

		if (!trashIcon.hasClass('delete')) {
			$(this).toggleClass('favorite');
			hiddenInput.val($(this).hasClass('favorite') ? 'true' : 'false');
			$(this).css(
				'color',
				$(this).hasClass('favorite') ? '#9d1c00' : 'lightgrey'
			);

			$(`${rootDiv} #color-scheme-submit`).prop('disabled', false);
		}
	});

	$('#spss-color-scheme-form').on('submit', function () {
		isUnsaved = false;
	});

	$(window).on('beforeunload', function () {
		if (isUnsaved) {
			return true;
		}
	});
});
