/*!
 * Copyright (c) 2024 StyloPress - CodeWS.online
 * This file is part of StyloPress.
 *
 * This file is licensed under the same terms as the main plugin (GNU GPL v2 or later).
 */

jQuery(document).ready(function ($) {
	var defaultSceme = {
		default: ['#fff', '#000', '#fff', '#000', '#f1f'],
	};

	var colorSchemes =
		typeof spssSchemes !== 'undefined' &&
		Object.keys(spssSchemes).length > 0
			? spssSchemes
			: defaultSceme;

	$('input[name="spss_selected_color_scheme"]').on('change', function () {
		var selectedScheme = $(this).val();

		if (colorSchemes[selectedScheme]) {
			var colors = colorSchemes[selectedScheme];

			$(':root').css('--spss-admin-main-menu-color', colors[0]);
			$(':root').css('--spss-admin-sub-menu-color', colors[1]);
			$(':root').css('--spss-admin-hover-color', colors[2]);
			$(':root').css('--spss-admin-text-color', colors[3]);
			$(':root').css('--spss-admin-notification-color', colors[4]);

			$(
				'#adminmenu .wp-menu-image, #wpadminbar .ab-item, .dashicons'
			).each(function () {
				var $icon = $(this);
				var bgImage = $icon.css('background-image');

				if (
					bgImage &&
					bgImage.indexOf('data:image/svg+xml;base64') !== -1
				) {
					var encodedSVG = bgImage.match(
						/.+data:image\/svg\+xml;base64,([A-Za-z0-9\+\/\=]+)/
					);

					if (encodedSVG && encodedSVG[1]) {
						try {
							var svg = window.atob(encodedSVG[1]);
							svg = svg.replace(
								/(fill|stroke)="([^"]+)"/g,
								function (match, p1, p2) {
									return p1 + '="' + colors[3] + '"';
								}
							);

							svg = svg.replace(
								/<style[^>]*>(.*?)<\/style>/g,
								function (match, cssContent) {
									cssContent = cssContent.replace(
										/(fill|stroke):[^;]+/g,
										function (cssMatch) {
											return cssMatch.replace(
												/[^:]+$/,
												colors[3]
											);
										}
									);
									return '<style>' + cssContent + '</style>';
								}
							);

							var newEncodedSVG = window.btoa(svg);
							$icon.css(
								'background-image',
								'url("data:image/svg+xml;base64,' +
									newEncodedSVG +
									'")'
							);
						} catch (error) {
							console.error(
								'Error decoding or encoding SVG:',
								error
							);
						}
					}
				}
			});
		}
	});
});
