/*!
 * Copyright (c) 2024 StyloPress - CodeWS.online
 * This file is part of StyloPress.
 *
 * This file is licensed under the same terms as the main plugin (GNU GPL v2 or later).
 */

jQuery(document).ready(function ($) {
	$('#spss-color-scheme-form').on('submit', function (e) {
		e.preventDefault();

		var selectedScheme = $(
			'input[name="spss_selected_color_scheme"]:checked'
		).val();

		$.ajax({
			type: 'POST',
			url: spss_ajax_object.ajax_url,
			data: {
				action: 'spss_save_color_scheme',
				selected_scheme: selectedScheme,
				nonce: spss_ajax_object.nonce,
			},
			success: function (response) {
				if (response.success) {
					const colors = response.data.colors;
					$(':root').css({
						'--spss-admin-main-menu-color': colors[0],
						'--spss-admin-sub-menu-color': colors[1],
						'--spss-admin-hover-color': colors[2],
						'--spss-admin-text-color': colors[3],
						'--spss-admin-notification-color': colors[4],
					});

					if ($('#spss-notice').length) {
						$('#spss-notice').remove();
					}

					$(
						'<div id="spss-notice" class="notice notice-success is-dismissible">' +
							'<p>Settings saved successfully.</p>' +
							'</div>'
					).insertBefore('#spss-color-scheme-form');

					setTimeout(function () {
						$('#spss-notice').fadeOut(500, function () {
							$(this).remove();
						});
					}, 5000);
				} else {
					alert('Failed to save color scheme.');
				}
			},
		});
	});
});
