/*!
 * Copyright (c) 2024 StyloPress - CodeWS.online
 * This file is part of StyloPress.
 *
 * This file is licensed under the same terms as the main plugin (GNU GPL v2 or later).
 */

jQuery(document).ready(function ($) {
	$('.icon-heart, .icon-trash').on('click', function () {
		var schemeKey = $(this).data('scheme_color_key');
		var actionType = $(this).hasClass('icon-heart') ? 'favorite' : 'delete';
		var nonce = spss_action_ajax_object.nonce;
		var icon = $(this);
		icon.addClass('loading');

		$.ajax({
			type: 'POST',
			url: spss_action_ajax_object.ajax_url,
			data: {
				action: 'toggle_scheme_action',
				scheme_key: schemeKey,
				action_type: actionType,
				nonce: nonce,
			},
			success: function (response) {
				if (response.success) {
					if (actionType === 'favorite') {
						if (response.data.favourite) {
							icon.addClass('favorite');
						} else {
							icon.removeClass('favorite');
						}
					} else if (actionType === 'delete') {
						icon.closest('.color-label-container').fadeOut(
							300,
							function () {
								$(this).remove();
							}
						);
					}
				} else {
					console.log('Failed response:', response);
					alert('Failed to update scheme.');
				}
			},
			error: function (xhr, status, error) {
				console.log('Error:', error);
				alert('Error occurred while saving.');
			},
			complete: function () {
				icon.removeClass('loading');
			},
		});
	});
});
