<?php

if (! defined('ABSPATH')) {
  exit;
}

function spss_enqueue_color_scheme_creator_settings_scripts($hook)
{
  if ('stylopress_page_spss_scheme_creator' !== $hook) {
    return;
  }

  $plugin_dir = plugin_dir_path(__FILE__);
  $is_css_file_exists = file_exists($plugin_dir . 'assets/css/spss-scheme-creator-page-styles.css');

  wp_enqueue_style(
    'spss-scheme-creator-page-styles',
    plugin_dir_url(__FILE__) . 'assets/css/spss-scheme-creator-page-styles.css',
    array(),
    $is_css_file_exists ? filemtime($plugin_dir . 'assets/css/spss-scheme-creator-page-styles.css') : false
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_color_scheme_creator_settings_scripts');

function spss_enqueue_color_picker_scripts($hook)
{
  if ('stylopress_page_spss_scheme_creator' !== $hook) {
    return;
  }

  $plugin_dir = plugin_dir_path(__FILE__);
  $is_file_exists = file_exists($plugin_dir . 'assets/javascript/spss-color-picker.js');

  wp_enqueue_style('wp-color-picker');

  wp_enqueue_script(
    'spss-color-picker',
    plugin_dir_url(__FILE__) . 'assets/javascript/spss-color-picker.js',
    array('wp-color-picker'),
    $is_file_exists ? filemtime($plugin_dir . 'assets/javascript/spss-color-picker.js') : false,
    true
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_color_picker_scripts');

function spss_enqueue_custom_color_scheme_dynamic_scripts($hook)
{
  if ('stylopress_page_spss_scheme_creator' !== $hook) {
    return;
  }

  $plugin_dir = plugin_dir_path(__FILE__);
  $is_file_exists = file_exists($plugin_dir . 'assets/javascript/spss-color-scheme-custom-dynamic-styles.js');

  wp_enqueue_script(
    'spss-color-scheme-custom-dynamic-scripts',
    plugin_dir_url(__FILE__) . 'assets/javascript/spss-color-scheme-custom-dynamic-styles.js',
    array('jquery'),
    $is_file_exists ? filemtime($plugin_dir . 'assets/javascript/spss-color-scheme-custom-dynamic-styles.js') : false,
    true
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_custom_color_scheme_dynamic_scripts');
