/*!
 * Copyright (c) 2024 StyloPress - CodeWS.online
 * This file is part of StyloPress.
 *
 * This file is licensed under the same terms as the main plugin (GNU GPL v2 or later).
 */

jQuery(document).ready(function ($) {
	$('.spss-color-picker').wpColorPicker({
		change: function (event, ui) {
			const colorId = $(this).attr('id');
			const colorValue = ui.color.toString();

			if (colorId === 'spss_admin_main_menu_color') {
				$(':root').css('--spss-admin-main-menu-color', colorValue);
			} else if (colorId === 'spss_admin_sub_menu_color') {
				$(':root').css('--spss-admin-sub-menu-color', colorValue);
			} else if (colorId === 'spss_admin_hover_color') {
				$(':root').css('--spss-admin-hover-color', colorValue);
			} else if (colorId === 'spss_admin_text_color') {
				$(':root').css('--spss-admin-text-color', colorValue);
				base64Painter(colorValue);
			} else if (colorId === 'spss_admin_notification_color') {
				$(':root').css('--spss-admin-notification-color', colorValue);
			} else if (colorId === 'spss_admin_dashboard_color') {
				$(':root').css('--spss-admin-dashboard-color', colorValue);
			}
		},
	});

	function base64Painter(colorValue = '#fff') {
		$('#adminmenu .wp-menu-image, #wpadminbar .ab-item, .dashicons').each(
			function () {
				var $icon = $(this);
				var bgImage = $icon.css('background-image');

				if (
					bgImage &&
					bgImage.indexOf('data:image/svg+xml;base64') !== -1
				) {
					var encodedSVG = bgImage.match(
						/.+data:image\/svg\+xml;base64,([A-Za-z0-9\+\/\=]+)/
					);

					if (encodedSVG && encodedSVG[1]) {
						try {
							var svg = window.atob(encodedSVG[1]);

							svg = svg
								.replace(
									/fill="(.+?)"/g,
									'fill="' + colorValue + '"'
								)
								.replace(
									/stroke="(.+?)"/g,
									'stroke="' + colorValue + '"'
								)
								.replace(
									/style="(.+?)"/g,
									'style="fill:' +
										colorValue +
										'; stroke:' +
										colorValue +
										'"'
								);

							var newEncodedSVG = window.btoa(svg);
							$icon.css(
								'background-image',
								'url("data:image/svg+xml;base64,' +
									newEncodedSVG +
									'")'
							);
						} catch (error) {
							console.error(
								'Error decoding or encoding SVG:',
								error
							);
						}
					}
				}
			}
		);
	}
});
