<?php

if (!defined('ABSPATH')) {
  exit;
}

define('SPSS_SCHEME_CREATOR_PATH', plugin_dir_path(__FILE__) . 'scheme-creator/');

require_once SPSS_SCHEME_CREATOR_PATH . 'enqueue-scripts.php';
require_once SPSS_SCHEME_CREATOR_PATH . 'wp-simulator.php';

function spss_register_scheme_creator_settings()
{
  register_setting('spss_scheme_creator_group', 'spss_scheme_creator_options', 'spss_scheme_creator_validate');

  add_settings_section(
    'spss_scheme_creator_section',
    '',
    '',
    'spss_scheme_creator'
  );

  add_settings_field(
    'spss_admin_main_menu_color',
    __('Main Menu Background Color', 'stylopress') .
      '<p class="description">' . esc_html__('Choose the background color for the main admin dashboard menu.', 'stylopress') . '</p>',
    function () {
      $options = get_option('spss_scheme_creator_options');
      $field_id = 'spss_admin_main_menu_color';
      $value = isset($options[$field_id]) ? esc_attr($options[$field_id]) : '';
      if (spss_fs()->is_premium()) { ?>
      <div>
        <input type="text" id="<?php echo esc_attr($field_id); ?>"
          name="spss_scheme_creator_options[<?php echo esc_attr($field_id); ?>]"
          value="<?php echo esc_attr($value); ?>" class="spss-color-picker" />
      </div>
    <?php
      }
      if (spss_fs()->is_free_plan()) { ?>
      <div>
        <input type="text" id="<?php echo esc_attr($field_id); ?>"
          name="spss_scheme_creator_options[<?php echo esc_attr($field_id); ?>]"
          value="<?php echo esc_attr($value); ?>" disabled />
      </div>
    <?php
      }
    },
    'spss_scheme_creator',
    'spss_scheme_creator_section'
  );

  add_settings_field(
    'spss_admin_sub_menu_color',
    __('Sub Menu Background Color', 'stylopress') .
      '<p class="description">' . esc_html__('Select the background color for submenu items in the dashboard.', 'stylopress') . '</p>',
    function () {
      $options = get_option('spss_scheme_creator_options');
      $field_id = 'spss_admin_sub_menu_color';
      $value = isset($options[$field_id]) ? esc_attr($options[$field_id]) : '';
      if (spss_fs()->is_premium()) {
    ?>
      <div>
        <input type="text" id="<?php echo esc_attr($field_id); ?>"
          name="spss_scheme_creator_options[<?php echo esc_attr($field_id); ?>]"
          value="<?php echo esc_attr($value); ?>" class="spss-color-picker" />
      </div>
    <?php
      }
      if (spss_fs()->is_free_plan()) {
    ?>
      <div>
        <input type="text" id="<?php echo esc_attr($field_id); ?>"
          name="spss_scheme_creator_options[<?php echo esc_attr($field_id); ?>]"
          value="<?php echo esc_attr($value); ?>" disabled />
      </div>
    <?php
      }
    },
    'spss_scheme_creator',
    'spss_scheme_creator_section'
  );

  add_settings_field(
    'spss_admin_hover_color',
    __('Hover Color', 'stylopress') .
      '<p class="description">' . esc_html__('Pick the color for hover effects and buttons.', 'stylopress') . '</p>',
    function () {
      $options = get_option('spss_scheme_creator_options');
      $field_id = 'spss_admin_hover_color';
      $value = isset($options[$field_id]) ? esc_attr($options[$field_id]) : '';
      if (spss_fs()->is_premium()) {
    ?>
      <div>
        <input type="text" id="<?php echo esc_attr($field_id); ?>"
          name="spss_scheme_creator_options[<?php echo esc_attr($field_id); ?>]"
          value="<?php echo esc_attr($value); ?>" class="spss-color-picker" />
      </div>
    <?php
      }
      if (spss_fs()->is_free_plan()) {
    ?>
      <div>
        <input type="text" id="<?php echo esc_attr($field_id); ?>"
          name="spss_scheme_creator_options[<?php echo esc_attr($field_id); ?>]"
          value="<?php echo esc_attr($value); ?>" disabled />
      </div>
    <?php
      }
    },
    'spss_scheme_creator',
    'spss_scheme_creator_section'
  );

  add_settings_field(
    'spss_admin_text_color',
    __('Text Color', 'stylopress') .
      '<p class="description">' . esc_html__('Set the text color for the main menu items.', 'stylopress') . '</p>',
    function () {
      $options = get_option('spss_scheme_creator_options');
      $field_id = 'spss_admin_text_color';
      $value = isset($options[$field_id]) ? esc_attr($options[$field_id]) : '';
      if (spss_fs()->is_premium()) {
    ?>
      <div>
        <input type="text" id="<?php echo esc_attr($field_id); ?>"
          name="spss_scheme_creator_options[<?php echo esc_attr($field_id); ?>]"
          value="<?php echo esc_attr($value); ?>" class="spss-color-picker" />
      </div>
    <?php
      }
      if (spss_fs()->is_free_plan()) {
    ?>
      <div>
        <input type="text" id="<?php echo esc_attr($field_id); ?>"
          name="spss_scheme_creator_options[<?php echo esc_attr($field_id); ?>]"
          value="<?php echo esc_attr($value); ?>" disabled />
      </div>
    <?php
      }
    },
    'spss_scheme_creator',
    'spss_scheme_creator_section'
  );

  add_settings_field(
    'spss_admin_notification_color',
    __('Notification Color', 'stylopress') .
      '<p class="description">' . esc_html__('Define the color for notifications.', 'stylopress') . '</p>',
    function () {
      $options = get_option('spss_scheme_creator_options');
      $field_id = 'spss_admin_notification_color';
      $value = isset($options[$field_id]) ? esc_attr($options[$field_id]) : '';
      if (spss_fs()->is_premium()) {
    ?>
      <div>
        <input type="text" id="<?php echo esc_attr($field_id); ?>"
          name="spss_scheme_creator_options[<?php echo esc_attr($field_id); ?>]"
          value="<?php echo esc_attr($value); ?>" class="spss-color-picker" />
      </div>
    <?php
      }
      if (spss_fs()->is_free_plan()) {
    ?>
      <div>
        <input type="text" id="<?php echo esc_attr($field_id); ?>"
          name="spss_scheme_creator_options[<?php echo esc_attr($field_id); ?>]"
          value="<?php echo esc_attr($value); ?>" disabled />
      </div>
    <?php
      }
    },
    'spss_scheme_creator',
    'spss_scheme_creator_section'
  );

  add_settings_field(
    'spss_admin_dashboard_color',
    __('Dashboard Background Color', 'stylopress') .
      '<p class="description">' . esc_html__('Choose the background color of the dashboard.', 'stylopress') . '</p>',
    function () {
      $options = get_option('spss_scheme_creator_options');
      $field_id = 'spss_admin_dashboard_color';
      $value = isset($options[$field_id]) ? esc_attr($options[$field_id]) : '';
      if (spss_fs()->is_premium()) {
    ?>
      <div>
        <input type="text" id="<?php echo esc_attr($field_id); ?>"
          name="spss_scheme_creator_options[<?php echo esc_attr($field_id); ?>]"
          value="<?php echo esc_attr($value); ?>" class="spss-color-picker" />
      </div>
    <?php
      }
      if (spss_fs()->is_free_plan()) {
    ?>
      <div>
        <input type="text" id="<?php echo esc_attr($field_id); ?>"
          name="spss_scheme_creator_options[<?php echo esc_attr($field_id); ?>]"
          value="<?php echo esc_attr($value); ?>" disabled />
      </div>
    <?php
      }
    },
    'spss_scheme_creator',
    'spss_scheme_creator_section'
  );

  add_settings_field(
    'spss_admin_is_favorite',
    __('Mark as Favorite', 'stylopress') .
      '<p class="description">' . esc_html__('Mark this scheme as a favorite to quickly access it later.', 'stylopress') . '</p>',
    function () {
      $options = get_option('spss_scheme_creator_options');
      $field_id = 'spss_admin_is_favorite';
      $value = isset($options[$field_id]) ? esc_attr($options[$field_id]) : '';
      if (spss_fs()->is_premium()) {
    ?>
      <div>
        <input type="checkbox" id="<?php echo esc_attr($field_id); ?>"
          name="spss_scheme_creator_options[<?php echo esc_attr($field_id); ?>]"
          value="1" <?php checked(1, $value, true); ?> />
      </div>
    <?php
      }
      if (spss_fs()->is_free_plan()) {
    ?>
      <div>
        <input type="checkbox" id="<?php echo esc_attr($field_id); ?>"
          name="spss_scheme_creator_options[<?php echo esc_attr($field_id); ?>]"
          value="1" disabled <?php checked(1, $value, true); ?> />
      </div>
    <?php
      }
    },
    'spss_scheme_creator',
    'spss_scheme_creator_section'
  );

  add_settings_field(
    'spss_admin_scheme_label',
    __('Color Scheme Label', 'stylopress') .
      '<p class="description">' . esc_html__('Provide a name for your custom color scheme.', 'stylopress') . '</p>',
    function () {
      $options = get_option('spss_scheme_creator_options');
      $field_id = 'spss_admin_scheme_label';
      $value = isset($options[$field_id]) ? esc_attr($options[$field_id]) : '';
      if (spss_fs()->is_premium()) {
    ?>
      <div>
        <input type="text" id="<?php echo esc_attr($field_id); ?>"
          name="spss_scheme_creator_options[<?php echo esc_attr($field_id); ?>]"
          value="<?php echo esc_attr($value); ?>" required />
      </div>
    <?php
      }
      if (spss_fs()->is_free_plan()) {
    ?>
      <div>
        <input type="text" id="<?php echo esc_attr($field_id); ?>"
          name="spss_scheme_creator_options[<?php echo esc_attr($field_id); ?>]"
          value="<?php echo esc_attr($value); ?>" required disabled />
      </div>
  <?php
      }
    },
    'spss_scheme_creator',
    'spss_scheme_creator_section'
  );
}
add_action('admin_init', 'spss_register_scheme_creator_settings');

function spss_scheme_creator_validate($input)
{
  foreach ($input as $key => $value) {
    if (empty($value)) {
      add_settings_error(
        'spss_scheme_creator_options',
        'spss_scheme_creator_error',
        __('All fields must be filled before submitting.', 'stylopress'),
        'error'
      );
      return $input;
    }
  }

  $default_colors = [
    sanitize_hex_color($input['spss_admin_main_menu_color']),
    sanitize_hex_color($input['spss_admin_sub_menu_color']),
    sanitize_hex_color($input['spss_admin_hover_color']),
    sanitize_hex_color($input['spss_admin_text_color']),
    sanitize_hex_color($input['spss_admin_notification_color']),
  ];

  $dashboard_color = sanitize_hex_color($input['spss_admin_dashboard_color']);

  update_option('spss_custom_color_scheme_options', $default_colors);
  update_option('spss_custom_color_scheme_dashboard_option', $dashboard_color);

  $all_schemes = get_option('spss_color_scheme_options', []);

  $spss_scheme_key = sanitize_title($input['spss_admin_scheme_label']);

  $spss_is_favorite = isset($input['spss_admin_is_favorite']) ? (bool)$input['spss_admin_is_favorite'] : false;

  foreach ($all_schemes as $scheme) {
    if (isset($scheme['label']) && $scheme['label'] === $input['spss_admin_scheme_label']) {
      add_settings_error(
        'spss_scheme_creator_options',
        'spss_scheme_creator_error',
        __('This color scheme name already exists. Please choose another name.', 'stylopress'),
        'error'
      );
      return $input;
    }
  }

  $new_user_scheme = [
    $spss_scheme_key => [
      'label' => $input['spss_admin_scheme_label'],
      'colors' => $default_colors,
      'favourite' => $spss_is_favorite,
      'delete' => false,
      'undeletable' => false,
    ]
  ];

  $all_schemes += $new_user_scheme;
  spss_sort_and_update_color_schemes($all_schemes);

  add_settings_error(
    'spss_scheme_creator_options',
    'spss_scheme_creator_success',
    __('Settings saved successfully! Your custom color scheme was added to Scheme Collections.', 'stylopress'),
    'success'
  );

  return $input;
}

function spss_sort_and_update_color_schemes($schemes)
{
  $favourites = array_column($schemes, 'favourite');
  array_multisort($favourites, SORT_DESC, $schemes);
  update_option('spss_color_scheme_options', $schemes);
}

function spss_scheme_creator_page()
{
  ?>
  <div class="spss-color-scheme-creator-main-container wrap">
    <div class="spss-color-scheme-creator-container">
      <h1 class="header">
        <?php esc_html_e('Add New Color Scheme', 'stylopress'); ?>
      </h1>
      <p class="description">
        <?php esc_html_e('Create a custom color scheme for your WordPress admin dashboard.', 'stylopress'); ?>
      </p>
      <p class="description">
        <?php if (spss_fs()->is_free_plan()) : ?>
          <span class="premium"><?php esc_html_e('Available only for premium users.', 'stylopress'); ?></span>
        <?php endif; ?>
      </p>
      <?php
      settings_errors('spss_scheme_creator_options');
      ?>
      <form method="post" action="options.php">
        <?php
        settings_fields('spss_scheme_creator_group');
        do_settings_sections('spss_scheme_creator');
        if (spss_fs()->is_free_plan()) {
          submit_button('Save Changes', true, 'submit', true, ['disabled' => true]);
        } else {
          submit_button();
        }
        ?>
      </form>
    </div>
    <div class="spss-wp-simulator-main-container">
      <?php
      spss_render_wp_simulator_page();
      ?>
    </div>
  </div>
<?php
}
