<?php

if (! defined('ABSPATH')) {
  exit;
}

function spss_news_updates_page()
{
?>
  <div class="spss-news-updates-container wrap">
    <h1 class="header">
      <?php esc_html_e('News and Updates', 'stylopress'); ?>
    </h1>
    <p class="description">
      <?php esc_html_e('Get the latest news and updates of StyloPress plugin.', 'stylopress'); ?>
    </p>
    <div class="content">
      <div class="news">
        <div class="logo">
          <img src="<?php echo esc_url(plugin_dir_url(__FILE__) . 'assets/images/stylopress-logo.png'); ?>" alt="Recommendation Image">
        </div>
        <h3><?php esc_html_e('Latest News:', 'stylopress'); ?></h3>
        <ul class="list-styled">
          <li>
            <?php esc_html_e('StyloPress is officially live! Your ultimate WordPress customization tool is here.', 'stylopress'); ?>
          </li>
          <li>
            <?php esc_html_e('Be among the first to experience advanced login page and admin panel customization.', 'stylopress'); ?>
          </li>
        </ul>
        <h3><?php esc_html_e('Version Release New Updates:', 'stylopress'); ?></h3>
        <ul class="list-styled">
          <li>
            <?php esc_html_e('StyloPress v1.0 is here! Packed with powerful features like login page customization, +50 admin panel color schemes, and +15 dashboard custom widgets.', 'stylopress'); ?>
          </li>
          <li>
            <?php esc_html_e('Initial release focuses on user-friendly customization and real-time previews to make designing your WordPress site effortless.', 'stylopress'); ?>
          </li>
          <li>
            <?php esc_html_e('Stay tuned for upcoming updates as we introduce more widgets, color schemes, and advanced customization options.', 'stylopress'); ?>
          </li>
        </ul>
        <h3><?php esc_html_e('Resources & Support:', 'stylopress'); ?></h3>
        <ul>
          <li>
            <a class="external-link" href="https://codews.online/stylopress/" target="_blank">
              <?php esc_html_e('Plugin Features', 'stylopress'); ?> 🔗
            </a>
          </li>
          <li>
            <span class="external-link">
              <?php esc_html_e('Documentation', 'stylopress'); ?> <small>(Coming Soon)</small>
            </span>
          </li>
          <li>
            <a class="external-link" href="https://wordpress.org/plugins/stylopress/" target="_blank">
              <?php esc_html_e('WordPress Plugin Page', 'stylopress'); ?> 🔗
            </a>
          </li>
          <li>
            <a class="external-link" href="https://codews.online/faq/" target="_blank">
              <?php esc_html_e('Frequently Asked Questions', 'stylopress'); ?> 🔗
            </a>
          </li>
          <li>
            <a class="external-link" href="https://codews.online/contact/" target="_blank">
              <?php esc_html_e('Get in Touch', 'stylopress'); ?> 🔗
            </a>
          </li>
          <li>
            <a class="external-link" href="https://codews.online/gallery/" target="_blank">
              <?php esc_html_e('Inspiration Gallery', 'stylopress'); ?> 🔗
            </a>
          </li>
        </ul>
        <p>
          <span class="note">Note: </span> <?php echo esc_html('StyloPress is in beta and we\'re actively working on improvements. You might encounter some bugs, but we appreciate your patience. Feel free to reach out with any issues or suggestions—your feedback is crucial for future updates. 😊'); ?>
        </p>
      </div>
      <div class="notes-content">
        <h3><?php esc_html_e('Plugin Features:', 'stylopress'); ?></h3>
        <ul>
          <li>
            <span class="strong"><?php esc_html_e('✅ Effortless Styling: ', 'stylopress'); ?></span>
            <?php esc_html_e('Customize & style login and admin pages.', 'stylopress'); ?>
          </li>
          <li>
            <span class="strong"><?php esc_html_e('✅ Real-Time Preview: ', 'stylopress'); ?></span>
            <?php esc_html_e('See live changes in the WordPress Customizer.', 'stylopress'); ?>
          </li>
          <li>
            <span class="strong"><?php esc_html_e('✅ No-Code Design: ', 'stylopress'); ?></span>
            <?php esc_html_e('Enjoy creative freedom without programming.', 'stylopress'); ?>
          </li>
          <li>
            <span class="strong"><?php esc_html_e('✅ Vibrant Schemes: ', 'stylopress'); ?></span>
            <?php esc_html_e('Access +50 dynamic admin menu color schemes.', 'stylopress'); ?>
          </li>
          <li>
            <span class="strong"><?php esc_html_e('✅ Custom Color Schemes: ', 'stylopress'); ?></span>
            <?php esc_html_e('Match your admin panel to your brand.', 'stylopress'); ?>
          </li>
          <li>
            <span class="strong"><?php esc_html_e('✅ Dashboard Widgets: ', 'stylopress'); ?></span>
            <?php esc_html_e('Access +15 free custom widgets to enhance your workflow.', 'stylopress'); ?>
          </li>
          <li>
            <span class="strong"><?php esc_html_e('✅ Admin Panel Settings: ', 'stylopress'); ?></span>
            <?php esc_html_e('Manage menus, roles, and more easily.', 'stylopress'); ?>
          </li>
          <li>
            <span class="strong"><?php esc_html_e('✅ Google Fonts: ', 'stylopress'); ?></span>
            <?php esc_html_e('Customize the login page with your favorite fonts.', 'stylopress'); ?>
          </li>
        </ul>
        <h3><?php esc_html_e('Ongoing Free Benefits:', 'stylopress'); ?></h3>
        <ul>
          <li>
            <span class="strong"><?php esc_html_e('✅ Regular Updates: ', 'stylopress'); ?></span>
            <?php esc_html_e('Monthly features and improvements at no cost.', 'stylopress'); ?>
          </li>
          <li>
            <span class="strong"><?php esc_html_e('✅ Fresh Widgets: ', 'stylopress'); ?></span>
            <?php esc_html_e('More dashboard widgets will be added, for free.', 'stylopress'); ?>
          </li>
          <li>
            <span class="strong"><?php esc_html_e('✅ New Color Schemes: ', 'stylopress'); ?></span>
            <?php esc_html_e('Free new schemes every month.', 'stylopress'); ?>
          </li>
        </ul>
        <h3><?php esc_html_e('Plans for Every User:', 'stylopress'); ?></h3>
        <p class="bold"><?php esc_html_e('Unlock full access to all features for unparalleled design flexibility.', 'stylopress'); ?></p>
        <ul>
          <li>
            <span class="strong"><?php esc_html_e('✅ Pro Plan: ', 'stylopress'); ?></span>
            <?php esc_html_e('Perfect for personal websites at just $2.99/month.', 'stylopress'); ?>
          </li>
          <li>
            <span class="strong"><?php esc_html_e('✅ Freelancer Plan: ', 'stylopress'); ?></span>
            <?php esc_html_e('Manage up to 10 sites for $8.99/month.', 'stylopress'); ?>
          </li>
          <li>
            <span class="strong"><?php esc_html_e('✅ Agency Plan: ', 'stylopress'); ?></span>
            <?php esc_html_e('Get access to up to 25 sites for only $19.99/month.', 'stylopress'); ?>
          </li>
        </ul>
        <p>
          <a class="external-link" href="https://codews.online/pricing/" target="_blank">
            <?php esc_html_e('👉 Upgrade Now and experience the full power of StyloPress!', 'stylopress'); ?>
          </a>
        </p>
        <h3><?php esc_html_e('User Feedback:', 'stylopress'); ?></h3>
        <ul class="list-styled">
          <li>
            <?php esc_html_e('We value your feedback!', 'stylopress'); ?>
          </li>
          <li>
            <?php esc_html_e('Share your thoughts to shape StyloPress\'s future updates.', 'stylopress'); ?>
          </li>
          <li>
            <a href="mailto:contact@codews.online">
              <?php esc_html_e('Send us an email to suggest new features or report issues.', 'stylopress'); ?>
            </a>
          </li>
        </ul>
      </div>
      <div class="gallery">
        <h3><?php esc_html_e('Inspiration Gallery:', 'stylopress'); ?></h3>
        <p class="bold">
          <?php esc_html_e('Looking for ideas to enhance your WordPress experience?', 'stylopress'); ?>
        </p>
        <p>
          <?php esc_html_e('Explore our Inspiration Gallery featuring beautifully designed login pages and admin dashboards customized using StyloPress.', 'stylopress'); ?>
        </p>
        <p>
          <a class="external-link" href="https://codews.online/gallery/" target="_blank">
            <?php esc_html_e('👉 Visit the Inspiration Gallery and start customizing today!', 'stylopress'); ?>
          </a>
        </p>
        <div class="images-container">
          <img src="<?php echo esc_url(plugin_dir_url(__FILE__) . 'assets/images/gallery1.jpg'); ?>" alt="Gallery">
          <img src="<?php echo esc_url(plugin_dir_url(__FILE__) . 'assets/images/gallery2.jpg'); ?>" alt="Gallery">
          <img src="<?php echo esc_url(plugin_dir_url(__FILE__) . 'assets/images/stylopress-footer.png'); ?>" alt="Footer Image">
        </div>
      </div>
    </div>
  </div>
<?php
}
