<?php

if (! defined('ABSPATH')) {
  exit;
}

function spss_general_settings_page()
{
?>
  <div class="spss-news-updates-container wrap">
    <h1 class="header">
      <?php esc_html_e('General Settings', 'stylopress'); ?>
    </h1>
    <p class="description">
      <?php esc_html_e('Manage core plugin options, including resetting customizer settings and removing data on uninstall.', 'stylopress'); ?>
    </p>

    <?php
    if (isset($_POST['spss_general_settings_nonce'])) {
      $nonce = isset($_POST['spss_general_settings_nonce']) ? sanitize_text_field(wp_unslash($_POST['spss_general_settings_nonce'])) : '';
      if (!wp_verify_nonce($nonce, 'spss_general_settings_action')) {
        wp_die('Security check failed');
      }
    }
    ?>

    <?php if (
      isset($_GET['settings-updated']) &&
      sanitize_text_field(wp_unslash($_GET['settings-updated'])) === 'true'
    ) : ?>
      <div class="notice notice-success is-dismissible">
        <p><?php esc_html_e('Settings saved successfully.', 'stylopress'); ?></p>
      </div>
    <?php endif; ?>

    <form method="post" action="options.php">
      <?php
      settings_fields('spss_plugin_general_settings');
      wp_nonce_field('spss_general_settings_action', 'spss_general_settings_nonce');
      do_settings_sections('spss_plugin_general_settings');
      submit_button(__('Save Changes', 'stylopress'));
      ?>
    </form>
  </div>
<?php
  spss_register_plugin_general_settings();
}

function spss_register_plugin_general_settings()
{
  spss_reset_lp_customizer_settings();
  spss_remove_settings_on_uninstall_settings();
}
add_action('admin_init', 'spss_register_plugin_general_settings');

function spss_reset_lp_customizer_settings()
{
  register_setting('spss_plugin_general_settings', 'spss_reset_lp_customizer', array(
    'type'              => 'string',
    'sanitize_callback' => 'spss_sanitize_reset_lp_checkbox',
  ));

  add_settings_section(
    'spss_reset_lp_customizer_settings_section',
    __('Reset Login Page Settings', 'stylopress'),
    function () {
      echo '<p class="spss-general-settings-reset-lp-p">' . esc_html__('Reset Login Page Customizer Settings.', 'stylopress') . '</p>';
      echo '<small><span class="spss-general-settings-reset-lp-span">' .
        esc_html__('Warning: All login page customizations will revert to the default WordPress login page upon saving changes.', 'stylopress') . '</span></small>';
    },
    'spss_plugin_general_settings'
  );

  add_settings_field(
    'spss_reset_lp_customizer',
    __('Reset Login Page Settings', 'stylopress'),
    'spss_render_reset_customizer_field',
    'spss_plugin_general_settings',
    'spss_reset_lp_customizer_settings_section'
  );
}

function spss_sanitize_reset_lp_checkbox($input)
{
  return $input === '1' ? '1' : '0';
}

function spss_remove_settings_on_uninstall_settings()
{
  register_setting('spss_plugin_general_settings', 'spss_remove_settings_uninstall', array(
    'type'              => 'string',
    'sanitize_callback' => 'spss_sanitize_options_remover_checkbox',
  ));

  add_settings_section(
    'spss_remove_settings_on_uninstall_section',
    __('Remove Settings on Uninstall', 'stylopress'),
    function () {
      echo '<p class="spss-general-settings-remove-options-p">' . esc_html__('Remove all settings when uninstalling the plugin.', 'stylopress') . '</p>';
      echo '<small><span class="spss-general-settings-remove-options-span">' . esc_html__('Enabling this option will remove all custom settings and preferences upon plugin uninstallation.', 'stylopress') . '</span></small>';
    },
    'spss_plugin_general_settings'
  );

  add_settings_field(
    'spss_remove_settings_uninstall',
    __('Remove Settings on Uninstall', 'stylopress'),
    'spss_render_remove_settings_field',
    'spss_plugin_general_settings',
    'spss_remove_settings_on_uninstall_section'
  );
}

function spss_sanitize_options_remover_checkbox($input)
{
  return $input === '1' ? '1' : '0';
}

function spss_render_reset_customizer_field()
{
  $option = get_option('spss_reset_lp_customizer', false);
?>
  <input type="checkbox" name="spss_reset_lp_customizer" value="1" <?php checked($option, true); ?>>
  <span class="description">
    <?php esc_html_e('Enable', 'stylopress'); ?><br>
  </span>
<?php
}

function spss_render_remove_settings_field()
{
  $option = get_option('spss_remove_settings_uninstall', true);
?>
  <input type="checkbox" name="spss_remove_settings_uninstall" value="1" <?php checked($option, true); ?>>
  <span class="description">
    <?php esc_html_e('Enable', 'stylopress'); ?>
  </span>
<?php
}

function spss_reset_customizer_defaults()
{
  $reset_enabled = get_option('spss_reset_lp_customizer', false);

  if ($reset_enabled) {
    set_theme_mod('spss_google_font_family', 'Open Sans');
    set_theme_mod('spss_google_font_weight', '400');
    set_theme_mod('spss_enable_local_fonts', false);
    set_theme_mod('spss_cleanup_local_fonts', false);
    set_theme_mod('spss_logo_image', plugin_dir_url(__FILE__) . 'assets/images/default-logo.png');
    set_theme_mod('spss_logo_width', 100);
    set_theme_mod('spss_logo_height', 100);
    set_theme_mod('spss_disable_logo', false);
    set_theme_mod('spss_logo_rotation_enabled', false);
    set_theme_mod('spss_logo_rotation_speed', 61);
    set_theme_mod('spss_form_transparency', false);
    set_theme_mod('spss_form_background_color', '#ffffff');
    set_theme_mod('spss_form_background_image', '');
    set_theme_mod('spss_form_image_background_size', 'cover');
    set_theme_mod('spss_form_image_background_position', 'center');
    set_theme_mod('spss_form_image_background_repeat', 'no-repeat');
    set_theme_mod('spss_form_width', 340);
    set_theme_mod('spss_form_shadow', 0);
    set_theme_mod('spss_form_shadow_opacity', '0.5');
    set_theme_mod('spss_form_shadow_color', '#000000');
    set_theme_mod('spss_form_padding', 25);
    set_theme_mod('spss_form_margin_top', 20);
    set_theme_mod('spss_form_border_width', 1);
    set_theme_mod('spss_form_border_style', 'solid');
    set_theme_mod('spss_form_border_color', '#a2a0a0');
    set_theme_mod('spss_form_border_radius', 0);
    set_theme_mod('spss_background_video', '');
    set_theme_mod('spss_input_label_color', '#333333');
    set_theme_mod('spss_input_label_font_size', '13');
    set_theme_mod('spss_remember_me_toggle_display', false);
    set_theme_mod('spss_input_field_transparency_mode', false);
    set_theme_mod('spss_input_field_background_color', '#ffffff');
    set_theme_mod('spss_input_field_border_radius', 5);
    set_theme_mod('spss_input_field_border_color', '#2c3338');
    set_theme_mod('spss_input_field_border_width', 1);
    set_theme_mod('spss_input_field_border_bottom', false);
    set_theme_mod('spss_input_field_text_color', '#000000');
    set_theme_mod('spss_input_field_border_style', 'solid');
    set_theme_mod('spss_input_field_password_eye_color', '#000000');
    set_theme_mod('spss_input_field_password_eye_color_hover', '#000000');
    set_theme_mod('spss_button_color', '#0073aa');
    set_theme_mod('spss_button_color_hover', '#005177');
    set_theme_mod('spss_button_border_width', 1);
    set_theme_mod('spss_button_border_color', '#036391');
    set_theme_mod('spss_button_border_radius', 2);
    set_theme_mod('spss_button_border_style', 'solid');
    set_theme_mod('spss_button_text_size', 13);
    set_theme_mod('spss_button_text_color', '#ffffff');
    set_theme_mod('spss_button_text_color_hover', '#ffffff');
    set_theme_mod('spss_button_text_style', 'capitalize');
    set_theme_mod('spss_button_text_weight', 'normal');
    set_theme_mod('spss_button_top_margin', 0);
    set_theme_mod('spss_button_width', 25);
    set_theme_mod('spss_button_transparency_mode', false);
    set_theme_mod('spss_background_color', '#f0f0f1');
    set_theme_mod('spss_background_image', '');
    set_theme_mod('spss_background_position', 'center center');
    set_theme_mod('spss_background_image_size', 'cover');
    set_theme_mod('spss_background_repeat', 'no-repeat');
    set_theme_mod('spss_background_image_mobile', '');
    set_theme_mod('spss_background_border_width', 100);
    set_theme_mod('spss_background_border_height', 100);
    set_theme_mod('spss_background_overlay_color', '#000000');
    set_theme_mod('spss_background_overlay_opacity', '0.0');
    set_theme_mod('spss_notice_transparency', false);
    set_theme_mod('spss_notice_background_color', '#ffffff');
    set_theme_mod('spss_notice_text_color', '#000000');
    set_theme_mod('spss_notice_font_size', 13);
    set_theme_mod('spss_notice_border_left_width', 4);
    set_theme_mod('spss_notice_border_radius', 0);
    set_theme_mod('spss_notice_border_color', '#ffffff');
    set_theme_mod('spss_notice_info_left_border_color', '#72aee6');
    set_theme_mod('spss_notice_error_left_border_color', '#d63638');
    set_theme_mod('spss_footer_first_label_display', false);
    set_theme_mod('spss_footer_second_label_display', false);
    set_theme_mod('spss_footer_label_font_size', 11);
    set_theme_mod('spss_footer_text_color', '#000000');
    set_theme_mod('spss_footer_text_color_hover', '#555555');

    update_option('spss_reset_lp_customizer', false);
  }
}
add_action('admin_init', 'spss_reset_customizer_defaults');
