<?php

if (! defined('ABSPATH')) {
  exit;
}

function spss_enqueue_admin_styles()
{
  $css_url = plugins_url('assets/css/spss-stylopress.css', __FILE__);
  wp_register_style('stylopress_dashicons', $css_url);
  wp_enqueue_style('stylopress_dashicons');
}
add_action('admin_enqueue_scripts', 'spss_enqueue_admin_styles');

function spss_enqueue_news_and_updates_styles($hook)
{

  if ('toplevel_page_stylopress' !== $hook) {
    return;
  }

  $plugin_dir = plugin_dir_path(__FILE__);
  $is_file_exists = file_exists($plugin_dir . 'assets/css/spss-news-updates.css');

  wp_enqueue_style(
    'spss-news-updates',
    plugin_dir_url(__FILE__) . 'assets/css/spss-news-updates.css',
    array(),
    $is_file_exists ? filemtime($plugin_dir . 'assets/css/spss-news-updates.css') : false
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_news_and_updates_styles');

function spss_enqueue_wp_logo_link_remover_scripts()
{
  $plugin_dir = plugin_dir_path(__FILE__);
  $is_file_exists = file_exists($plugin_dir . 'assets/javascript/spss-wp-lp-logolink-remover.js');

  wp_enqueue_script(
    'spss-wp-logo-link-remover-scripts',
    plugin_dir_url(__FILE__) . 'assets/javascript/spss-wp-lp-logolink-remover.js',
    array('jquery'),
    $is_file_exists ? filemtime($plugin_dir . 'assets/javascript/spss-wp-lp-logolink-remover.js') : false,
    true
  );
}
add_action('login_enqueue_scripts', 'spss_enqueue_wp_logo_link_remover_scripts');

function spss_enqueue_general_settings_styles($hook)
{

  if ('stylopress_page_spss_general_settings' !== $hook) {
    return;
  }

  $plugin_dir = plugin_dir_path(__FILE__);
  $is_file_exists = file_exists($plugin_dir . 'assets/css/spss-general-settings.css');

  wp_enqueue_style(
    'spss-general-settings-css',
    plugin_dir_url(__FILE__) . 'assets/css/spss-general-settings.css',
    array(),
    $is_file_exists ? filemtime($plugin_dir . 'assets/css/spss-general-settings.css') : false
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_general_settings_styles');
