<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_notice_settings_section_content($wp_customize)
{
  if (spss_fs()->is_free_plan()) {
    set_theme_mod('spss_notice_border_radius', 0);
    set_theme_mod('spss_notice_border_left_width', 4);
    set_theme_mod('spss_notice_info_left_border_color', '#72aee6');
    set_theme_mod('spss_notice_error_left_border_color', '#d63638');
  }

  $wp_customize->add_setting('spss_notice_transparency', array(
    'default'   => false,
    'transport' => 'postMessage',
    'sanitize_callback' => 'wp_validate_boolean',
  ));

  $wp_customize->add_control('spss_notice_transparency', array(
    'type'     => 'checkbox',
    'label'       => __('Message Transparency Mode', 'stylopress'),
    'description' => __('Toggle to enable or disable transparency for the notice message.', 'stylopress'),
    'settings' => 'spss_notice_transparency',
    'section'  => 'spss_notice_settings_section',
  ));

  $wp_customize->add_setting('spss_notice_background_color', array(
    'default' => '#ffffff',
    'transport' => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color'
  ));

  $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_notice_background_color', array(
    'label'   => 'Message Background Color',
    'description' => 'Choose a background color for the notice message.',
    'settings' => 'spss_notice_background_color',
    'section' => 'spss_notice_settings_section',
  )));

  $wp_customize->add_setting('spss_notice_text_color', array(
    'default' => '#000000',
    'transport' => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color'
  ));

  $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_notice_text_color', array(
    'label'   => 'Message Text Color',
    'description' => 'Choose a text color for the notice message.',
    'settings' => 'spss_notice_text_color',
    'section' => 'spss_notice_settings_section',
  )));

  $wp_customize->add_setting('spss_notice_font_size', array(
    'default'           => 13,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  $wp_customize->add_control('spss_notice_font_size', array(
    'type'        => 'number',
    'label'       => __('Message Font Size', 'stylopress'),
    'description' => __('Set the font size for the notice message in pixels (10-20px).', 'stylopress'),
    'settings'    => 'spss_notice_font_size',
    'section'     => 'spss_notice_settings_section',
    'input_attrs' => array(
      'min'   => 10,
      'max'   => 20,
      'step'  => 1,
    ),
  ));

  $wp_customize->add_setting('spss_notice_border_color', array(
    'default' => '#ffffff',
    'transport' => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color'
  ));

  $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_notice_border_color', array(
    'label'   => 'Message Border Color',
    'description' => 'Choose the border color of the notice message.',
    'settings' => 'spss_notice_border_color',
    'section' => 'spss_notice_settings_section',
  )));

  $wp_customize->add_setting('spss_notice_border_radius', array(
    'default'           => 0,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_notice_border_radius', array(
      'type'        => 'number',
      'label'       => __('Message Border Radius', 'stylopress'),
      'description' => __('Adjust the border radius to round the corners of the notice message (0-20 px).', 'stylopress'),
      'input_attrs' => array(
        'min'  => 0,
        'max'  => 20,
        'step' => 5,
      ),
      'settings'    => 'spss_notice_border_radius',
      'section'     => 'spss_notice_settings_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_notice_border_radius', array(
      'type'        => 'text',
      'label'       => __('Message Border Radius', 'stylopress'),
      'description' => __('Adjust the border radius to round the corners of the notice message (0-20 px).', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_notice_border_radius',
      'section'     => 'spss_notice_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_notice_border_left_width', array(
    'default'           => 4,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_notice_border_left_width', array(
      'type'        => 'number',
      'label'       => __('Message Border Left Width', 'stylopress'),
      'description' => __('Set the message left border width in pixels (0-20 px).', 'stylopress'),
      'input_attrs' => array(
        'min'  => 0,
        'max'  => 20,
        'step' => 5,
      ),
      'settings'    => 'spss_notice_border_left_width',
      'section'     => 'spss_notice_settings_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_notice_border_left_width', array(
      'type'        => 'text',
      'label'       => __('Message Border Left Width', 'stylopress'),
      'description' => __('Set the message left border width in pixels (0-20 px).', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_notice_border_left_width',
      'section'     => 'spss_notice_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_notice_info_left_border_color', array(
    'default' => '#72aee6',
    'transport' => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color'
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_notice_info_left_border_color', array(
      'label'   => 'Message Info Left Border Color',
      'description' => 'Choose the left border color for the message info.',
      'settings' => 'spss_notice_info_left_border_color',
      'section' => 'spss_notice_settings_section',
    )));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_notice_info_left_border_color', array(
      'label'   => 'Message Info Left Border Color',
      'description' => 'Choose the left border color for the message info.' .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings' => 'spss_notice_info_left_border_color',
      'section' => 'spss_notice_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_notice_error_left_border_color', array(
    'default' => '#d63638',
    'transport' => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color'
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_notice_error_left_border_color', array(
      'label'   => 'Message Error Left Border Color',
      'description' => 'Choose the left border color for the message error.',
      'settings' => 'spss_notice_error_left_border_color',
      'section' => 'spss_notice_settings_section',
    )));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_notice_error_left_border_color', array(
      'label'   => 'Message Error Left Border Color',
      'description' => 'Choose the left border color for the message error.' .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings' => 'spss_notice_error_left_border_color',
      'section' => 'spss_notice_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }
}
add_action('customize_register', 'spss_notice_settings_section_content');
