<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_logo_settings_section_content($wp_customize)
{
  if (spss_fs()->is_free_plan()) {
    set_theme_mod('spss_logo_rotation_enabled', false);
    set_theme_mod('spss_logo_rotation_speed', 61);
  }

  $wp_customize->add_setting('spss_logo_image', array(
    'default'   => plugin_dir_url(__FILE__) . '../assets/images/default-logo.png',
    'transport' => 'postMessage',
    'sanitize_callback' => 'esc_url_raw',
  ));

  $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'spss_logo_image', array(
    'label'       => __('Upload Logo Image', 'stylopress'),
    'description' => __('Select an image for the login page logo.', 'stylopress'),
    'section'  => 'spss_logo_settings_section',
    'settings' => 'spss_logo_image',
  )));

  $wp_customize->add_setting('spss_disable_logo', array(
    'default'   => false,
    'transport' => 'postMessage',
    'sanitize_callback' => 'wp_validate_boolean',
  ));

  $wp_customize->add_control('spss_disable_logo', array(
    'type'     => 'checkbox',
    'label'       => __('Disable Logo', 'stylopress'),
    'description' => __('Hide the logo on the login page.', 'stylopress'),
    'section'  => 'spss_logo_settings_section',
    'settings' => 'spss_disable_logo',
  ));

  $wp_customize->add_setting('spss_logo_width', array(
    'default'   => 100,
    'transport' => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  $wp_customize->add_control('spss_logo_width', array(
    'type'        => 'number',
    'label'       => __('Logo Width (px)', 'stylopress'),
    'description' => __('Adjust the width of the logo (50-300 px).', 'stylopress'),
    'section'     => 'spss_logo_settings_section',
    'settings'    => 'spss_logo_width',
    'input_attrs' => array(
      'min'  => 50,
      'max'  => 500,
      'step' => 5,
    ),
  ));

  $wp_customize->add_setting('spss_logo_height', array(
    'default'           => 100,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  $wp_customize->add_control('spss_logo_height', array(
    'type'        => 'number',
    'label'       => __('Logo Height (px)', 'stylopress'),
    'description' => __('Adjust the height of the logo (50-300 px).', 'stylopress'),
    'section'     => 'spss_logo_settings_section',
    'settings'    => 'spss_logo_height',
    'input_attrs' => array(
      'min'  => 50,
      'max'  => 300,
      'step' => 5,
    ),
  ));

  $wp_customize->add_setting('spss_logo_rotation_enabled', array(
    'default'           => false,
    'transport' => 'postMessage',
    'sanitize_callback' => 'wp_validate_boolean',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_logo_rotation_enabled', array(
      'type'              => 'checkbox',
      'label'             => __('Logo Rotation', 'stylopress'),
      'description'       => __('Enable or disable logo rotation animation (recommended only for images with a 1:1 aspect ratios).', 'stylopress'),
      'section'           => 'spss_logo_settings_section',
      'settings'          => 'spss_logo_rotation_enabled',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_logo_rotation_enabled', array(
      'type'              => 'text',
      'label'             => __('Logo Rotation', 'stylopress'),
      'description'       => __('Enable or disable logo rotation animation (recommended only for images with a 1:1 aspect ratio).', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'section'           => 'spss_logo_settings_section',
      'settings'          => 'spss_logo_rotation_enabled',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_logo_rotation_speed', array(
    'default'           => 61,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_logo_rotation_speed', array(
      'type'              => 'number',
      'label'             => __('Logo Rotation Speed', 'stylopress'),
      'description'       => __('Set the logo rotation speed (1 - 61). Lower values are faster, higher values are slower.', 'stylopress'),
      'section'           => 'spss_logo_settings_section',
      'settings'          => 'spss_logo_rotation_speed',
      'input_attrs'       => array(
        'min'  => 1,
        'max'  => 61,
        'step' => 5,
      ),
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_logo_rotation_speed', array(
      'type'              => 'text',
      'label'             => __('Logo Rotation Speed', 'stylopress'),
      'description'       => __('Set the logo rotation speed (1 - 61). Lower values are faster, higher values are slower.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'section'           => 'spss_logo_settings_section',
      'settings'          => 'spss_logo_rotation_speed',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }
}
add_action('customize_register', 'spss_logo_settings_section_content');
