<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_login_form_settings_section_content($wp_customize)
{
  if (spss_fs()->is_free_plan()) {
    set_theme_mod('spss_form_transparency', false);
    set_theme_mod('spss_form_background_image', '');
    set_theme_mod('spss_form_image_background_size', 'cover');
    set_theme_mod('spss_form_image_background_position', 'center');
    set_theme_mod('spss_form_image_background_repeat', 'no-repeat');
    set_theme_mod('spss_form_shadow', 0);
    set_theme_mod('spss_form_shadow_opacity', '0.5');
    set_theme_mod('spss_form_shadow_color', '#000000');
    set_theme_mod('spss_form_border_width', 1);
    set_theme_mod('spss_form_border_style', 'solid');
    set_theme_mod('spss_form_border_color', '#a2a0a0');
  }

  $wp_customize->add_setting('spss_form_background_color', array(
    'default' => '#ffffff',
    'transport' => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color'
  ));

  $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_form_background_color', array(
    'label'   => 'Form Background Color',
    'description' => 'Choose a background color for the login form.',
    'settings' => 'spss_form_background_color',
    'section' => 'spss_login_form_settings_section',
  )));

  $wp_customize->add_setting('spss_form_width', array(
    'default'           => 340,
    'transport' => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  $wp_customize->add_control('spss_form_width', array(
    'type'        => 'number',
    'label'       => __('Form Width', 'stylopress'),
    'description' => __('Set the width of the login form in pixels (300-700 px). Default 340px.', 'stylopress'),
    'input_attrs' => array(
      'min'  => 300,
      'max'  => 700,
      'step' => 5,
    ),
    'settings'    => 'spss_form_width',
    'section'     => 'spss_login_form_settings_section',
  ));

  $wp_customize->add_setting('spss_form_padding', array(
    'default'           => 25,
    'transport' => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  $wp_customize->add_control('spss_form_padding', array(
    'type'        => 'number',
    'label'       => __('Form Padding', 'stylopress'),
    'description' => __('Adjust the padding inside the login form (0-50 px).', 'stylopress'),
    'input_attrs' => array(
      'min'  => 0,
      'max'  => 50,
      'step' => 5,
    ),
    'settings'    => 'spss_form_padding',
    'section'     => 'spss_login_form_settings_section',
  ));

  $wp_customize->add_setting('spss_form_margin_top', array(
    'default'           => 20,
    'transport' => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  $wp_customize->add_control('spss_form_margin_top', array(
    'type'        => 'number',
    'label'       => __('Top Space', 'stylopress'),
    'description' => __('Set the space size between the form and the logo in pixels (0-50 px).', 'stylopress'),
    'section'     => 'spss_login_form_settings_section',
    'settings'    => 'spss_form_margin_top',
    'input_attrs' => array(
      'min'  => 0,
      'max'  => 50,
      'step' => 5,
    ),
  ));

  $wp_customize->add_setting('spss_form_border_radius', array(
    'default'           => 0,
    'transport' => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  $wp_customize->add_control('spss_form_border_radius', array(
    'type'        => 'number',
    'label'       => __('Form Border Radius', 'stylopress'),
    'description' => __('Adjust the border radius to round the corners of the login form (0-50 px).', 'stylopress'),
    'input_attrs' => array(
      'min'  => 0,
      'max'  => 50,
      'step' => 5,
    ),
    'settings'    => 'spss_form_border_radius',
    'section'     => 'spss_login_form_settings_section',
  ));

  $wp_customize->add_setting('spss_form_transparency', array(
    'default'   => false,
    'transport' => 'postMessage',
    'sanitize_callback' => 'wp_validate_boolean',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_form_transparency', array(
      'type'     => 'checkbox',
      'label'       => __('Form Transparency Mode', 'stylopress'),
      'description' => __('Toggle to enable or disable transparency for the login form.', 'stylopress'),
      'settings' => 'spss_form_transparency',
      'section'  => 'spss_login_form_settings_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_form_transparency', array(
      'type'     => 'text',
      'label'       => __('Form Transparency Mode', 'stylopress'),
      'description' => __('Toggle to enable or disable transparency for the login form.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings' => 'spss_form_transparency',
      'section'  => 'spss_login_form_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_form_background_image', array(
    'default'   => '',
    'transport' => 'postMessage',
    'sanitize_callback' => 'esc_url_raw',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'spss_form_background_image', array(
      'label'       => __('Form Background Image', 'stylopress'),
      'description' => __('Upload an image to use as the background for the login form.', 'stylopress'),
      'settings' => 'spss_form_background_image',
      'section'  => 'spss_login_form_settings_section',
    )));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_form_background_image', array(
      'label'       => __('Form Background Image', 'stylopress'),
      'description' => __('Upload an image to use as the background for the login form.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings' => 'spss_form_background_image',
      'section'  => 'spss_login_form_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_form_image_background_size', array(
    'default'           => 'cover',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_text_field',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_form_image_background_size', array(
      'type'        => 'select',
      'label'       => __('Form Image Background Size', 'stylopress'),
      'description' => __('Choose the background size for the login form image.', 'stylopress'),
      'choices'     => array(
        'auto'    => __('Auto', 'stylopress'),
        'cover'   => __('Cover', 'stylopress'),
        'contain' => __('Contain', 'stylopress'),
      ),
      'settings'    => 'spss_form_image_background_size',
      'section'     => 'spss_login_form_settings_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_form_image_background_size', array(
      'type'        => 'text',
      'label'       => __('Form Image Background Size', 'stylopress'),
      'description' => __('Choose the background size for the login form image.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_form_image_background_size',
      'section'     => 'spss_login_form_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_form_image_background_position', array(
    'default'           => 'center',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_text_field',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_form_image_background_position', array(
      'type'        => 'select',
      'label'       => __('Background Position', 'stylopress'),
      'description' => __('Set the position of the background image.', 'stylopress'),
      'choices'     => array(
        'center' => __('Center', 'stylopress'),
        'left'   => __('Left', 'stylopress'),
        'right'  => __('Right', 'stylopress'),
      ),
      'settings'    => 'spss_form_image_background_position',
      'section'     => 'spss_login_form_settings_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_form_image_background_position', array(
      'type'        => 'text',
      'label'       => __('Background Position', 'stylopress'),
      'description' => __('Set the position of the background image.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_form_image_background_position',
      'section'     => 'spss_login_form_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_form_image_background_repeat', array(
    'default'           => 'no-repeat',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_text_field',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_form_image_background_repeat', array(
      'type'        => 'select',
      'label'       => __('Form Image Background Repeat', 'stylopress'),
      'description' => __('Set the repeat style for the login form background image.', 'stylopress'),
      'choices'     => array(
        'repeat'    => __('Repeat', 'stylopress'),
        'no-repeat' => __('No Repeat', 'stylopress'),
      ),
      'settings'    => 'spss_form_image_background_repeat',
      'section'     => 'spss_login_form_settings_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_form_image_background_repeat', array(
      'type'        => 'text',
      'label'       => __('Form Image Background Repeat', 'stylopress'),
      'description' => __('Set the repeat style for the login form background image.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_form_image_background_repeat',
      'section'     => 'spss_login_form_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_form_border_width', array(
    'default'           => 1,
    'transport' => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_form_border_width', array(
      'type'        => 'number',
      'label'       => __('Form Border Width', 'stylopress'),
      'description' => __('Set the width of the login form border in pixels (0-10 px).', 'stylopress'),
      'input_attrs' => array(
        'min'  => 0,
        'max'  => 10,
        'step' => 1,
      ),
      'settings'    => 'spss_form_border_width',
      'section'     => 'spss_login_form_settings_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_form_border_width', array(
      'type'        => 'text',
      'label'       => __('Form Border Width', 'stylopress'),
      'description' => __('Set the width of the login form border in pixels (0-10 px).', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_form_border_width',
      'section'     => 'spss_login_form_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_form_border_style', array(
    'default'           => 'solid',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_text_field',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_form_border_style', array(
      'type'        => 'select',
      'label'       => __('Form Border Style', 'stylopress'),
      'description' => __('Choose the border style for the login form.', 'stylopress'),
      'choices'     => array(
        'solid'  => __('Solid', 'stylopress'),
        'dotted' => __('Dotted', 'stylopress'),
        'dashed' => __('Dashed', 'stylopress'),
      ),
      'settings'    => 'spss_form_border_style',
      'section'     => 'spss_login_form_settings_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_form_border_style', array(
      'type'        => 'text',
      'label'       => __('Form Border Style', 'stylopress'),
      'description' => __('Choose the border style for the login form.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_form_border_style',
      'section'     => 'spss_login_form_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_form_border_color', array(
    'default' => '#a2a0a0',
    'transport' => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color'
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_form_border_color', array(
      'label'   => __('Form Border Color', 'stylopress'),
      'description' => __('Select the color for the login form border.', 'stylopress'),
      'settings' => 'spss_form_border_color',
      'section' => 'spss_login_form_settings_section',
    )));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_form_border_color', array(
      'label'   => __('Form Border Color', 'stylopress'),
      'description' => __('Select the color for the login form border.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings' => 'spss_form_border_color',
      'section' => 'spss_login_form_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_form_shadow', array(
    'default'           => 0,
    'transport' => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_form_shadow', array(
      'type'        => 'number',
      'label'       => __('Form Shadow', 'stylopress'),
      'description' => __('Set the shadow size for the login form (0-50 px).', 'stylopress'),
      'input_attrs' => array(
        'min'  => 0,
        'max'  => 50,
        'step' => 5,
      ),
      'settings'    => 'spss_form_shadow',
      'section'     => 'spss_login_form_settings_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_form_shadow', array(
      'type'        => 'text',
      'label'       => __('Form Shadow', 'stylopress'),
      'description' => __('Set the shadow size for the login form (0-50 px).', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_form_shadow',
      'section'     => 'spss_login_form_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_form_shadow_color', array(
    'default' => '#000000',
    'transport' => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color'
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_form_shadow_color', array(
      'label'   => __('Form Shadow Color', 'stylopress'),
      'description' => __('Choose a color for the login form shadow.', 'stylopress'),
      'settings' => 'spss_form_shadow_color',
      'section' => 'spss_login_form_settings_section',
    )));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_form_shadow_color', array(
      'label'   => __('Form Shadow Color', 'stylopress'),
      'description' => __('Choose a color for the login form shadow.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings' => 'spss_form_shadow_color',
      'section' => 'spss_login_form_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_form_shadow_opacity', array(
    'default'           => '0.5',
    'transport'         => 'postMessage',
    'sanitize_callback' => function ($value) {
      $value = str_replace(',', '.', $value);
      return is_numeric($value) && $value >= 0 && $value <= 1 ? $value : 0.5;
    },
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_form_shadow_opacity', array(
      'type'        => 'number',
      'label'       => __('Form Shadow Opacity', 'stylopress'),
      'description' => __('Enter a value between 0 and 1 (e.g. 0.5 for 50%).', 'stylopress'),
      'section'     => 'spss_login_form_settings_section',
      'settings'    => 'spss_form_shadow_opacity',
      'input_attrs' => array(
        'min'  => 0,
        'max'  => 1,
        'step' => 0.01,
      ),
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_form_shadow_opacity', array(
      'type'        => 'text',
      'label'       => __('Form Shadow Opacity', 'stylopress'),
      'description' => __('Enter a value between 0 and 1 (e.g. 0.5 for 50%).', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'section'     => 'spss_login_form_settings_section',
      'settings'    => 'spss_form_shadow_opacity',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }
}
add_action('customize_register', 'spss_login_form_settings_section_content');
