<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_input_fields_settings_section_content($wp_customize)
{
  if (spss_fs()->is_free_plan()) {
    set_theme_mod('spss_input_field_transparency_mode', false);
    set_theme_mod('spss_input_field_background_color', '#ffffff');
    set_theme_mod('spss_input_field_border_color', '#2c3338');
    set_theme_mod('spss_input_field_border_width', 1);
    set_theme_mod('spss_input_field_border_bottom', false);
    set_theme_mod('spss_input_field_border_style', 'solid');
    set_theme_mod('spss_input_field_password_eye_color', '#000000');
    set_theme_mod('spss_input_field_password_eye_color_hover', '#000000');
  }

  $wp_customize->add_setting('spss_input_label_font_size', array(
    'default'           => 13,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  $wp_customize->add_control('spss_input_label_font_size', array(
    'type'        => 'number',
    'label'       => __('Input Field Label Font Size', 'stylopress'),
    'description' => __('Set the font size for input field labels in pixels (10-20px).', 'stylopress'),
    'settings'    => 'spss_input_label_font_size',
    'section'     => 'spss_input_fields_settings_section',
    'input_attrs' => array(
      'min'   => 10,
      'max'   => 20,
      'step'  => 1,
    ),
  ));

  $wp_customize->add_setting('spss_input_label_color', array(
    'default'           => '#333',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color',
  ));

  $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_input_label_color', array(
    'label'       => __('Input Field Label Color', 'stylopress'),
    'description' => __('Choose a color for the labels of the input fields on the login form.', 'stylopress'),
    'settings'    => 'spss_input_label_color',
    'section'     => 'spss_input_fields_settings_section',
  )));

  $wp_customize->add_setting('spss_remember_me_toggle_display', array(
    'default'           => false,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'wp_validate_boolean',
  ));

  $wp_customize->add_control('spss_remember_me_toggle_display', array(
    'type'        => 'checkbox',
    'label'       => __('Hide Remember Me Label/Input', 'stylopress'),
    'description' => __('Hide the "Remember Me" label and input field on the login form.', 'stylopress'),
    'settings'    => 'spss_remember_me_toggle_display',
    'section'     => 'spss_input_fields_settings_section',
  ));

  $wp_customize->add_setting('spss_input_field_border_radius', array(
    'default'           => 5,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  $wp_customize->add_control('spss_input_field_border_radius', array(
    'type'        => 'number',
    'label'       => __('Input Field Border Radius', 'stylopress'),
    'description' => __('Adjust the border radius to round the corners of the input fields (0-20 px).', 'stylopress'),
    'input_attrs' => array(
      'min'  => 0,
      'max'  => 20,
      'step' => 5,
    ),
    'settings'    => 'spss_input_field_border_radius',
    'section'     => 'spss_input_fields_settings_section',
  ));

  $wp_customize->add_setting('spss_input_field_text_color', array(
    'default'           => '#000000',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color',
  ));

  $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_input_field_text_color', array(
    'label'       => __('Input Field Text Color', 'stylopress'),
    'description' => __('Choose the text color for the input fields on the login form.', 'stylopress'),
    'settings'    => 'spss_input_field_text_color',
    'section'     => 'spss_input_fields_settings_section',
  )));

  $wp_customize->add_setting('spss_input_field_transparency_mode', array(
    'default'           => false,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'wp_validate_boolean',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_input_field_transparency_mode', array(
      'type'        => 'checkbox',
      'label'       => __('Input Field Transparency Mode', 'stylopress'),
      'description' => __('Activate to make the input field background transparent (the form background must also be transparent).', 'stylopress'),
      'settings'    => 'spss_input_field_transparency_mode',
      'section'     => 'spss_input_fields_settings_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_input_field_transparency_mode', array(
      'type'        => 'text',
      'label'       => __('Input Field Transparency Mode', 'stylopress'),
      'description' => __('Activate to make the input field background transparent (the form background must also be transparent).', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_input_field_transparency_mode',
      'section'     => 'spss_input_fields_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_input_field_background_color', array(
    'default'           => '#ffffff',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_input_field_background_color', array(
      'label'       => __('Input Field Background Color', 'stylopress'),
      'description' => __('Choose the background color for the input fields.', 'stylopress'),
      'settings'    => 'spss_input_field_background_color',
      'section'     => 'spss_input_fields_settings_section',
    )));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_input_field_background_color', array(
      'label'       => __('Input Field Background Color', 'stylopress'),
      'description' => __('Choose the background color for the input fields.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_input_field_background_color',
      'section'     => 'spss_input_fields_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_input_field_border_width', array(
    'default'           => 1,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_input_field_border_width', array(
      'type'        => 'number',
      'label'       => __('Input Field Border Width', 'stylopress'),
      'description' => __('Set the width of the input field border in pixels (0-10 px).', 'stylopress'),
      'input_attrs' => array(
        'min'  => 0,
        'max'  => 10,
        'step' => 1,
      ),
      'settings'    => 'spss_input_field_border_width',
      'section'     => 'spss_input_fields_settings_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_input_field_border_width', array(
      'type'        => 'text',
      'label'       => __('Input Field Border Width', 'stylopress'),
      'description' => __('Set the width of the input field border in pixels (0-10 px).', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_input_field_border_width',
      'section'     => 'spss_input_fields_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_input_field_border_bottom', array(
    'default'           => false,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_input_field_border_bottom', array(
      'type'        => 'checkbox',
      'label'       => __('Input Field Bottom Border Only', 'stylopress'),
      'description' => __('Display only the bottom border for input fields.', 'stylopress'),
      'settings'    => 'spss_input_field_border_bottom',
      'section'     => 'spss_input_fields_settings_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_input_field_border_bottom', array(
      'type'        => 'text',
      'label'       => __('Input Field Bottom Border Only', 'stylopress'),
      'description' => __('Display only the bottom border for input fields.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_input_field_border_bottom',
      'section'     => 'spss_input_fields_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_input_field_border_color', array(
    'default'           => '#2c3338',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_input_field_border_color', array(
      'label'       => __('Input Field Border Color', 'stylopress'),
      'description' => __('Choose the border color of the input fields.', 'stylopress'),
      'settings'    => 'spss_input_field_border_color',
      'section'     => 'spss_input_fields_settings_section',
    )));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_input_field_border_color', array(
      'label'       => __('Input Field Border Color', 'stylopress'),
      'description' => __('Choose the border color of the input fields.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_input_field_border_color',
      'section'     => 'spss_input_fields_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_input_field_border_style', array(
    'default'           => 'solid',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_text_field',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_input_field_border_style', array(
      'type'        => 'select',
      'label'       => __('Input Field Border Style', 'stylopress'),
      'description' => __('Choose the border style for the input fields.', 'stylopress'),
      'choices'     => array(
        'solid'  => __('Solid', 'stylopress'),
        'dotted' => __('Dotted', 'stylopress'),
        'dashed' => __('Dashed', 'stylopress'),
      ),
      'settings'    => 'spss_input_field_border_style',
      'section'     => 'spss_input_fields_settings_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_input_field_border_style', array(
      'type'        => 'text',
      'label'       => __('Input Field Border Style', 'stylopress'),
      'description' => __('Choose the border style for the input fields.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_input_field_border_style',
      'section'     => 'spss_input_fields_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_input_field_password_eye_color', array(
    'default'           => '#000000',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_input_field_password_eye_color', array(
      'label'       => __('Password Field Eye-Icon Color', 'stylopress'),
      'description' => __('Change the color of the eye icon for the password field.', 'stylopress'),
      'settings'    => 'spss_input_field_password_eye_color',
      'section'     => 'spss_input_fields_settings_section',
    )));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_input_field_password_eye_color', array(
      'label'       => __('Password Field Eye-Icon Color', 'stylopress'),
      'description' => __('Change the color of the eye icon for the password field.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_input_field_password_eye_color',
      'section'     => 'spss_input_fields_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_input_field_password_eye_color_hover', array(
    'default'           => '#000000',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_input_field_password_eye_color_hover', array(
      'label'       => __('Password Field Eye-Icon Color (Hover)', 'stylopress'),
      'description' => __('Change the hover color of the eye icon for the password field.', 'stylopress'),
      'settings'    => 'spss_input_field_password_eye_color_hover',
      'section'     => 'spss_input_fields_settings_section',
    )));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_input_field_password_eye_color_hover', array(
      'label'       => __('Password Field Eye-Icon Color (Hover)', 'stylopress'),
      'description' => __('Change the hover color of the eye icon for the password field.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_input_field_password_eye_color_hover',
      'section'     => 'spss_input_fields_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }
}
add_action('customize_register', 'spss_input_fields_settings_section_content');
