<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_google_fonts_settings_section_content($wp_customize)
{
  if (spss_fs()->is_free_plan()) {
    set_theme_mod('spss_google_font_family', 'Open Sans');
    set_theme_mod('spss_google_font_weight', '400');
    set_theme_mod('spss_enable_local_fonts', false);
    set_theme_mod('spss_cleanup_local_fonts', false);
  }

  $wp_customize->add_setting('spss_google_font_family', array(
    'default'           => 'Open Sans',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_text_field',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_google_font_family', array(
      'type'    => 'select',
      'label'   => __('Select Font Family', 'stylopress'),
      'description' => __('Select a Google Font for the login page.', 'stylopress'),
      'choices' => array(
        'Open Sans'             => 'Open Sans',
        'Roboto'                => 'Roboto',
        'Dancing Script'        => 'Dancing Script',
        'Montserrat'            => 'Montserrat',
        'Lato'                  => 'Lato',
        'Poppins'               => 'Poppins',
        'Source Sans Pro'       => 'Source Sans Pro',
        'Oswald'                => 'Oswald',
        'Raleway'               => 'Raleway',
        'Nunito'                => 'Nunito',
        'Merriweather'          => 'Merriweather',
        'Playfair Display'      => 'Playfair Display',
        'Anton'                 => 'Anton',
        'Abril Fatface'         => 'Abril Fatface',
        'Lobster'               => 'Lobster',
        'Quicksand'             => 'Quicksand',
        'Amatic SC'             => 'Amatic SC',
        'Cinzel'                => 'Cinzel',
        'Pacifico'              => 'Pacifico',
        'Indie Flower'          => 'Indie Flower',
        'Cabin'                 => 'Cabin',
        'Barlow'                => 'Barlow',
        'Josefin Sans'          => 'Josefin Sans',
        'Cormorant Garamond'    => 'Cormorant Garamond',
        'Zilla Slab'            => 'Zilla Slab',
        'Lora'                  => 'Lora',
        'PT Sans'               => 'PT Sans',
        'Fjalla One'            => 'Fjalla One',
        'Bitter'                => 'Bitter',
        'Arvo'                  => 'Arvo',
        'Architects Daughter'   => 'Architects Daughter',
        'Bungee'                => 'Bungee',
        'Press Start 2P'        => 'Press Start 2P',
        'Orbitron'              => 'Orbitron',
        'Shadows Into Light'    => 'Shadows Into Light',
      ),
      'settings' => 'spss_google_font_family',
      'section'  => 'spss_google_fonts_settings_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_google_font_family', array(
      'type'    => 'text',
      'label'   => __('Select Font Family', 'stylopress'),
      'description' => __('Select a Google Font for the login page.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings' => 'spss_google_font_family',
      'section'  => 'spss_google_fonts_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_google_font_weight', array(
    'default'           => '400',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_text_field',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_google_font_weight', array(
      'type'    => 'select',
      'label'   => __('Select Font Weight', 'stylopress'),
      'description' => __('Choose the font weight for the selected font.', 'stylopress'),
      'choices' => array(
        '400' => __('Normal (400)', 'stylopress'),
        '700' => __('Bold (700)', 'stylopress'),
      ),
      'settings' => 'spss_google_font_weight',
      'section'  => 'spss_google_fonts_settings_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_google_font_weight', array(
      'type'    => 'text',
      'label'   => __('Select Font Weight', 'stylopress'),
      'description' => __('Choose the font weight for the selected font.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings' => 'spss_google_font_weight',
      'section'  => 'spss_google_fonts_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_enable_local_fonts', array(
    'default'           => false,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'wp_validate_boolean',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_enable_local_fonts', array(
      'type'        => 'checkbox',
      'label'       => __('Host Fonts Locally', 'stylopress'),
      'description' => __('Enable this to download and host the selected Google Font locally.', 'stylopress'),
      'settings' => 'spss_enable_local_fonts',
      'section'     => 'spss_google_fonts_settings_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_enable_local_fonts', array(
      'type'        => 'text',
      'label'       => __('Host Fonts Locally', 'stylopress'),
      'description' => __('Enable this to download and host the selected Google Font locally.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings' => 'spss_enable_local_fonts',
      'section'     => 'spss_google_fonts_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_cleanup_local_fonts', array(
    'default'           => false,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'wp_validate_boolean',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_cleanup_local_fonts', array(
      'type'        => 'checkbox',
      'label'       => __('Delete All Locally Saved Fonts', 'stylopress'),
      'description' => __('Check to delete all locally saved Google Fonts.', 'stylopress'),
      'settings' => 'spss_cleanup_local_fonts',
      'section'     => 'spss_google_fonts_settings_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_cleanup_local_fonts', array(
      'type'        => 'text',
      'label'       => __('Delete All Locally Saved Fonts', 'stylopress'),
      'description' => __('Check to delete all locally saved Google Fonts.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings' => 'spss_cleanup_local_fonts',
      'section'     => 'spss_google_fonts_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }
}

add_action('customize_register', 'spss_google_fonts_settings_section_content');
