<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_footer_settings_section_content($wp_customize)
{
  $wp_customize->add_setting('spss_footer_first_label_display', array(
    'default'           => false,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'wp_validate_boolean',
  ));

  $wp_customize->add_control('spss_footer_first_label_display', array(
    'type'        => 'checkbox',
    'label'       => __('Hide First Footer Label', 'stylopress'),
    'description' => __('Toggle the visibility of the first footer label, "Lost your password?".', 'stylopress'),
    'settings'    => 'spss_footer_first_label_display',
    'section'     => 'spss_footer_settings_section',
  ));

  $wp_customize->add_setting('spss_footer_second_label_display', array(
    'default'           => false,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'wp_validate_boolean',
  ));

  $wp_customize->add_control('spss_footer_second_label_display', array(
    'type'        => 'checkbox',
    'label'       => __('Hide Second Footer Label', 'stylopress'),
    'description' => __('Toggle the visibility of the second footer label, "Go to Website".', 'stylopress'),
    'settings'    => 'spss_footer_second_label_display',
    'section'     => 'spss_footer_settings_section',
  ));

  $wp_customize->add_setting('spss_footer_label_font_size', array(
    'default'           => 11,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  $wp_customize->add_control('spss_footer_label_font_size', array(
    'type'        => 'number',
    'label'       => __('Footer Label Font Size', 'stylopress'),
    'description' => __('Set the font size for the footer text (10-15px).', 'stylopress'),
    'settings'    => 'spss_footer_label_font_size',
    'section'     => 'spss_footer_settings_section',
    'input_attrs' => array(
      'min'   => 10,
      'max'   => 15,
      'step'  => 1,
    ),
  ));

  $wp_customize->add_setting('spss_footer_text_color', array(
    'default'           => '#000000',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color',
  ));

  $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_footer_text_color', array(
    'label'       => __('Footer Text Color', 'stylopress'),
    'description' => __('Choose the color for the footer text.', 'stylopress'),
    'settings'    => 'spss_footer_text_color',
    'section'     => 'spss_footer_settings_section',
  )));

  $wp_customize->add_setting('spss_footer_text_color_hover', array(
    'default'           => '#555555',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color',
  ));

  $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_footer_text_color_hover', array(
    'label'       => __('Footer Text Color on Hover', 'stylopress'),
    'description' => __('Choose the color for the footer text on hover.', 'stylopress'),
    'settings'    => 'spss_footer_text_color_hover',
    'section'     => 'spss_footer_settings_section',
  )));
}
add_action('customize_register', 'spss_footer_settings_section_content');
