<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_custom_code_settings_section_content($wp_customize)
{
  $wp_customize->add_setting('spss_custom_css', array(
    'default'           => '',
    'sanitize_callback' => 'wp_strip_all_tags',
  ));

  $wp_customize->add_control(new WP_Customize_Code_Editor_Control($wp_customize, 'spss_custom_css', array(
    'label'       => __('Custom CSS', 'stylopress'),
    'description' => __('Write CSS to style the login page.', 'stylopress'),
    'settings'    => 'spss_custom_css',
    'section'     => 'spss_custom_code_section',
    'code_type'   => 'text/css',
  )));

  $wp_customize->add_setting('spss_custom_js', array(
    'default'           => '',
    'sanitize_callback' => 'wp_kses_post',
  ));

  $wp_customize->add_control(new WP_Customize_Code_Editor_Control($wp_customize, 'spss_custom_js', array(
    'label'       => __('Custom JavaScript', 'stylopress'),
    'description' => __('Write JavaScript to customize the login page.', 'stylopress'),
    'settings'    => 'spss_custom_js',
    'section'     => 'spss_custom_code_section',
    'code_type'   => 'application/javascript',
  )));
}
add_action('customize_register', 'spss_custom_code_settings_section_content');
