<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_button_settings_section_content($wp_customize)
{
  if (spss_fs()->is_free_plan()) {
    set_theme_mod('spss_button_border_color', '#036391');
    set_theme_mod('spss_button_border_style', 'solid');
    set_theme_mod('spss_button_text_color_hover', '#ffffff');
    set_theme_mod('spss_button_text_style', 'capitalize');
    set_theme_mod('spss_button_text_weight', 'normal');
    set_theme_mod('spss_button_border_width', 1);
  }

  $wp_customize->add_setting('spss_button_color', array(
    'default'           => '#0073aa',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color',
  ));

  $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_button_color', array(
    'label'       => __('Button Color', 'stylopress'),
    'description' => __('Choose the background color for the login button.', 'stylopress'),
    'settings'    => 'spss_button_color',
    'section'     => 'spss_button_styles_section',
  )));

  $wp_customize->add_setting('spss_button_width', array(
    'default'           => 25,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  $wp_customize->add_control('spss_button_width', array(
    'type'        => 'number',
    'label'       => __('Button Width', 'stylopress'),
    'description' => __('Set the width of the login button (25-100%).', 'stylopress'),
    'input_attrs' => array(
      'min'   => 25,
      'max'   => 100,
      'step'  => 5,
    ),
    'settings'    => 'spss_button_width',
    'section'     => 'spss_button_styles_section',
  ));

  $wp_customize->add_setting('spss_button_top_margin', array(
    'default'           => 0,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  $wp_customize->add_control('spss_button_top_margin', array(
    'type'        => 'number',
    'label'       => __('Top Space', 'stylopress'),
    'description' => __('Set the space between the button and the password input (0-50px).', 'stylopress'),
    'input_attrs' => array(
      'min'   => 0,
      'max'   => 50,
      'step'  => 5,
    ),
    'settings'    => 'spss_button_top_margin',
    'section'     => 'spss_button_styles_section',
  ));

  $wp_customize->add_setting('spss_button_text_size', array(
    'default'           => 13,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  $wp_customize->add_control('spss_button_text_size', array(
    'type'        => 'number',
    'label'       => __('Button Text Size', 'stylopress'),
    'description' => __('Set the font size for the login button text (10-20px).', 'stylopress'),
    'input_attrs' => array(
      'min'   => 10,
      'max'   => 20,
      'step'  => 1,
    ),
    'settings'    => 'spss_button_text_size',
    'section'     => 'spss_button_styles_section',
  ));

  $wp_customize->add_setting('spss_button_text_color', array(
    'default'           => '#ffffff',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color',
  ));

  $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_button_text_color', array(
    'label'       => __('Button Text Color', 'stylopress'),
    'description' => __('Choose the text color for the login button.', 'stylopress'),
    'settings'    => 'spss_button_text_color',
    'section'     => 'spss_button_styles_section',
  )));

  $wp_customize->add_setting('spss_button_border_radius', array(
    'default'           => 2,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  $wp_customize->add_control('spss_button_border_radius', array(
    'type'        => 'number',
    'label'       => __('Button Border Radius', 'stylopress'),
    'description' => __('Adjust the border radius to round the corners of the login button (0-25px).', 'stylopress'),
    'input_attrs' => array(
      'min'   => 0,
      'max'   => 25,
      'step'  => 5,
    ),
    'settings'    => 'spss_button_border_radius',
    'section'     => 'spss_button_styles_section',
  ));

  $wp_customize->add_setting('spss_button_transparency_mode', array(
    'default'           => false,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'wp_validate_boolean',
  ));

  $wp_customize->add_control('spss_button_transparency_mode', array(
    'type'        => 'checkbox',
    'label'       => __('Button Transparency Mode', 'stylopress'),
    'description' => __('Activate to make the button background transparent.', 'stylopress'),
    'settings'    => 'spss_button_transparency_mode',
    'section'     => 'spss_button_styles_section',
  ));

  $wp_customize->add_setting('spss_button_color_hover', array(
    'default'           => '#005177',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color',
  ));

  $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_button_color_hover', array(
    'label'       => __('Button Color on Hover', 'stylopress'),
    'description' => __('Choose the background color on hover (no effect if transparency mode is activated).', 'stylopress'),
    'settings'    => 'spss_button_color_hover',
    'section'     => 'spss_button_styles_section',
  )));

  $wp_customize->add_setting('spss_button_border_style', array(
    'default'           => 'solid',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_text_field',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_button_border_style', array(
      'type'        => 'select',
      'label'       => __('Button Border Style', 'stylopress'),
      'description' => __('Select the button border style.', 'stylopress'),
      'choices'     => array(
        'solid'  => __('Solid', 'stylopress'),
        'dotted' => __('Dotted', 'stylopress'),
        'dashed' => __('Dashed', 'stylopress'),
      ),
      'settings'    => 'spss_button_border_style',
      'section'     => 'spss_button_styles_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_button_border_style', array(
      'type'        => 'text',
      'label'       => __('Button Border Style', 'stylopress'),
      'description' => __('Select the button border style.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_button_border_style',
      'section'     => 'spss_button_styles_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_button_border_width', array(
    'default'           => 1,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_button_border_width', array(
      'type'        => 'number',
      'label'       => __('Button Border Width', 'stylopress'),
      'description' => __('Set the button border width (0-10px).', 'stylopress'),
      'input_attrs' => array(
        'min'   => 0,
        'max'   => 10,
        'step'  => 1,
      ),
      'settings'    => 'spss_button_border_width',
      'section'     => 'spss_button_styles_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_button_border_width', array(
      'type'        => 'text',
      'label'       => __('Button Border Width', 'stylopress'),
      'description' => __('Set the button border width (0-10px).', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_button_border_width',
      'section'     => 'spss_button_styles_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_button_border_color', array(
    'default'           => '#036391',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_button_border_color', array(
      'label'       => __('Button Border Color', 'stylopress'),
      'description' => __('Choose the button border color.', 'stylopress'),
      'settings'    => 'spss_button_border_color',
      'section'     => 'spss_button_styles_section',
    )));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_button_border_color', array(
      'label'       => __('Button Border Color', 'stylopress'),
      'description' => __('Choose the button border color.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_button_border_color',
      'section'     => 'spss_button_styles_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_button_text_color_hover', array(
    'default'           => '#ffffff',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_button_text_color_hover', array(
      'label'       => __('Button Text Color on Hover', 'stylopress'),
      'description' => __('Choose the button text color on hover.', 'stylopress'),
      'settings'    => 'spss_button_text_color_hover',
      'section'     => 'spss_button_styles_section',
    )));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_button_text_color_hover', array(
      'label'       => __('Button Text Color on Hover', 'stylopress'),
      'description' => __('Choose the button text color on hover.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_button_text_color_hover',
      'section'     => 'spss_button_styles_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_button_text_style', array(
    'default'           => 'capitalize',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_text_field',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_button_text_style', array(
      'type'        => 'select',
      'label'       => __('Button Text Style', 'stylopress'),
      'description' => __('Select the button text style.', 'stylopress'),
      'choices'     => array(
        'capitalize' => __('Capitalize', 'stylopress'),
        'lowercase'  => __('Lowercase', 'stylopress'),
        'uppercase'  => __('Uppercase', 'stylopress'),
      ),
      'settings'    => 'spss_button_text_style',
      'section'     => 'spss_button_styles_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_button_text_style', array(
      'type'        => 'text',
      'label'       => __('Button Text Style', 'stylopress'),
      'description' => __('Select the button text style.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_button_text_style',
      'section'     => 'spss_button_styles_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_button_text_weight', array(
    'default'           => 'normal',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_text_field',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_button_text_weight', array(
      'type'        => 'select',
      'label'       => __('Button Text Weight', 'stylopress'),
      'description' => __('Select the button font weight.', 'stylopress'),
      'choices'     => array(
        'normal' => __('Normal', 'stylopress'),
        'bold'   => __('Bold', 'stylopress'),
        'lighter' => __('Lighter', 'stylopress'),
      ),
      'settings'    => 'spss_button_text_weight',
      'section'     => 'spss_button_styles_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_button_text_weight', array(
      'type'        => 'text',
      'label'       => __('Button Text Weight', 'stylopress'),
      'description' => __('Select the button font weight.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_button_text_weight',
      'section'     => 'spss_button_styles_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }
}
add_action('customize_register', 'spss_button_settings_section_content');
