<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_background_settings_section_content($wp_customize)
{
  if (spss_fs()->is_free_plan()) {
    set_theme_mod('spss_background_image_mobile', '');
    set_theme_mod('spss_background_border_width', 100);
    set_theme_mod('spss_background_border_height', 100);
    set_theme_mod('spss_background_overlay_color', '#000000');
    set_theme_mod('spss_background_overlay_opacity', '0');
    set_theme_mod('spss_background_video', '');
  }

  $wp_customize->add_setting('spss_background_color', array(
    'default'           => '#f0f0f1',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color',
  ));

  $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_background_color', array(
    'label'       => __('Background Color', 'stylopress'),
    'description' => __('Set the background color.', 'stylopress'),
    'settings'    => 'spss_background_color',
    'section'     => 'spss_background_settings_section',
  )));

  $wp_customize->add_setting('spss_background_image', array(
    'default'           => '',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'esc_url_raw',
  ));

  $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'spss_background_image', array(
    'label'       => __('Background Image', 'stylopress'),
    'description' => __('Upload a background image.', 'stylopress'),
    'settings'    => 'spss_background_image',
    'section'     => 'spss_background_settings_section',
  )));

  $wp_customize->add_setting('spss_background_position', array(
    'default'           => 'center center',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_text_field',
  ));

  $wp_customize->add_control('spss_background_position', array(
    'type'        => 'select',
    'label'       => __('Background Position', 'stylopress'),
    'description' => __('Set the position of the background image.', 'stylopress'),
    'choices'     => array(
      'left top'      => __('Left Top', 'stylopress'),
      'left center'   => __('Left Center', 'stylopress'),
      'left bottom'   => __('Left Bottom', 'stylopress'),
      'center top'    => __('Center Top', 'stylopress'),
      'center center' => __('Center Center', 'stylopress'),
      'center bottom' => __('Center Bottom', 'stylopress'),
      'right top'     => __('Right Top', 'stylopress'),
      'right center'  => __('Right Center', 'stylopress'),
      'right bottom'  => __('Right Bottom', 'stylopress'),
    ),
    'settings'    => 'spss_background_position',
    'section'     => 'spss_background_settings_section',
  ));

  $wp_customize->add_setting('spss_background_image_size', array(
    'default'           => 'cover',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_text_field',
  ));

  $wp_customize->add_control('spss_background_image_size', array(
    'type'        => 'select',
    'label'       => __('Background Image Size', 'stylopress'),
    'description' => __('Set the size of the background image.', 'stylopress'),
    'choices'     => array(
      'auto'    => __('Auto', 'stylopress'),
      'cover'   => __('Cover', 'stylopress'),
      'contain' => __('Contain', 'stylopress'),
    ),
    'settings'    => 'spss_background_image_size',
    'section'     => 'spss_background_settings_section',
  ));

  $wp_customize->add_setting('spss_background_repeat', array(
    'default'           => 'no-repeat',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_text_field',
  ));

  $wp_customize->add_control('spss_background_repeat', array(
    'type'        => 'select',
    'label'       => __('Background Repeat', 'stylopress'),
    'description' => __('Define how the background image is repeated.', 'stylopress'),
    'choices'     => array(
      'no-repeat' => __('No Repeat', 'stylopress'),
      'repeat'    => __('Repeat', 'stylopress'),
      'repeat-x'  => __('Repeat Horizontally', 'stylopress'),
      'repeat-y'  => __('Repeat Vertically', 'stylopress'),
    ),
    'settings'    => 'spss_background_repeat',
    'section'     => 'spss_background_settings_section',
  ));

  $wp_customize->add_setting('spss_background_image_mobile', array(
    'default'           => '',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'esc_url_raw',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control(new WP_Customize_Upload_Control($wp_customize, 'spss_background_image_mobile', array(
      'label'       => __('Background Image for Mobile', 'stylopress'),
      'description' => __('Upload a background image for tablet/mobile devices.', 'stylopress'),
      'settings'    => 'spss_background_image_mobile',
      'section'     => 'spss_background_settings_section',
    )));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_background_image_mobile', array(
      'label'       => __('Background Image for Mobile', 'stylopress'),
      'description' => __('Upload a background image for tablet/mobile devices.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_background_image_mobile',
      'section'     => 'spss_background_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_background_overlay_color', array(
    'default'           => '#000000',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'sanitize_hex_color',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'spss_background_overlay_color', array(
      'label'       => __('Background Overlay Color', 'stylopress'),
      'description' => __('Set the background overlay color.', 'stylopress'),
      'settings'    => 'spss_background_overlay_color',
      'section'     => 'spss_background_settings_section',
    )));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_background_overlay_color', array(
      'label'       => __('Background Overlay Color', 'stylopress'),
      'description' => __('Set the background overlay color.', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_background_overlay_color',
      'section'     => 'spss_background_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_background_overlay_opacity', array(
    'default'           => '0',
    'transport'         => 'postMessage',
    'sanitize_callback' => function ($value) {
      $value = str_replace(',', '.', $value);
      return is_numeric($value) && $value >= 0 && $value <= 1 ? $value : 0.5;
    },
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_background_overlay_opacity', array(
      'type'        => 'number',
      'label'       => __('Background Overlay Opacity', 'stylopress'),
      'description' => __('Enter a value between 0 and 1 (e.g., 0.5 for 50%) to adjust the background overlay opacity', 'stylopress'),
      'section'     => 'spss_background_settings_section',
      'settings'    => 'spss_background_overlay_opacity',
      'input_attrs' => array(
        'min'  => 0,
        'max'  => 1,
        'step' => 0.01,
      ),
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_background_overlay_opacity', array(
      'type'        => 'text',
      'label'       => __('Background Overlay Opacity', 'stylopress'),
      'description' => __('Enter a value between 0 and 1 (e.g., 0.5 for 50%) to adjust the background overlay opacity', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'section'     => 'spss_background_settings_section',
      'settings'    => 'spss_background_overlay_opacity',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_background_border_width', array(
    'default'           => 100,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_background_border_width', array(
      'type'        => 'number',
      'label'       => __('Background Border Width', 'stylopress'),
      'description' => __('Set the width of the border around the login form background (90-100%).', 'stylopress'),
      'input_attrs' => array(
        'min'   => 90,
        'max'   => 100,
        'step'  => 1,
      ),
      'settings'    => 'spss_background_border_width',
      'section'     => 'spss_background_settings_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_background_border_width', array(
      'type'        => 'text',
      'label'       => __('Background Border Width', 'stylopress'),
      'description' => __('Set the width of the border around the login form background (90-100%).', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_background_border_width',
      'section'     => 'spss_background_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_background_border_height', array(
    'default'           => 100,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control('spss_background_border_height', array(
      'type'        => 'number',
      'label'       => __('Background Border Height', 'stylopress'),
      'description' => __('Set the height of the border around the login form background (90-100%).', 'stylopress'),
      'input_attrs' => array(
        'min'   => 90,
        'max'   => 100,
        'step'  => 1,
      ),
      'settings'    => 'spss_background_border_height',
      'section'     => 'spss_background_settings_section',
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control('spss_background_border_height', array(
      'type'        => 'text',
      'label'       => __('Background Border Height', 'stylopress'),
      'description' => __('Set the height of the border around the login form background (90-100%).', 'stylopress') .
        '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
      'settings'    => 'spss_background_border_height',
      'section'     => 'spss_background_settings_section',
      'input_attrs' => array(
        'readonly' => 'readonly',
        'disabled' => 'disabled',
        'class' => 'spss-hidden-control',
      ),
    ));
  }

  $wp_customize->add_setting('spss_background_video', array(
    'default'           => '',
    'sanitize_callback' => 'absint'
  ));

  if (spss_fs()->is_premium()) {
    $wp_customize->add_control(new WP_Customize_Media_Control(
      $wp_customize,
      'spss_background_video',
      array(
        'label'       => __('Background Video', 'stylopress'),
        'description' => __('Upload an MP4 or WebM video file to use as the video background.', 'stylopress'),
        'section' => 'spss_background_settings_section',
        'settings' => 'spss_background_video',
        'mime_type' => 'video',
      )
    ));
  }

  if (spss_fs()->is_free_plan()) {
    $wp_customize->add_control(
      'spss_background_video',
      array(
        'label'       => __('Background Video', 'stylopress'),
        'description' => __('Upload an MP4 or WebM video file to use as the video background.', 'stylopress') .
          '<br><span style="color: red; font-style: normal;">Available only for premium users</span>',
        'section' => 'spss_background_settings_section',
        'settings' => 'spss_background_video',
        'input_attrs' => array(
          'readonly' => 'readonly',
          'disabled' => 'disabled',
          'class' => 'spss-hidden-control',
        ),
      )
    );
  }
}
add_action('customize_register', 'spss_background_settings_section_content');
