<?php

/* Template Name: Custom Login Page */

if (!defined('ABSPATH')) {
  exit;
}

?>

<!DOCTYPE html>
<html class="spss new" <?php language_attributes(); ?>>

<head>
  <meta charset="<?php bloginfo('charset'); ?>" />
  <title><?php echo esc_html(get_bloginfo('name')) . ' - Custom Login Page'; ?></title>
  <?php wp_head(); ?>
</head>

<body <?php body_class('spss new'); ?>>

  <?php
  $video_id = get_theme_mod('spss_background_video');
  $video_url = $video_id ? wp_get_attachment_url($video_id) : '';
  if ($video_url): ?>
    <div class="spss-background-video">
      <video autoplay muted loop id="bg-video">
        <source src="<?php echo esc_url($video_url); ?>" type="video/mp4">
        Your browser does not support the video tag.
      </video>
    </div>
  <?php endif; ?>

  <div class="login-container">
    <div class="login-box">
      <h1 class="login-title"><a></a></h1>
      <div id="login-message" class="message-info">
        <p>Please enter your username or email address. You will receive an email message with instructions on how to reset your password.</p>
      </div>
      <div id="error-message" class="message-error">
        <p><b>Error:</b> There is no account with that username or email address.</p>
      </div>

      <form name="loginform" id="custom-login-form" method="post">
        <div class="form-field">
          <label for="user_login" class="form-label">Username or Email Address</label>
          <input type="text" name="log" id="user_login" class="input-field" value="" size="20" autocapitalize="none" autocomplete="username" required="required">
        </div>
        <div class="form-field password-field">
          <label for="user_pass" class="form-label">Password</label>
          <div class="password-wrapper">
            <input type="password" name="pwd" id="user_pass" class="input-field password-input" value="" size="20" autocomplete="current-password" spellcheck="false" required="required">
            <button type="button" class="toggle-password button-secondary" data-toggle="0" aria-label="Show password">
              <span class="dashicons dashicons-visibility" aria-hidden="true"></span>
            </button>
          </div>
        </div>
        <label for="rememberme" class="remember-me">
          <input name="rememberme" type="checkbox" id="rememberme" value="forever">
          <span>Remember Me</span>
        </label>
        <button type="submit" class="submit-button">Log In</button>
        <?php wp_nonce_field('login', 'login_nonce'); ?>
      </form>

      <p id="nav">
        <a class="wp-login-lost-password">Lost your password?</a>
      </p>
      <p id="backtoblog">
        <a class="wp-login-register">← Go to Website</a>
      </p>
    </div>
  </div>

  <?php wp_footer(); ?>
</body>

</html>