<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_is_login_page()
{
  $request_uri = isset($_SERVER['REQUEST_URI']) ? esc_url_raw(wp_unslash($_SERVER['REQUEST_URI'])) : '';
  $request_uri = sanitize_text_field($request_uri);
  return (strpos($request_uri, 'wp-login.php') !== false || strpos($request_uri, 'login.php') !== false);
}

function spss_hex_to_rgba($hex, $alpha = 0.0)
{
  $hex = ltrim($hex, '#');
  if (strlen($hex) === 3) {
    $hex = str_repeat($hex[0], 2) . str_repeat($hex[1], 2) . str_repeat($hex[2], 2);
  }
  $r = hexdec(substr($hex, 0, 2));
  $g = hexdec(substr($hex, 2, 2));
  $b = hexdec(substr($hex, 4, 2));
  return "rgba($r, $g, $b, $alpha)";
}

function spss_shared_login_page_styles_settings()
{
  $spss_google_font_family = get_theme_mod('spss_google_font_family', 'Open Sans');
  $spss_google_font_weight = get_theme_mod('spss_google_font_weight', '400');
  $spss_logo_image = get_theme_mod('spss_logo_image', plugin_dir_url(__FILE__) . '../assets/images/default-logo.png');
  $spss_logo_width = get_theme_mod('spss_logo_width', 100);
  $spss_logo_height = get_theme_mod('spss_logo_height', 100);
  $spss_logo_hidden = get_theme_mod('spss_disable_logo', false);
  $spss_logo_rotation_enabled = get_theme_mod('spss_logo_rotation_enabled', false);
  $spss_logo_rotation_speed = get_theme_mod('spss_logo_rotation_speed', 61);
  $spss_form_transparency = get_theme_mod('spss_form_transparency', false);
  $spss_form_background_color = get_theme_mod('spss_form_background_color', '#ffffff');
  $spss_form_background_image = get_theme_mod('spss_form_background_image', '');
  $spss_form_image_background_size = get_theme_mod('spss_form_image_background_size', 'cover');
  $spss_form_image_background_position = get_theme_mod('spss_form_image_background_position', 'center');
  $spss_form_image_background_repeat = get_theme_mod('spss_form_image_background_repeat', 'no-repeat');
  $spss_form_width = get_theme_mod('spss_form_width', 340);
  $spss_form_shadow = get_theme_mod('spss_form_shadow', 0);
  $spss_form_shadow_opacity = get_theme_mod('spss_form_shadow_opacity', '0.5');
  $spss_form_shadow_color = get_theme_mod('spss_form_shadow_color', '#000000');
  $spss_shadow_color_rgba = spss_hex_to_rgba($spss_form_shadow_color, $spss_form_shadow_opacity);
  $spss_form_padding = get_theme_mod('spss_form_padding', 25);
  $spss_form_margin_top = get_theme_mod('spss_form_margin_top', 20);
  $spss_form_border_width = get_theme_mod('spss_form_border_width', 1);
  $spss_form_border_style = get_theme_mod('spss_form_border_style', 'solid');
  $spss_form_border_color = get_theme_mod('spss_form_border_color', '#a2a0a0');
  $spss_form_border_radius = get_theme_mod('spss_form_border_radius', 0);
  $spss_input_label_color = get_theme_mod('spss_input_label_color', '#333333');
  $spss_input_label_font_size = get_theme_mod('spss_input_label_font_size', '13');
  $spss_remember_me_toggle_display = get_theme_mod('spss_remember_me_toggle_display', false);
  $spss_input_field_transparency_mode = get_theme_mod('spss_input_field_transparency_mode', false);
  $spss_input_field_background_color = get_theme_mod('spss_input_field_background_color', '#ffffff');
  $spss_input_field_border_radius = get_theme_mod('spss_input_field_border_radius', 5);
  $spss_input_field_border_color = get_theme_mod('spss_input_field_border_color', '#2c3338');
  $spss_input_field_border_width = get_theme_mod('spss_input_field_border_width', 1);
  $spss_input_field_border_bottom = get_theme_mod('spss_input_field_border_bottom', false);
  $spss_input_field_text_color = get_theme_mod('spss_input_field_text_color', '#000000');
  $spss_input_field_border_style = get_theme_mod('spss_input_field_border_style', 'solid');
  $spss_input_field_password_eye_color = get_theme_mod('spss_input_field_password_eye_color', '#000000');
  $spss_input_field_password_eye_color_hover = get_theme_mod('spss_input_field_password_eye_color_hover', '#000000');
  $spss_button_color = get_theme_mod('spss_button_color', '#0073aa');
  $spss_button_color_hover = get_theme_mod('spss_button_color_hover', '#005177');
  $spss_button_border_width = get_theme_mod('spss_button_border_width', 1);
  $spss_button_border_color = get_theme_mod('spss_button_border_color', '#036391');
  $spss_button_border_radius = get_theme_mod('spss_button_border_radius', 2);
  $spss_button_border_style = get_theme_mod('spss_button_border_style', 'solid');
  $spss_button_text_size = get_theme_mod('spss_button_text_size', 13);
  $spss_button_text_color = get_theme_mod('spss_button_text_color', '#ffffff');
  $spss_button_text_color_hover = get_theme_mod('spss_button_text_color_hover', '#ffffff');
  $spss_button_text_style = get_theme_mod('spss_button_text_style', 'capitalize');
  $spss_button_text_weight = get_theme_mod('spss_button_text_weight', 'normal');
  $spss_button_top_margin = get_theme_mod('spss_button_top_margin', 0);
  $spss_button_width = get_theme_mod('spss_button_width', 25);
  $spss_button_transparency_mode = get_theme_mod('spss_button_transparency_mode', false);
  $spss_background_color = get_theme_mod('spss_background_color', '#f0f0f1');
  $spss_background_image = get_theme_mod('spss_background_image', '');
  $spss_background_position = get_theme_mod('spss_background_position', 'center center');
  $spss_background_image_size = get_theme_mod('spss_background_image_size', 'cover');
  $spss_background_repeat = get_theme_mod('spss_background_repeat', 'no-repeat');
  $spss_background_image_mobile = get_theme_mod('spss_background_image_mobile', '');
  $spss_background_border_width = get_theme_mod('spss_background_border_width', 100);
  $spss_background_border_height = get_theme_mod('spss_background_border_height', 100);
  $spss_background_overlay_color = get_theme_mod('spss_background_overlay_color', '#000000');
  $spss_background_overlay_opacity = get_theme_mod('spss_background_overlay_opacity', '0.0');
  $spss_background_overlay_rgba = spss_hex_to_rgba($spss_background_overlay_color, $spss_background_overlay_opacity);
  $spss_notice_transparency = get_theme_mod('spss_notice_transparency', false);
  $spss_notice_background_color = get_theme_mod('spss_notice_background_color', '#ffffff');
  $spss_notice_text_color = get_theme_mod('spss_notice_text_color', '#000000');
  $spss_notice_font_size = get_theme_mod('spss_notice_font_size', 13);
  $spss_notice_border_left_width = get_theme_mod('spss_notice_border_left_width', 4);
  $spss_notice_border_radius = get_theme_mod('spss_notice_border_radius', 0);
  $spss_notice_border_color = get_theme_mod('spss_notice_border_color', '#ffffff');
  $spss_notice_info_left_border_color = get_theme_mod('spss_notice_info_left_border_color', '#72aee6');
  $spss_notice_error_left_border_color = get_theme_mod('spss_notice_error_left_border_color', '#d63638');
  $spss_footer_first_label_display = get_theme_mod('spss_footer_first_label_display', false);
  $spss_footer_second_label_display = get_theme_mod('spss_footer_second_label_display', false);
  $spss_footer_label_font_size = get_theme_mod('spss_footer_label_font_size', 11);
  $spss_footer_text_color = get_theme_mod('spss_footer_text_color', '#000000');
  $spss_footer_text_color_hover = get_theme_mod('spss_footer_text_color_hover', '#555555');

  if (is_customize_preview() || spss_is_login_page()) {
    return "
        :root {
          --spss-lp-margin-zero: 0px;
          --spss-lp-padding-zero: 0px;
          --spss-lp-full-width: 100%;
          --spss-lp-full-height: 100%;
          --spss-lp-display-grid: grid;
          --spss-lp-place-items: center;
          --spss-lp-position-relative: relative;
          --spss-lp-position-absolute: absolute;
          --spss-lp-top-zero: 0;
          --spss-lp-left-zero: 0;
          --spss-lp-before-content: '';
          --spss-lp-z-index-minus-1: -1;
          --spss-lp-z-index-plus-1: 1;
          --spss-lp-object-fit-cover: cover;
          --spss-lp-pointer-events-none: none;
          --spss-lp-pixel-1: 1px;
          --spss-lp-border-solid: solid;
          --spss-lp-none-value: none;
          --spss-lp-transparent-value: transparent;
          --spss-lp-display-flex: flex;
          --spss-lp-justify-content-center: center;
          --spss-lp-align-items-center: center;
          --spss-lp-flex-direction-column: column;
          --spss-lp-transition-all: all 0.2s ease-in-out;
          --spss-lp-login-form-max-width-mobile: 320px;
          --spss-lp-overflow-hidden: hidden;
          --spss-lp-display-block: block;
          --spss-lp-logo-background-size-cover: cover;
          --spss-lp-logo-background-size-contain: contain;
          --spss-lp-line-height-1: 1;
          --spss-lp-float-none: none;
          --spss-lp-float-remember-me-input: " . ($spss_button_width > 25 ? 'none' : 'left') . ";
          --spss-lp-float-submit-button: " . ($spss_button_width > 25 ? 'none' : 'right') . ";
          --spss-lp-display-inline-block: inline-block;
          --spss-lp-display-submit-button:  " . ($spss_button_width > 25 ? 'block' : 'inline-block') . ";
          --spss-lp-form-remember-me-width: 45%;
          --spss-lp-form-min-height: 235px;
          --spss-lp-video-overlay: rgba(0, 0, 0, 0.5);
          --spss-lp-footer-label-margin: 15px 15px 0 0;
          --spss-lp-google-font-family: \"{$spss_google_font_family}\", sans-serif;
          --spss-lp-google-font-weight: {$spss_google_font_weight};
          --spss-lp-logo-image: url('" . esc_url($spss_logo_image) . "');
          --spss-lp-logo-width: {$spss_logo_width}px;
          --spss-lp-logo-height: {$spss_logo_height}px;
          --spss-lp-logo-hidden: " . ($spss_logo_hidden ? 'none' : 'block') . ";
          --spss-lp-logo-rotation-enabled: " . ($spss_logo_rotation_enabled ? 'spss-animation-spin ' . $spss_logo_rotation_speed . 's linear infinite' : 'none') . ";
          --spss-lp-form-background-color: " . ($spss_form_transparency ? 'transparent' : ($spss_form_background_color)) . ";
          --spss-lp-form-background-image: url('" . esc_url($spss_form_background_image) . "');
          --spss-lp-form-image-background-size: {$spss_form_image_background_size};
          --spss-lp-form-image-background-position: {$spss_form_image_background_position};
          --spss-lp-form-image-background-repeat: {$spss_form_image_background_repeat};
          --spss-lp-form-width: {$spss_form_width}px;
          --spss-lp-box-shadow-style: 0px 0px {$spss_form_shadow}px {$spss_shadow_color_rgba};
          --spss-lp-form-border-radius: {$spss_form_border_radius}px;
          --spss-lp-form-border-width: {$spss_form_border_width}px;
          --spss-lp-form-border-style: {$spss_form_border_style};
          --spss-lp-form-border-color: {$spss_form_border_color};
          --spss-lp-form-padding: {$spss_form_padding}px;
          --spss-lp-form-margin-top: {$spss_form_margin_top}px;
          --spss-lp-input-label-color: {$spss_input_label_color};
          --spss-lp-input-label-font-size: {$spss_input_label_font_size}px;
          --spss-lp-input-background-color: " . ($spss_input_field_transparency_mode ? 'transparent' : ($spss_input_field_background_color)) . ";
          --spss-lp-remember-me-toggle-display: " . ($spss_remember_me_toggle_display ? 'none' : 'inline-block') . ";
          --spss-lp-input-field-border-radius: {$spss_input_field_border_radius}px;
          --spss-lp-input-field-border-color: {$spss_input_field_border_color};
          --spss-lp-input-field-border-width: " . ($spss_input_field_border_bottom ? "0 0 {$spss_input_field_border_width}px 0" : "{$spss_input_field_border_width}px") . ";
          --spss-lp-input-field-text-color: {$spss_input_field_text_color};
          --spss-lp-input-field-border-style: {$spss_input_field_border_style};
          --spss-lp-input-field-password-eye-color: {$spss_input_field_password_eye_color};
          --spss-lp-input-field-password-eye-color-hover: {$spss_input_field_password_eye_color_hover};
          --spss-lp-button-color: " . ($spss_button_transparency_mode ? 'transparent' : ($spss_button_color)) . ";
          --spss-lp-button-color-hover: " . ($spss_button_transparency_mode ? 'transparent' : ($spss_button_color_hover)) . ";
          --spss-lp-button-border-style: {$spss_button_border_style};
          --spss-lp-button-border-width: {$spss_button_border_width}px;
          --spss-lp-button-border-color: {$spss_button_border_color};
          --spss-lp-button-border-radius: {$spss_button_border_radius}px;
          --spss-lp-button-text-size: {$spss_button_text_size}px;
          --spss-lp-button-text-color: {$spss_button_text_color};
          --spss-lp-button-text-color-hover: {$spss_button_text_color_hover};
          --spss-lp-button-text-style: {$spss_button_text_style};
          --spss-lp-button-text-weight: {$spss_button_text_weight};
          --spss-lp-button-top-margin: {$spss_button_top_margin}px;
          --spss-lp-button-width: {$spss_button_width}%;
          --spss-lp-background-color: {$spss_background_color};
          --spss-lp-background-image: url('" . esc_url($spss_background_image) . "');
          --spss-lp-background-position: {$spss_background_position};
          --spss-lp-background-image-size: {$spss_background_image_size};
          --spss-lp-background-repeat: {$spss_background_repeat};
          --spss-lp-background-image-mobile: " . ($spss_background_image_mobile === '' ? "url('" . esc_url($spss_background_image) . "')" : "url('" . esc_url($spss_background_image_mobile) . "')") . ";
          --spss-lp-background-border-width: {$spss_background_border_width}%;
          --spss-lp-background-border-height: {$spss_background_border_height}%;
          --spss-lp-background-overlay: {$spss_background_overlay_rgba};
          --spss-lp-notice-background-color: " . ($spss_notice_transparency ? 'transparent' : ($spss_notice_background_color)) . ";
          --spss-lp-notice-text-color: {$spss_notice_text_color};
          --spss-lp-notice-font-size: {$spss_notice_font_size}px;
          --spss-lp-notice-border-left-width: {$spss_notice_border_left_width}px;
          --spss-lp-notice-border-radius: {$spss_notice_border_radius}px;
          --spss-lp-notice-border-color: {$spss_notice_border_color};
          --spss-lp-notice-info-left-border-color: {$spss_notice_info_left_border_color};
          --spss-lp-notice-error-left-border-color: {$spss_notice_error_left_border_color};
          --spss-lp-footer-first-label-display: " . ($spss_footer_first_label_display ? 'none' : 'inline-block') . ";
          --spss-lp-footer-second-label-display: " . ($spss_footer_second_label_display ? 'none' : 'inline-block') . ";
          --spss-lp-footer-label-font-size: {$spss_footer_label_font_size}px;
          --spss-lp-footer-text-color: {$spss_footer_text_color};
          --spss-lp-footer-text-color-hover: {$spss_footer_text_color_hover};
        }";
  }
  return "";
}

function spss_customizer_login_page_styles()
{
  spss_shared_login_page_styles_settings();
}
add_action('wp_head', 'spss_customizer_login_page_styles');

function spss_wp_login_page_styles()
{
  spss_shared_login_page_styles_settings();
}
add_action('login_head', 'spss_wp_login_page_styles');
