<?php

if (!defined('ABSPATH')) {
  exit;
}

define('SPSS_CUSTOMIZER_SECTION_PATH', plugin_dir_path(__FILE__) . 'sections/');

require_once SPSS_CUSTOMIZER_SECTION_PATH . 'logo-settings-section.php';
require_once SPSS_CUSTOMIZER_SECTION_PATH . 'login-form-settings-section.php';
require_once SPSS_CUSTOMIZER_SECTION_PATH . 'input-fields-settings-section.php';
require_once SPSS_CUSTOMIZER_SECTION_PATH . 'button-settings-section.php';
require_once SPSS_CUSTOMIZER_SECTION_PATH . 'background-settings-section.php';
require_once SPSS_CUSTOMIZER_SECTION_PATH . 'notice-settings-section.php';
require_once SPSS_CUSTOMIZER_SECTION_PATH . 'footer-settings-section.php';
require_once SPSS_CUSTOMIZER_SECTION_PATH . 'google-fonts-settings-section.php';
require_once SPSS_CUSTOMIZER_SECTION_PATH . 'custom-code-settings-section.php';

function spss_customizer_login_page_styles_settings($wp_customize)
{
  $wp_customize->add_panel('spss_login_customizer_panel', array(
    'title'    => __('StyloPress Login Page', 'stylopress'),
    'priority' => 199,
  ));

  $wp_customize->add_section('spss_logo_settings_section', array(
    'title'    =>  __('Logo Customization', 'stylopress'),
    'priority' => 20,
    'description' => __('Customize the appearance and behavior of the logo on the login page, including size, rotation, and positioning.', 'stylopress'),
    'panel'    => 'spss_login_customizer_panel',
  ));

  $wp_customize->add_section('spss_login_form_settings_section', array(
    'title'    =>  __('Login Form Settings', 'stylopress'),
    'priority' => 21,
    'description' => __('Customize the appearance of the login form, including transparency, background, dimensions, border, shadow, and padding.', 'stylopress'),
    'panel'    => 'spss_login_customizer_panel',
  ));

  $wp_customize->add_section('spss_input_fields_settings_section', array(
    'title'       => __('Input Elements Settings', 'stylopress'),
    'priority'    => 22,
    'description' => __('Customize the appearance of input fields in the login form, including colors, margins, and font sizes.', 'stylopress'),
    'panel'       => 'spss_login_customizer_panel',
  ));

  $wp_customize->add_section('spss_button_styles_section', array(
    'title'       => __('Button Styles', 'stylopress'),
    'priority'    => 23,
    'description' => __('Customize the appearance of the login button, including colors, borders, text styles, and spacing.', 'stylopress'),
    'panel'       => 'spss_login_customizer_panel',
  ));

  $wp_customize->add_section('spss_background_settings_section', array(
    'title'       => __('Background Design', 'stylopress'),
    'priority'    => 30,
    'description' => __('Customize the background of the WordPress login page, including colors, images, and borders.', 'stylopress'),
    'panel'       => 'spss_login_customizer_panel',
  ));

  $wp_customize->add_section('spss_notice_settings_section', array(
    'title'       => __('Messages Settings', 'stylopress'),
    'priority'    => 35,
    'description' => __('Customize the messages of the WordPress login page, including text colors, font sizes, background- and border-colors.', 'stylopress'),
    'panel'       => 'spss_login_customizer_panel',
  ));

  $wp_customize->add_section('spss_footer_settings_section', array(
    'title'       => __('Footer Settings', 'stylopress'),
    'priority'    => 40,
    'description' => __('Customize the footer of the WordPress login page, including text colors, font sizes, and label visibility.', 'stylopress'),
    'panel'       => 'spss_login_customizer_panel',
  ));

  $wp_customize->add_section('spss_google_fonts_settings_section', array(
    'title'       => __('Google Fonts', 'stylopress'),
    'priority'    => 45,
    'description' => __('Customize the font family for the login page using Google Fonts.', 'stylopress'),
    'panel'       => 'spss_login_customizer_panel',
  ));

  $wp_customize->add_section('spss_custom_code_section', array(
    'title'       => __('Custom CSS/JS Code', 'stylopress'),
    'priority'    => 162,
    'description' => __('Add custom CSS and JavaScript for the login page. Custom CSS and JS do not take effect live. To preview the changes, save the settings and visit the login page.', 'stylopress'),
    'panel'       => 'spss_login_customizer_panel',
  ));
}
add_action('customize_register', 'spss_customizer_login_page_styles_settings');
