<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_enqueue_customizer_settings_scripts($hook)
{
  if ('stylopress_page_spss_customize_login_page' !== $hook) {
    return;
  }

  $plugin_dir = plugin_dir_path(__FILE__);
  $is_css_file_exists = file_exists($plugin_dir . 'assets/css/spss-customizer-page-styles.css');

  wp_enqueue_style(
    'spss-customizer-page-styles',
    plugin_dir_url(__FILE__) . 'assets/css/spss-customizer-page-styles.css',
    array(),
    $is_css_file_exists ? filemtime($plugin_dir . 'assets/css/spss-customizer-page-styles.css') : false
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_customizer_settings_scripts');

function spss_enqueue_login_page_customizer_fields_styles()
{
  $plugin_dir = plugin_dir_path(__FILE__);
  $css_file = $plugin_dir . 'assets/css/spss-lp-customizer-fields-styles.css';

  $is_file_exists = file_exists($css_file);

  wp_enqueue_style(
    'spss-lp-customizer-fields-styles',
    plugin_dir_url(__FILE__) . 'assets/css/spss-lp-customizer-fields-styles.css',
    array(),
    $is_file_exists ? filemtime($css_file) : false
  );
}
add_action('customize_controls_enqueue_scripts', 'spss_enqueue_login_page_customizer_fields_styles');

function spss_enqueue_login_page_customizer_styles()
{
  $plugin_dir = plugin_dir_path(__FILE__);
  $css_file = $plugin_dir . 'assets/css/spss-lp-customizer-styles.css';

  $is_file_exists = file_exists($css_file);

  wp_enqueue_style(
    'spss-login-page-customizer-styles',
    plugin_dir_url(__FILE__) . 'assets/css/spss-lp-customizer-styles.css',
    array(),
    $is_file_exists ? filemtime($css_file) : false
  );

  $style_content = spss_shared_login_page_styles_settings();
  if (!empty($style_content)) {
    wp_add_inline_style('spss-login-page-customizer-styles', wp_kses_post($style_content));
  }
}
add_action('customize_preview_init', 'spss_enqueue_login_page_customizer_styles');

function spss_enqueue_login_page_wp_styles()
{
  $plugin_dir = plugin_dir_path(__FILE__);
  $css_file = $plugin_dir . 'assets/css/spss-lp-wp-styles.css';

  $is_file_exists = file_exists($css_file);

  wp_enqueue_style(
    'spss-login-page-wp-styles',
    plugin_dir_url(__FILE__) . 'assets/css/spss-lp-wp-styles.css',
    array(),
    $is_file_exists ? filemtime($css_file) : false
  );

  $style_content = spss_shared_login_page_styles_settings();
  if (!empty($style_content)) {
    wp_add_inline_style('spss-login-page-wp-styles', wp_kses_post($style_content));
  }
}
add_action('login_enqueue_scripts', 'spss_enqueue_login_page_wp_styles');

function spss_enqueue_login_page_customizer_sections_scripts()
{
  $plugin_dir = plugin_dir_path(__FILE__);
  $js_file = $plugin_dir . 'assets/javascript/spss-lp-customizer-sections.js';

  $is_file_exists = file_exists($js_file);

  wp_enqueue_script(
    'spss-customizer-login-page-sections-scripts',
    plugin_dir_url(__FILE__) . 'assets/javascript/spss-lp-customizer-sections.js',
    array('jquery', 'customize-preview'),
    $is_file_exists ? filemtime($js_file) : false,
    true
  );
}
add_action('customize_controls_enqueue_scripts', 'spss_enqueue_login_page_customizer_sections_scripts');

function spss_enqueue_login_page_template_styles()
{
  $plugin_dir = plugin_dir_path(__FILE__);
  $css_file = $plugin_dir . 'assets/css/spss-lp-template-styles.css';

  $is_file_exists = file_exists($css_file);

  wp_enqueue_style(
    'spss-login-page-template-styles',
    plugin_dir_url(__FILE__) . 'assets/css/spss-lp-template-styles.css',
    array(),
    $is_file_exists ? filemtime($css_file) : false
  );
}
add_action('customize_preview_init', 'spss_enqueue_login_page_template_styles');

function spss_login_video_background()
{
  $video_id = get_theme_mod('spss_background_video');

  if ($video_id) {
    $video_url = wp_get_attachment_url($video_id);
    if ($video_url) {
      $style_content = "
          body.login .spss-background-video {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
            object-fit: cover;
            pointer-events: none;
          }
          body.login .spss-background-video #bg-video {
            width: 100%;
            height: 100%;
            object-fit: cover;
          }
          body.login .spss-background-video .video-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            pointer-events: none;
            z-index: 1;
          }
      ";
      wp_add_inline_style('login', wp_kses_post($style_content));

      echo '
        <div class="spss-background-video">
          <video autoplay muted loop id="bg-video">
              <source src="' . esc_url($video_url) . '" type="video/mp4">
              Your browser does not support the video tag.
          </video>
          <div class="video-overlay"></div>
        </div>
      ';
    }
  }
}
add_action('login_enqueue_scripts', 'spss_login_video_background');

function spss_apply_custom_code_to_login_page()
{
  wp_register_script('login', '', [], '', true);
  wp_enqueue_script('login');

  $custom_js = get_theme_mod('spss_custom_js', '');
  if (!empty($custom_js)) {
    wp_add_inline_script('login', wp_kses_post($custom_js));
  }

  $custom_css = get_theme_mod('spss_custom_css', '');
  if (!empty($custom_css)) {
    wp_add_inline_style('login', wp_kses_post($custom_css));
  }
}
add_action('login_enqueue_scripts', 'spss_apply_custom_code_to_login_page');

function spss_update_previous_font()
{
  $current_font = get_theme_mod('spss_google_font_family', 'Open Sans');

  update_option('spss_previous_font_family', $current_font);
  $enable_local_fonts = get_theme_mod('spss_enable_local_fonts', false);

  if ($enable_local_fonts) {
    $font_weight = get_theme_mod('spss_google_font_weight', '400');
    spss_download_selected_font($current_font, $font_weight);
    spss_generate_local_font_css($current_font, $font_weight);
  }
}
add_action('customize_save_after', 'spss_update_previous_font');

function spss_download_selected_font($font_family, $font_weight)
{
  $font_url = 'https://fonts.googleapis.com/css2?family=' . urlencode($font_family) .
    ':wght@' . urlencode($font_weight) . '&display=swap';
  $font_css = wp_remote_get($font_url);

  if (is_wp_error($font_css)) {
    return false;
  }

  $css_body = wp_remote_retrieve_body($font_css);
  preg_match_all('/url\((https:\/\/.*?\.ttf|woff2?)\)/', $css_body, $matches);

  $upload_dir = wp_upload_dir();
  $font_dir = $upload_dir['basedir'] . '/spss-stylopress-google-fonts/';

  if (!file_exists($font_dir)) {
    wp_mkdir_p($font_dir);
  }

  if (empty($GLOBALS['wp_filesystem'])) {
    require_once(ABSPATH . 'wp-admin/includes/file.php');
    WP_Filesystem();
  }

  global $wp_filesystem;

  foreach ($matches[1] as $font_file_url) {
    $file_name = basename($font_file_url);
    $file_path = $font_dir . $file_name;

    if (!file_exists($file_path)) {
      $font_file = wp_remote_get($font_file_url);
      if (!is_wp_error($font_file)) {
        $wp_filesystem->put_contents($file_path, wp_remote_retrieve_body($font_file));
      }
    }
  }
  return true;
}

function spss_generate_local_font_css($font_family, $font_weight)
{
  $font_url = 'https://fonts.googleapis.com/css2?family=' . urlencode($font_family) . ':wght@' . urlencode($font_weight) . '&display=swap';
  $font_css = wp_remote_get($font_url);
  global $wp_filesystem;

  if (is_wp_error($font_css)) {
    return false;
  }

  $css_body = wp_remote_retrieve_body($font_css);
  preg_match_all('/url\((https:\/\/.*?\.ttf)\)/', $css_body, $matches);

  if (empty($matches[1])) {
    return false;
  }

  $font_file_url = $matches[1][0];
  $file_name = basename($font_file_url);

  $upload_dir = wp_upload_dir();
  $font_dir = $upload_dir['basedir'] . '/spss-stylopress-google-fonts/';

  if (!file_exists($font_dir)) {
    wp_mkdir_p($font_dir);
  }

  foreach (glob($font_dir . '*') as $existing_file) {
    wp_delete_file($existing_file);
  }

  $font_file = wp_remote_get($font_file_url);
  if (!is_wp_error($font_file)) {
    $wp_filesystem->put_contents($font_dir . $file_name, wp_remote_retrieve_body($font_file));
  }

  $css_path = $font_dir . strtolower($font_family) . '.css';
  $css = "@font-face {
        font-family: '{$font_family}';
        src: url('{$upload_dir['baseurl']}/spss-stylopress-google-fonts/{$file_name}') format('truetype');
        font-weight: {$font_weight};
        font-style: normal;
    }";

  $wp_filesystem->put_contents($css_path, $css);

  return true;
}

function spss_cleanup_local_fonts_on_save()
{
  $delete_fonts = get_theme_mod('spss_cleanup_local_fonts', false);
  global $wp_filesystem;

  if ($delete_fonts) {
    $upload_dir = wp_upload_dir();
    $font_dir = $upload_dir['basedir'] . '/spss-stylopress-google-fonts/';

    if (file_exists($font_dir)) {
      foreach (glob($font_dir . '*') as $file) {
        wp_delete_file($file);
      }

      if ($wp_filesystem->is_dir($font_dir)) {
        $wp_filesystem->rmdir($font_dir);
      }
    }
  }

  set_theme_mod('spss_cleanup_local_fonts', false);
}
add_action('customize_save_after', 'spss_cleanup_local_fonts_on_save');

function spss_enqueue_google_fonts_to_login_page()
{
  $enable_local_fonts = get_theme_mod('spss_enable_local_fonts', false);
  $font_family = get_theme_mod('spss_google_font_family', 'Open Sans');

  if ($enable_local_fonts) {
    $upload_dir = wp_upload_dir();
    $css_path = $upload_dir['baseurl'] . '/spss-stylopress-google-fonts/' . strtolower($font_family) . '.css';

    if (file_exists($upload_dir['basedir'] . '/spss-stylopress-google-fonts/' . strtolower($font_family) . '.css')) {
      wp_enqueue_style('spss-local-font', $css_path, [], null);
    }
  } else {
    $font_weight = get_theme_mod('spss_google_font_weight', '400');
    $font_url = 'https://fonts.googleapis.com/css2?family=' . urlencode($font_family) .
      ':wght@' . urlencode($font_weight) . '&display=swap';
    wp_enqueue_style('spss-google-font', $font_url, [], null);
  }
}
add_action('login_enqueue_scripts', 'spss_enqueue_google_fonts_to_login_page');

function spss_enqueue_google_font_customizer()
{
  $font_family = get_theme_mod('spss_google_font_family', 'Open Sans');
  $font_weight = get_theme_mod('spss_google_font_weight', '400');

  $font_url = 'https://fonts.googleapis.com/css2?family=' . urlencode($font_family) .
    ':wght@' . urlencode($font_weight) . '&display=swap';

  wp_enqueue_style('spss-google-font', $font_url, false, null);
}
add_action('customize_preview_init', 'spss_enqueue_google_font_customizer');

function spss_get_google_fonts_weights()
{
  return array(
    'Open Sans'           => array('400', '700'),
    'Roboto'              => array('400', '700'),
    'Dancing Script'      => array('400', '700'),
    'Montserrat'          => array('400', '700'),
    'Lato'                => array('400', '700'),
    'Poppins'             => array('400', '700'),
    'Source Sans Pro'     => array('400', '700'),
    'Oswald'              => array('400', '700'),
    'Raleway'             => array('400', '700'),
    'Nunito'              => array('400', '700'),
    'Merriweather'        => array('400', '700'),
    'Playfair Display'    => array('400', '700'),
    'Anton'               => array('400'),
    'Abril Fatface'       => array('400'),
    'Lobster'             => array('400'),
    'Quicksand'           => array('400', '700'),
    'Amatic SC'           => array('400', '700'),
    'Cinzel'              => array('400', '700'),
    'Pacifico'            => array('400'),
    'Indie Flower'        => array('400'),
    'Cabin'               => array('400', '700'),
    'Barlow'              => array('400', '700'),
    'Josefin Sans'        => array('400', '700'),
    'Cormorant Garamond'  => array('400', '700'),
    'Zilla Slab'          => array('400', '700'),
    'Lora'                => array('400', '700'),
    'PT Sans'             => array('400', '700'),
    'Fjalla One'          => array('400'),
    'Bitter'              => array('400', '700'),
    'Arvo'                => array('400', '700'),
    'Architects Daughter' => array('400'),
    'Bungee'              => array('400'),
    'Press Start 2P'      => array('400'),
    'Orbitron'            => array('400', '700'),
    'Shadows Into Light'  => array('400'),
  );
}

function spss_enqueue_google_fonts_customizer_scripts()
{
  $plugin_dir = plugin_dir_path(__FILE__);
  $js_file = $plugin_dir . 'assets/javascript/spss-lp-customizer-google-fonts.js';
  $is_file_exists = file_exists($js_file);

  wp_enqueue_script(
    'spss-customizer-google-fonts-controls',
    plugin_dir_url(__FILE__) . 'assets/javascript/spss-lp-customizer-google-fonts.js',
    array('customize-controls'),
    $is_file_exists ? filemtime($js_file) : false,
    true
  );

  wp_localize_script(
    'spss-customizer-google-fonts-controls',
    'spssFontWeights',
    spss_get_google_fonts_weights()
  );
}
add_action('customize_controls_enqueue_scripts', 'spss_enqueue_google_fonts_customizer_scripts');

function spss_enqueue_login_page_customizer_scripts()
{
  $plugin_dir = plugin_dir_path(__FILE__);
  $js_file = $plugin_dir . 'assets/javascript/spss-lp-customizer.js';

  $is_file_exists = file_exists($js_file);

  wp_enqueue_script(
    'spss-customizer-login-page-scripts',
    plugin_dir_url(__FILE__) . 'assets/javascript/spss-lp-customizer.js',
    array('jquery', 'customize-preview'),
    $is_file_exists ? filemtime($js_file) : false,
    true
  );

  wp_localize_script(
    'spss-customizer-login-page-scripts',
    'spssFontWeights',
    spss_get_google_fonts_weights()
  );
}
add_action('customize_preview_init', 'spss_enqueue_login_page_customizer_scripts');

function spss_enqueue_lp_customizer_main_page_scripts($hook)
{
  if ('stylopress_page_spss_customize_login_page' !== $hook) {
    return;
  }

  $plugin_dir = plugin_dir_path(__FILE__);
  $is_js_file_exists = file_exists($plugin_dir . 'assets/javascript/spss-lp-customizer-main-page.js');

  wp_enqueue_script(
    'spss-lp-customizer-main-page-js',
    plugin_dir_url(__FILE__) . 'assets/javascript/spss-lp-customizer-main-page.js',
    array(),
    $is_js_file_exists ? filemtime($plugin_dir . 'assets/javascript/spss-lp-customizer-main-page.js') : false
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_lp_customizer_main_page_scripts');
