/*!
 * Copyright (c) 2024 StyloPress - CodeWS.online
 * This file is part of StyloPress.
 *
 * This file is licensed under the same terms as the main plugin (GNU GPL v2 or later).
 */

(function (api) {
	function updateFontLink(fontFamily, fontWeight) {
		const fontLinkId = 'spss-google-font-link';
		let fontLink = document.getElementById(fontLinkId);

		if (!fontLink) {
			fontLink = document.createElement('link');
			fontLink.id = fontLinkId;
			fontLink.rel = 'stylesheet';
			document.head.appendChild(fontLink);
		}

		fontLink.href = `https://fonts.googleapis.com/css2?family=${encodeURIComponent(
			fontFamily
		)}:wght@${fontWeight}&display=swap&ver=${Date.now()}`;
	}

	api('spss_google_font_family', function (setting) {
		setting.bind(function (fontFamily) {
			const fontWeight = api('spss_google_font_weight').get() || '400';
			updateFontLink(fontFamily, fontWeight);
			const body = document.querySelector('body.spss.new');
			const submitBtn = document.querySelector(
				'body.spss.new #custom-login-form button.submit-button'
			);
			if (body) {
				body.style.fontFamily = `'${fontFamily}', sans-serif`;
			}
			if (submitBtn) {
				submitBtn.style.fontFamily = `'${fontFamily}', sans-serif`;
			}
			document
				.querySelectorAll(
					'body.spss.new #custom-login-form label, body.spss.new #custom-login-form label span'
				)
				.forEach((label) => {
					label.style.fontFamily = `'${fontFamily}', sans-serif`;
				});
		});
	});

	api('spss_google_font_weight', function (setting) {
		setting.bind(function (fontWeight) {
			const fontFamily =
				api.value('spss_google_font_family')() || 'Open Sans';
			updateFontLink(fontFamily, fontWeight);
			const body = document.querySelector('body.spss.new');
			const submitBtn = document.querySelector(
				'body.spss.new #custom-login-form button.submit-button'
			);
			if (body) {
				body.style.fontWeight = fontWeight;
			}
			if (submitBtn) {
				submitBtn.style.fontWeight = fontWeight;
			}
			document
				.querySelectorAll(
					'body.spss.new #custom-login-form label, body.spss.new #custom-login-form label span'
				)
				.forEach((label) => {
					label.style.fontWeight = fontWeight;
				});
		});
	});

	api('spss_disable_logo', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new .login-title a'
			).style.display = value ? 'none' : 'block';
		});
	});

	api('spss_logo_image', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new .login-title a'
			).style.backgroundImage = `url('${value}')`;
		});
	});

	api('spss_logo_width', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new .login-title a'
			).style.width = `${value}px`;
		});
	});

	api('spss_logo_height', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new .login-title a'
			).style.height = `${value}px`;
		});
	});

	api('spss_logo_rotation_enabled', function () {
		api('spss_logo_rotation_enabled').bind(function (isEnabled) {
			const logoElement = document.querySelector(
				'body.spss.new .login-title a'
			);
			const speed = api('spss_logo_rotation_speed').get();
			logoElement.style.animation = isEnabled
				? `spss-animation-spin ${speed}s linear infinite`
				: 'none';
		});
	});

	api('spss_logo_rotation_speed', function () {
		api('spss_logo_rotation_speed').bind(function (value) {
			const logoElement = document.querySelector(
				'body.spss.new .login-title a'
			);
			const isEnabled = api('spss_logo_rotation_enabled').get();
			if (isEnabled) {
				logoElement.style.animation = `spss-animation-spin ${value}s linear infinite`;
			}
		});
	});

	api('spss_form_transparency', function (setting) {
		setting.bind(function (value) {
			const form = document.querySelector(
				'body.spss.new #custom-login-form'
			);
			if (value) {
				form.style.backgroundColor = 'transparent';
			} else {
				api('spss_form_background_color', function (bgColorSetting) {
					form.style.backgroundColor = bgColorSetting.get();
				});
			}
		});
	});

	api('spss_form_background_color', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form'
			).style.backgroundColor = value;
		});
	});

	api('spss_form_width', function (setting) {
		setting.bind(function (value) {
			document
				.querySelectorAll(
					'body.spss.new #custom-login-form, body.spss.new .login-container'
				)
				.forEach((element) => {
					element.style.maxWidth = `${value}px`;
				});
		});
	});

	api('spss_form_background_image', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form'
			).style.backgroundImage = `url('${value}')`;
		});
	});

	api('spss_form_image_background_size', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form'
			).style.backgroundSize = value;
		});
	});

	api('spss_form_image_background_position', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form'
			).style.backgroundPosition = value;
		});
	});

	api('spss_form_image_background_repeat', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form'
			).style.backgroundRepeat = value;
		});
	});

	api('spss_form_border_radius', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form'
			).style.borderRadius = `${value}px`;
		});
	});

	function hexToRgba(hex, opacity) {
		hex = hex.replace('#', '');
		let r = parseInt(hex.substring(0, 2), 16);
		let g = parseInt(hex.substring(2, 4), 16);
		let b = parseInt(hex.substring(4, 6), 16);
		return `rgba(${r}, ${g}, ${b}, ${opacity})`;
	}

	function applyShadow() {
		const loginForm = document.querySelector(
			'body.spss.new #custom-login-form'
		);
		if (!loginForm) {
			return;
		}
		const shadowValue = api('spss_form_shadow').get();
		const shadowColor = api('spss_form_shadow_color').get();
		const shadowOpacity = api('spss_form_shadow_opacity').get();
		const rgbaColor = hexToRgba(shadowColor, shadowOpacity);
		const shadow = `0px 0px ${shadowValue}px ${rgbaColor}`;
		loginForm.style.boxShadow = shadow;
	}

	api.bind('preview-ready', function () {
		applyShadow();
	});

	api.bind('pane-activated', function () {
		applyShadow();
	});

	api('spss_form_shadow', function (setting) {
		setting.bind(function () {
			applyShadow();
		});
	});

	api('spss_form_shadow_color', function (setting) {
		setting.bind(function () {
			applyShadow();
		});
	});

	api('spss_form_shadow_opacity', function (setting) {
		setting.bind(function () {
			applyShadow();
		});
	});

	api('spss_form_padding', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form'
			).style.padding = `${value}px`;
		});
	});

	api('spss_form_border_width', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form'
			).style.borderWidth = `${value}px`;
		});
	});

	api('spss_form_border_style', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form'
			).style.borderStyle = value;
		});
	});

	api('spss_form_border_color', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form'
			).style.borderColor = value;
		});
	});

	api('spss_form_margin_top', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form'
			).style.marginTop = `${value}px`;
		});
	});

	api('spss_input_label_color', function (setting) {
		setting.bind(function (value) {
			document
				.querySelectorAll(
					'body.spss.new #custom-login-form label, body.spss.new #custom-login-form label span'
				)
				.forEach((label) => {
					label.style.color = value;
				});
		});
	});

	api('spss_input_label_font_size', function (setting) {
		setting.bind(function (value) {
			document
				.querySelectorAll('body.spss.new #custom-login-form label')
				.forEach((label) => {
					label.style.fontSize = `${value}px`;
				});
		});
	});

	api('spss_input_field_transparency_mode', function (setting) {
		setting.bind(function (value) {
			document
				.querySelectorAll(
					'body.spss.new #custom-login-form .form-field input'
				)
				.forEach((inputElm) => {
					if (value) {
						inputElm.style.setProperty(
							'background-color',
							'transparent',
							'important'
						);
					} else {
						api(
							'spss_input_field_background_color',
							function (bgColorSetting) {
								inputElm.style.backgroundColor =
									bgColorSetting.get();
							}
						);
					}
				});
		});
	});

	api('spss_input_field_background_color', function (setting) {
		setting.bind(function (value) {
			document
				.querySelectorAll(
					'body.spss.new #custom-login-form .form-field input'
				)
				.forEach((input) => {
					input.style.backgroundColor = value;
				});
		});
	});

	api('spss_remember_me_toggle_display', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form label.remember-me'
			).style.display = value ? 'none' : 'inline-block';
		});
	});

	api('spss_input_field_border_radius', function (setting) {
		setting.bind(function (value) {
			document
				.querySelectorAll(
					'body.spss.new #custom-login-form .form-field input'
				)
				.forEach((inputElm) => {
					inputElm.style.borderRadius = value + 'px';
				});
		});
	});

	api('spss_input_field_border_color', function (setting) {
		setting.bind(function (value) {
			document
				.querySelectorAll('body.spss.new #custom-login-form input')
				.forEach((inputElm) => {
					inputElm.style.borderColor = value;
				});
		});
	});

	api('spss_input_field_border_width', function (setting) {
		setting.bind(function (value) {
			document
				.querySelectorAll(
					'body.spss.new #custom-login-form .form-field input'
				)
				.forEach((inputElm) => {
					inputElm.style.borderWidth = value + 'px';
				});
		});
	});

	api('spss_input_field_border_bottom', function (setting) {
		setting.bind(function (value) {
			const inputsElms = document.querySelectorAll(
				'body.spss.new #custom-login-form .form-field input'
			);

			if (value) {
				api('spss_input_field_border_width', function (inputBWSetting) {
					inputsElms.forEach((inputElm) => {
						inputElm.style.borderWidth = `0 0 ${inputBWSetting.get()}px 0`;
					});
				});
			} else {
				api('spss_input_field_border_width', function (inputBWSetting) {
					inputsElms.forEach((inputElm) => {
						inputElm.style.borderWidth = `${inputBWSetting.get()}px`;
					});
				});
			}
		});
	});

	api('spss_input_field_text_color', function (setting) {
		setting.bind(function (value) {
			document
				.querySelectorAll(
					'body.spss.new #custom-login-form .form-field input'
				)
				.forEach((inputElm) => {
					inputElm.style.color = value;
				});
		});
	});

	api('spss_input_field_border_style', function (setting) {
		setting.bind(function (value) {
			document
				.querySelectorAll(
					'body.spss.new #custom-login-form .form-field input'
				)
				.forEach((inputElm) => {
					inputElm.style.borderStyle = value;
				});
		});
	});

	api('spss_input_field_password_eye_color', function (setting) {
		setting.bind(function (value) {
			const iconColor = document.querySelector(
				'body.spss.new #custom-login-form .form-field .toggle-password'
			);
			if (iconColor) {
				iconColor.style.color = value;
			}
		});
	});

	api('spss_input_field_password_eye_color_hover', function (setting) {
		setting.bind(function (value) {
			const iconColorHover = document.querySelector(
				'body.spss.new #custom-login-form .form-field .toggle-password'
			);

			if (iconColorHover) {
				iconColorHover.addEventListener('mouseenter', function () {
					this.style.color = value;
				});
				iconColorHover.addEventListener('mouseleave', function () {
					api(
						'spss_input_field_password_eye_color',
						function (iconSetting) {
							const defaultIconColor = iconSetting.get();
							if (defaultIconColor) {
								iconColorHover.style.color = defaultIconColor;
							}
						}
					);
				});
			}
		});
	});

	api('spss_button_color', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form button.submit-button'
			).style.backgroundColor = value;
		});
	});

	api('spss_button_color_hover', function (setting) {
		setting.bind(function (value) {
			const buttonBgColorHover = document.querySelector(
				'body.spss.new #custom-login-form button.submit-button'
			);

			if (buttonBgColorHover) {
				buttonBgColorHover.addEventListener('mouseenter', function () {
					this.style.backgroundColor = value;
				});
				buttonBgColorHover.addEventListener('mouseleave', function () {
					api('spss_button_color', function (bgColorSetting) {
						const defaultBgColor = bgColorSetting.get();
						if (defaultBgColor) {
							buttonBgColorHover.style.backgroundColor =
								defaultBgColor;
						}
					});
				});
			}
		});
	});

	api('spss_button_transparency_mode', function (setting) {
		setting.bind(function (value) {
			const buttonBgColor = document.querySelector(
				'body.spss.new #custom-login-form button.submit-button'
			);
			if (value) {
				buttonBgColor.style.backgroundColor = 'transparent';
				buttonBgColor.addEventListener('mouseenter', function () {
					buttonBgColor.style.backgroundColor = 'transparent';
				});
				buttonBgColor.addEventListener('mouseleave', function () {
					buttonBgColor.style.backgroundColor = 'transparent';
				});
			} else {
				api('spss_button_color', function (bgColorSetting) {
					buttonBgColor.style.backgroundColor = bgColorSetting.get();
				});
				api('spss_button_color_hover', function (bgColorHoverSetting) {
					buttonBgColor.addEventListener('mouseenter', function () {
						buttonBgColor.style.backgroundColor =
							bgColorHoverSetting.get();
					});
					buttonBgColor.addEventListener('mouseleave', function () {
						api('spss_button_color', function (bgColorSetting) {
							const defaultBgColor = bgColorSetting.get();
							if (defaultBgColor) {
								buttonBgColor.style.backgroundColor =
									defaultBgColor;
							}
						});
					});
				});
			}
		});
	});

	api('spss_button_border_style', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form button.submit-button'
			).style.borderStyle = value;
		});
	});

	api('spss_button_border_width', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form button.submit-button'
			).style.borderWidth = `${value}px`;
		});
	});

	api('spss_button_border_color', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form button.submit-button'
			).style.borderColor = value;
		});
	});

	api('spss_button_border_radius', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form button.submit-button'
			).style.borderRadius = `${value}px`;
		});
	});

	api('spss_button_text_size', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form button.submit-button'
			).style.fontSize = `${value}px`;
		});
	});

	api('spss_button_text_color', function (setting) {
		setting.bind(function (value) {
			const buttonTxtColor = document.querySelector(
				'body.spss.new #custom-login-form button.submit-button'
			);
			if (buttonTxtColor) {
				buttonTxtColor.style.color = value;
			}
		});
	});

	api('spss_button_text_color_hover', function (setting) {
		setting.bind(function (value) {
			const buttonTxtColorHover = document.querySelector(
				'body.spss.new #custom-login-form button.submit-button'
			);

			if (buttonTxtColorHover) {
				buttonTxtColorHover.addEventListener('mouseenter', function () {
					this.style.color = value;
				});
				buttonTxtColorHover.addEventListener('mouseleave', function () {
					api('spss_button_text_color', function (textColor) {
						const defaultTextColor = textColor.get();
						if (defaultTextColor) {
							buttonTxtColorHover.style.color = defaultTextColor;
						}
					});
				});
			}
		});
	});

	api('spss_button_text_style', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form button.submit-button'
			).style.textTransform = value;
		});
	});

	api('spss_button_text_weight', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form button.submit-button'
			).style.fontWeight = value;
		});
	});

	api('spss_button_padding_top_bottom', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form button.submit-button'
			).style.paddingTop = `${value}px`;
			document.querySelector(
				'body.spss.new #custom-login-form button.submit-button'
			).style.paddingBottom = `${value}px`;
		});
	});

	api('spss_button_top_margin', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form button.submit-button'
			).style.marginTop = `${value}px`;
		});
	});

	api('spss_button_width', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new #custom-login-form button.submit-button'
			).style.width = `${value}%`;

			if (value > 25) {
				document.querySelector(
					'body.spss.new #custom-login-form button.submit-button'
				).style.float = 'none';
				document.querySelector(
					'body.spss.new #custom-login-form button.submit-button'
				).style.display = 'block';
			} else {
				document.querySelector(
					'body.spss.new #custom-login-form button.submit-button'
				).style.float = 'right';
				document.querySelector(
					'body.spss.new #custom-login-form button.submit-button'
				).style.display = 'inline-block';
			}
		});
	});

	api('spss_background_color', function (setting) {
		setting.bind(function (value) {
			var loginBody = document.querySelector('body.spss.new');
			if (loginBody) {
				loginBody.style.backgroundColor = value;
			}
		});
	});

	api('spss_background_image', function (setting) {
		setting.bind(function (value) {
			document
				.querySelector('body.spss.new')
				.style.setProperty(
					'--spss-lp-background-image',
					`url('${value}')`
				);

			let mobileBackgroundImage = api(
				'spss_background_image_mobile'
			).get();
			if (!mobileBackgroundImage) {
				document
					.querySelector('body.spss.new')
					.style.setProperty(
						'--spss-lp-background-image-mobile',
						`url('${value}')`
					);
			}
		});
	});

	api('spss_background_image_mobile', function (setting) {
		setting.bind(function (value) {
			if (value) {
				document
					.querySelector('body.spss.new')
					.style.setProperty(
						'--spss-lp-background-image-mobile',
						`url('${value}')`
					);
			} else {
				let desktopImage = getComputedStyle(
					document.querySelector('body.spss.new')
				).getPropertyValue('--spss-lp-background-image');
				document
					.querySelector('body.spss.new')
					.style.setProperty(
						'--spss-lp-background-image-mobile',
						desktopImage
					);
			}
		});
	});

	api('spss_background_position', function (setting) {
		setting.bind(function (value) {
			document.querySelector('body.spss.new').style.backgroundPosition =
				value;
		});
	});

	api('spss_background_image_size', function (setting) {
		setting.bind(function (value) {
			document.querySelector('body.spss.new').style.backgroundSize =
				value;
		});
	});

	api('spss_background_repeat', function (setting) {
		setting.bind(function (value) {
			document.querySelector('body.spss.new').style.backgroundRepeat =
				value;
		});
	});

	function applyOverlay() {
		const element = document.querySelector('html.spss.new');
		if (!element) {
			return;
		}
		const overlayColor = api('spss_background_overlay_color').get();
		const overlayOpacity = api('spss_background_overlay_opacity').get();
		const rgbaColor = hexToRgba(overlayColor, overlayOpacity);
		const overlay = `${rgbaColor}`;
		element.style.setProperty('--spss-lp-overlay-color', overlay);
	}

	api.bind('preview-ready', function () {
		applyOverlay();
	});

	api.bind('pane-activated', function () {
		applyOverlay();
	});

	api('spss_background_overlay_color', function (setting) {
		setting.bind(function () {
			applyOverlay();
		});
	});

	api('spss_background_overlay_opacity', function (setting) {
		setting.bind(function () {
			applyOverlay();
		});
	});

	api('spss_background_border_width', function (setting) {
		setting.bind(function (value) {
			document.querySelector('body.spss.new').style.width = `${value}%`;
		});
	});

	api('spss_background_border_height', function (setting) {
		setting.bind(function (value) {
			document.querySelector('body.spss.new').style.height = `${value}%`;
		});
	});

	api('spss_footer_first_label_display', function (setting) {
		setting.bind(function (value) {
			document.querySelector('body.spss.new #nav').style.display = value
				? 'none'
				: 'inline-block';
		});
	});

	api('spss_footer_second_label_display', function (setting) {
		setting.bind(function (value) {
			document.querySelector('body.spss.new #backtoblog').style.display =
				value ? 'none' : 'inline-block';
		});
	});

	api('spss_footer_label_font_size', function (setting) {
		setting.bind(function (value) {
			document
				.querySelectorAll(
					'body.spss.new #nav .wp-login-lost-password, body.spss.new #backtoblog .wp-login-register'
				)
				.forEach((label) => {
					label.style.fontSize = `${value}px`;
				});
		});
	});

	api('spss_footer_text_color', function (setting) {
		setting.bind(function (value) {
			const buttonTxtColor = document
				.querySelectorAll(
					'body.spss.new #nav .wp-login-lost-password, body.spss.new #backtoblog .wp-login-register'
				)
				.forEach((label) => {
					label.style.color = value;
				});
		});
	});

	api('spss_footer_text_color_hover', function (setting) {
		setting.bind(function (value) {
			document
				.querySelectorAll(
					'body.spss.new #nav .wp-login-lost-password, body.spss.new #backtoblog .wp-login-register'
				)
				.forEach((label) => {
					label.addEventListener('mouseenter', function () {
						this.style.color = value;
					});
					label.addEventListener('mouseleave', function () {
						api('spss_footer_text_color', function (textColor) {
							const defaultTextColor = textColor.get();
							if (defaultTextColor) {
								label.style.color = defaultTextColor;
							}
						});
					});
				});
		});
	});

	api.bind('preview-ready', function () {
		api.preview.bind(
			'spss-custom:update-message-info',
			function (isExpanded) {
				var messageInfoElements = document.querySelectorAll(
					'body.spss .message-info, body.spss .message-error'
				);

				messageInfoElements.forEach(function (messageInfoElement) {
					messageInfoElement.style.display = isExpanded
						? 'block'
						: 'none';
				});

				if (messageInfoElements.length === 0) {
					console.log(
						'.message-info or .message.error elements not found in preview.'
					);
				}
			}
		);
	});

	api('spss_notice_transparency', function (setting) {
		setting.bind(function (value) {
			document
				.querySelectorAll(
					'body.spss.new .message-info, body.spss.new .message-error'
				)
				.forEach((noticeElm) => {
					if (value) {
						noticeElm.style.setProperty(
							'background-color',
							'transparent',
							'important'
						);
					} else {
						api(
							'spss_notice_background_color',
							function (bgColorSetting) {
								noticeElm.style.backgroundColor =
									bgColorSetting.get();
							}
						);
					}
				});
		});
	});

	api('spss_notice_background_color', function (setting) {
		setting.bind(function (value) {
			document
				.querySelectorAll(
					'body.spss.new .message-info, body.spss.new .message-error'
				)
				.forEach((notice) => (notice.style.backgroundColor = value));
		});
	});

	api('spss_notice_text_color', function (setting) {
		setting.bind(function (value) {
			document
				.querySelectorAll(
					'body.spss.new .message-info p, body.spss.new .message-error p'
				)
				.forEach((notice) => (notice.style.color = value));
		});
	});

	api('spss_notice_font_size', function (setting) {
		setting.bind(function (value) {
			document
				.querySelectorAll(
					'body.spss.new .message-info p, body.spss.new .message-error p'
				)
				.forEach((notice) => (notice.style.fontSize = `${value}px`));
		});
	});

	api('spss_notice_border_left_width', function (setting) {
		setting.bind(function (value) {
			document
				.querySelectorAll(
					'body.spss.new .message-info, body.spss.new .message-error'
				)
				.forEach(
					(notice) => (notice.style.borderLeftWidth = `${value}px`)
				);
		});
	});

	api('spss_notice_border_radius', function (setting) {
		setting.bind(function (value) {
			document
				.querySelectorAll(
					'body.spss.new .message-info, body.spss.new .message-error'
				)
				.forEach(
					(notice) => (notice.style.borderRadius = `${value}px`)
				);
		});
	});

	api('spss_notice_border_color', function (setting) {
		setting.bind(function (value) {
			document
				.querySelectorAll(
					'body.spss.new .message-info, body.spss.new .message-error'
				)
				.forEach((notice) => {
					notice.style.borderTopColor = value;
					notice.style.borderRightColor = value;
					notice.style.borderBottomColor = value;
				});
		});
	});

	api('spss_notice_info_left_border_color', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new .message-info'
			).style.borderLeftColor = value;
		});
	});

	api('spss_notice_error_left_border_color', function (setting) {
		setting.bind(function (value) {
			document.querySelector(
				'body.spss.new .message-error'
			).style.borderLeftColor = value;
		});
	});
})(wp.customize);
