/*!
 * Copyright (c) 2024 StyloPress - CodeWS.online
 * This file is part of StyloPress.
 *
 * This file is licensed under the same terms as the main plugin (GNU GPL v2 or later).
 */

(function (api) {
	api.bind('ready', function () {
		var panel = api.panel('spss_login_customizer_panel');
		if (panel) {
			panel.expanded.bind(function (isExpanded) {
				var url;
				if (isExpanded) {
					url = api.settings.url.home + '/custom-login-page/';
					api.previewer.previewUrl.set(url);
				} else {
					url = api.settings.url.home;
					api.previewer.previewUrl.set(url);
				}
			});
		}

		var section = api.section('spss_notice_settings_section');
		if (section) {
			section.expanded.bind(function (isExpanded) {
				api.previewer.send(
					'spss-custom:update-message-info',
					isExpanded
				);
			});
		}
	});
})(wp.customize);
