/*!
 * Copyright (c) 2024 StyloPress - CodeWS.online
 * This file is part of StyloPress.
 *
 * This file is licensed under the same terms as the main plugin (GNU GPL v2 or later).
 */

(function (api) {
	api('spss_google_font_family', function (setting) {
		setting.bind(function (font) {
			const weights = spssFontWeights[font] || [];
			const weightControl = api.control('spss_google_font_weight');

			if (weightControl) {
				const selectElement = weightControl.container.find('select');
				selectElement.empty();

				weights.forEach((weight) => {
					selectElement.append(
						new Option(getWeightLabel(weight), weight)
					);
				});

				if (weights.length > 0) {
					const defaultWeight =
						weights.length > 0 ? weights[0] : '400';
					weightControl.setting.set(defaultWeight);
					selectElement.val(defaultWeight);
				}
			}
		});
	});

	function getWeightLabel(weight) {
		switch (weight) {
			case '100':
				return 'Thin (100)';
			case '200':
				return 'Extra Light (200)';
			case '300':
				return 'Light (300)';
			case '400':
				return 'Normal (400)';
			case '500':
				return 'Medium (500)';
			case '600':
				return 'Semi Bold (600)';
			case '700':
				return 'Bold (700)';
			case '800':
				return 'Extra Bold (800)';
			case '900':
				return 'Black (900)';
			default:
				return `Weight ${weight}`;
		}
	}
})(wp.customize);
