<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_register_tab6_settings()
{
  register_setting('spss_settings_group_6', 'spss_footer_content', array(
    'type'              => 'string',
    'sanitize_callback' => 'spss_sanitize_footer_content',
  ));
  register_setting('spss_settings_group_6', 'spss_footer_version_toggle', array(
    'type'              => 'string',
    'sanitize_callback' => 'spss_sanitize_footer_checkbox',
  ));
  register_setting('spss_settings_group_6', 'spss_footer_toggle', array(
    'type'              => 'string',
    'sanitize_callback' => 'spss_sanitize_footer_checkbox',
  ));

  add_settings_section(
    'spss_footer_settings_section',
    __('Footer Settings', 'stylopress'),
    function () {
      echo '<p>' . esc_html__('Control the visibility and content of the WordPress footer.', 'stylopress') . '</p>';
    },
    'spss_settings_group_6'
  );

  add_settings_field(
    'spss_footer_content',
    __('Footer Content', 'stylopress'),
    function () {
      $value = get_option('spss_footer_content', __('Thank you for creating with WordPress.', 'stylopress'));
      echo '<textarea name="spss_footer_content" rows="3" cols="50" class="regular-text">' . esc_textarea($value) . '</textarea>';
    },
    'spss_settings_group_6',
    'spss_footer_settings_section'
  );

  add_settings_field(
    'spss_footer_version_toggle',
    __('Hide Version Number', 'stylopress'),
    function () {
      $value = get_option('spss_footer_version_toggle', false);
      echo '<input type="checkbox" name="spss_footer_version_toggle" value="1"' . checked(1, $value, false) . '> ' . esc_html__('Hide WordPress version number.', 'stylopress');
    },
    'spss_settings_group_6',
    'spss_footer_settings_section'
  );

  add_settings_field(
    'spss_footer_toggle',
    __('Hide Footer', 'stylopress'),
    function () {
      $value = get_option('spss_footer_toggle', false);
      echo '<input type="checkbox" name="spss_footer_toggle" value="1"' . checked(1, $value, false) . '> ' . esc_html__('Hide WordPress footer text.', 'stylopress');
    },
    'spss_settings_group_6',
    'spss_footer_settings_section'
  );
}
add_action('admin_init', 'spss_register_tab6_settings');

function spss_sanitize_footer_content($input)
{
  return wp_kses_post($input);
}

function spss_sanitize_footer_checkbox($input)
{
  return $input === '1' ? '1' : '0';
}

function spss_apply_footer_settings($text)
{
  if (get_option('spss_footer_toggle')) {
    return '';
  }

  $custom_content = get_option('spss_footer_content', $text);

  return wp_kses($custom_content, array(
    'p'    => array('class' => array()),
    'span' => array('id' => array()),
    'a'    => array('href' => array())
  ));
}
add_filter('admin_footer_text', 'spss_apply_footer_settings');

function spss_hide_footer_version($version)
{
  if (get_option('spss_footer_version_toggle')) {
    return '';
  }
  return $version;
}
add_filter('update_footer', 'spss_hide_footer_version', 999);

function spss_display_tab_6()
{
  do_settings_sections('spss_settings_group_6');
}
