<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_register_tab5_settings()
{
  register_setting('spss_settings_group_5', 'spss_toggle_wp_menu_top_bar', array(
    'type'              => 'string',
    'sanitize_callback' => 'spss_sanitize_visibility_checkbox',
  ));
  add_settings_section(
    'spss_top_bar_settings_section',
    __('Top Bar Settings', 'stylopress'),
    function () {
      echo '<p>' . esc_html__('Control the visibility and content of WordPress Menu.', 'stylopress') . '</p>';
    },
    'spss_settings_group_5'
  );
  add_settings_field(
    'spss_toggle_wp_menu_top_bar',
    __('Hide WP Logo in Top Bar', 'stylopress'),
    function () {
      $value = get_option('spss_toggle_wp_menu_top_bar', false);
      echo '<input type="checkbox" name="spss_toggle_wp_menu_top_bar" value="1"' . checked(1, $value, false) . '> ' . esc_html__('Hide WordPress menu in Top Bar.', 'stylopress');
    },
    'spss_settings_group_5',
    'spss_top_bar_settings_section'
  );
}
add_action('admin_init', 'spss_register_tab5_settings');

function spss_remove_wp_menu_top_bar($wp_admin_bar)
{
  if (get_option('spss_toggle_wp_menu_top_bar')) {
    $wp_admin_bar->remove_node('wp-logo');
  }
}
add_action('admin_bar_menu', 'spss_remove_wp_menu_top_bar', 999);

function spss_sanitize_visibility_checkbox($input)
{
  return $input === '1' ? '1' : '0';
}

function spss_display_tab_5()
{
  do_settings_sections('spss_settings_group_5');
}
