<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_register_tab4_settings()
{
  register_setting('spss_settings_group_4', 'spss_profile_image', array(
    'type'              => 'string',
    'sanitize_callback' => 'sanitize_url',
  ));
  add_settings_section(
    'spss_profile_image_section',
    __('Profile Image Settings', 'stylopress'),
    function () {
      echo '<p>' . esc_html__('Upload a custom profile image.', 'stylopress') . '</p>';
    },
    'spss_settings_group_4'
  );
  add_settings_field(
    'spss_profile_image',
    __('Profile Image', 'stylopress'),
    'spss_profile_image_field',
    'spss_settings_group_4',
    'spss_profile_image_section'
  );

  register_setting('spss_settings_group_4', 'spss_logo_image', array(
    'type'              => 'string',
    'sanitize_callback' => 'sanitize_url',
  ));
  add_settings_section(
    'spss_logo_image_section',
    __('Logo Image Settings', 'stylopress') . ' 🧩',
    function () {
      echo '<span>' . esc_html__('Upload a custom logo image.', 'stylopress') . '</span><br>';
      echo '<small><span style="margin-top: 2px; color: #646970; font-style: italic;">' . esc_html__('The logo will be displayed in "Logo" widget.', 'stylopress') . '</span></small>';
    },
    'spss_settings_group_4'
  );
  add_settings_field(
    'spss_logo_image',
    __('Logo Image', 'stylopress'),
    'spss_logo_image_field',
    'spss_settings_group_4',
    'spss_logo_image_section'
  );
}
add_action('admin_init', 'spss_register_tab4_settings');

function spss_profile_image_field()
{
  $value = get_option('spss_profile_image', '');
?>
  <div id="spss_image_upload_container">
    <input type="hidden" id="spss_profile_image" name="spss_profile_image" value="<?php echo esc_attr($value); ?>">
    <div id="spss_image_upload_box" style="border: 2px dashed #ddd; padding: 20px; cursor: pointer; text-align: center; max-width: 150px; position: relative;">
      <img id="spss_profile_image_preview" src="<?php echo esc_url($value); ?>" style="width: 150px; height: 150px; display: <?php echo $value ? 'block' : 'none'; ?>;">
      <span id="spss_upload_text" style="color: #888; display: <?php echo $value ? 'none' : 'inline'; ?>;"><?php esc_html_e('Click to Upload Image', 'stylopress'); ?></span>
    </div>
    <br>
    <button type="button" class="button" id="spss_remove_image_button" style="<?php echo $value ? 'display: inline-block;' : 'display: none;'; ?>">
      <?php esc_html_e('Remove Image', 'stylopress'); ?>
    </button>
  </div>
  <p><?php esc_html_e('Upload a custom profile image. ', 'stylopress'); ?></p>
  <p><?php esc_html_e('For best results, use an image with a 1:1 ratio (e.g., 150x150px).', 'stylopress'); ?></p>
<?php
}

function spss_apply_profile_image_settings($avatar, $id_or_email, $args)
{
  $user_id = false;

  if (is_numeric($id_or_email)) {
    $user_id = (int)$id_or_email;
  } elseif (is_object($id_or_email) && isset($id_or_email->ID)) {
    $user_id = (int)$id_or_email->ID;
  } elseif (is_string($id_or_email) && is_email($id_or_email)) {
    $user = get_user_by('email', $id_or_email);
    $user_id = $user ? $user->ID : false;
  }

  if ($user_id) {
    $installer_admin_id = get_option('spss_installer_admin_id');

    if ((int) $installer_admin_id === $user_id) {
      $custom_avatar = get_option('spss_profile_image', '');

      if (empty($custom_avatar)) {
        $custom_avatar = get_user_meta($user_id, 'spss_profile_image', true);
      }

      if (!empty($custom_avatar)) {
        if (!is_array($args)) {
          $args = array();
        }

        $size = isset($args['size']) ? $args['size'] : 64;
        $alt = isset($args['alt']) ? $args['alt'] : 'Admin Avatar';
        $class = isset($args['class']) ? $args['class'] : '';

        $avatar = '<img alt="' . esc_attr($alt) . '" src="' . esc_url($custom_avatar) . '" class="avatar avatar-' . esc_attr($size) . ' photo ' . esc_attr($class) . '" height="' . esc_attr($size) . '" width="' . esc_attr($size) . '">';
      }
    } else {
      $custom_avatar = get_user_meta($user_id, 'avatar', true);

      if (!empty($custom_avatar)) {
        if (!is_array($args)) {
          $args = array();
        }

        $size = isset($args['size']) ? $args['size'] : 64;
        $alt = isset($args['alt']) ? $args['alt'] : 'User Avatar';
        $class = isset($args['class']) ? $args['class'] : '';

        $avatar = '<img alt="' . esc_attr($alt) . '" src="' . esc_url($custom_avatar) . '" class="avatar avatar-' . esc_attr($size) . ' photo ' . esc_attr($class) . '" height="' . esc_attr($size) . '" width="' . esc_attr($size) . '">';
      }
    }
  }
  return $avatar;
}
add_filter('get_avatar', 'spss_apply_profile_image_settings', 10, 5);

function spss_logo_image_field()
{
  $value = get_option('spss_logo_image', '');
?>
  <div id="spss_logo_upload_container">
    <input type="hidden" id="spss_logo_image" name="spss_logo_image" value="<?php echo esc_attr($value); ?>">
    <div id="spss_logo_upload_box" style="border: 2px dashed #ddd; padding: 20px; cursor: pointer; text-align: center; max-width: 300px; position: relative;">
      <img id="spss_logo_image_preview" src="<?php echo esc_url($value); ?>" style="width: 100%; height: auto; display: <?php echo $value ? 'block' : 'none'; ?>;">
      <span id="spss_upload_text" style="color: #888; display: <?php echo $value ? 'none' : 'inline'; ?>;"><?php esc_html_e('Click to Upload Logo', 'stylopress'); ?></span>
    </div>
    <br>
    <button type="button" class="button" id="spss_remove_logo_button" style="<?php echo $value ? 'display: inline-block;' : 'display: none;'; ?>">
      <?php esc_html_e('Remove Logo', 'stylopress'); ?>
    </button>
  </div>
  <p><?php esc_html_e('Upload a logo to display in "Logo-Widget" on the dashboard page. ', 'stylopress'); ?></p>
<?php
}

function spss_display_tab_4()
{
  do_settings_sections('spss_settings_group_4');
}
