<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_register_tab3_settings()
{
  register_setting('spss_settings_group_3', 'spss_hidden_dashboard_items', array(
    'type'              => 'array',
    'sanitize_callback' => 'spss_sanitize_hidden_dashboard_items',
  ));
  add_settings_section(
    'spss_dashboard_items_section',
    __('Menu Items Settings', 'stylopress'),
    function () {
      echo '<p style="margin-bottom: 0;">' . esc_html__('Choose which items to hide from the admin menu.', 'stylopress') . '</p>';
      echo '<small><span style="margin-top: 2px; color: #646970; font-style: italic;">' . esc_html__('Hidden items will apply to all users.', 'stylopress') . '</span></small>';
    },
    'spss_settings_group_3'
  );
  add_settings_field(
    'spss_hidden_dashboard_items',
    __('Hide Menu Items', 'stylopress'),
    function () {
      $value = get_option('spss_hidden_dashboard_items', []);
      $items = [
        'posts' => 'Posts',
        'pages' => 'Pages',
        'comments' => 'Comments',
        'appearance' => 'Appearance',
        'media' => 'Media',
        'plugins' => 'Plugins',
        'users' => 'Users',
        'tools' => 'Tools',
        'settings' => 'Settings',
      ];
      foreach ($items as $key => $label) {
        echo '<label><input type="checkbox" name="spss_hidden_dashboard_items[]" value="' . esc_attr($key) . '" ' . checked(in_array($key, (array)$value), true, false) . '> ' . esc_html($label) . '</label><br>';
      }
    },
    'spss_settings_group_3',
    'spss_dashboard_items_section'
  );

  register_setting('spss_settings_group_3', 'spss_admin_menu_font_weight', array(
    'type'              => 'string',
    'sanitize_callback' => 'spss_sanitize_font_weight',
  ));

  add_settings_section(
    'spss_font_weight_settings_section',
    __('Menu Font Weight Settings', 'stylopress'),
    function () {
      echo '<p>' . esc_html__('Control the font weight of the WordPress admin menu.', 'stylopress') . '</p>';
    },
    'spss_settings_group_3'
  );

  add_settings_field(
    'spss_admin_menu_font_weight',
    __('Menu Font Weight', 'stylopress'),
    function () {
      $value = get_option('spss_admin_menu_font_weight', '400');
      echo '<select name="spss_admin_menu_font_weight" style="width: 100%">
            <option value="400" ' . selected($value, '400', false) . '>' . esc_html__('Normal - 400', 'stylopress') . '</option>
            <option value="700" ' . selected($value, '700', false) . '>' . esc_html__('Bold - 700', 'stylopress') . '</option>
          </select>';
    },
    'spss_settings_group_3',
    'spss_font_weight_settings_section'
  );
}
add_action('admin_init', 'spss_register_tab3_settings');

function spss_sanitize_hidden_dashboard_items($input)
{
  $allowed_values = array('posts', 'pages', 'comments', 'appearance', 'media', 'plugins', 'users', 'tools', 'settings');
  return array_filter((array) $input, function ($item) use ($allowed_values) {
    return in_array($item, $allowed_values, true);
  });
}

function spss_sanitize_font_weight($input)
{
  $allowed_values = array('400', '700');
  return in_array($input, $allowed_values, true) ? $input : '400';
}

function spss_apply_dashboard_items_settings()
{
  $hidden_items = (array) get_option('spss_hidden_dashboard_items', []);

  $dashboard_items = [
    'posts' => 'edit.php',
    'pages' => 'edit.php?post_type=page',
    'comments' => 'edit-comments.php',
    'appearance' => 'themes.php',
    'media' => 'upload.php',
    'plugins' => 'plugins.php',
    'users' => 'users.php',
    'tools' => 'tools.php',
    'settings' => 'options-general.php',
  ];

  foreach ($dashboard_items as $key => $menu_slug) {
    if (in_array($key, $hidden_items)) {
      remove_menu_page($menu_slug);
    }
  }
}
add_action('admin_menu', 'spss_apply_dashboard_items_settings');

function spss_display_tab_3()
{
  do_settings_sections('spss_settings_group_3');
}
