<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_register_tab2_settings()
{
  register_setting('spss_settings_group_2', 'spss_admin_notice_message', array(
    'type'              => 'string',
    'sanitize_callback' => 'sanitize_text_field',
  ));
  add_settings_section(
    'spss_admin_to_admin_notice_settings_section',
    __('Admin Notice Message to other Admins', 'stylopress') . ' 🧩',
    function () {
      echo '<p style="margin-bottom: 0;">' . esc_html__('Show important updates or reminders for all site admins. Visible only on the admin dashboard.', 'stylopress') . '</p>';
      echo '<small><span style="margin-top: 2px; color: #646970; font-style: italic;">' . esc_html__('The message will be displayed in "Admin Notice to Admins" widget.', 'stylopress') . '</span></small>';
    },
    'spss_settings_group_2'
  );
  add_settings_field(
    'spss_admin_to_admins_notice',
    __('Admin Notice', 'stylopress'),
    function () {
      $value = get_option('spss_admin_notice_message');
      echo '<input type="text" name="spss_admin_notice_message" value="' . esc_attr($value) . '" class="regular-text">';
    },
    'spss_settings_group_2',
    'spss_admin_to_admin_notice_settings_section'
  );

  register_setting('spss_settings_group_2', 'spss_admin_to_users_notice_message', array(
    'type'              => 'string',
    'sanitize_callback' => 'sanitize_text_field',
  ));
  add_settings_section(
    'spss_admin_to_users_notice_settings_section',
    __('Admin Notice Message to all Users', 'stylopress') . ' 🧩',
    function () {
      echo '<p style="margin-bottom: 0;">' . esc_html__('Show important updates or reminders for all site users.', 'stylopress') . '</p>';
      echo '<small><span style="margin-top: 2px; color: #646970; font-style: italic;">' . esc_html__('The message will be displayed in "Admin Notice to Users" widget.', 'stylopress') . '</span></small>';
    },
    'spss_settings_group_2'
  );
  add_settings_field(
    'spss_admin_to_users_notice',
    __('Admin Notice', 'stylopress'),
    function () {
      $value = get_option('spss_admin_to_users_notice_message');
      echo '<input type="text" name="spss_admin_to_users_notice_message" value="' . esc_attr($value) . '" class="regular-text">';
    },
    'spss_settings_group_2',
    'spss_admin_to_users_notice_settings_section'
  );
}
add_action('admin_init', 'spss_register_tab2_settings');

function spss_display_tab_2()
{
  do_settings_sections('spss_settings_group_2');
}
