<?php

if (!defined('ABSPATH')) {
  exit;
}

function spss_register_tab1_settings()
{
  register_setting('spss_settings_group_1', 'spss_hide_plugin_for_other_admins', array(
    'type'              => 'string',
    'sanitize_callback' => 'spss_sanitize_admin_plugin_visibility_checkbox',
  ));
  add_settings_section(
    'spss_role_based_visibility_section',
    __('Role-Based Visibility', 'stylopress') . ' 💼',
    function () {
      $disabled_text = spss_fs()->is_free_plan() ? '<span style="color: red;"><br>' . esc_html__("Available only for premium users", 'stylopress') . '</span>' : '';
      echo '<span>' . esc_html__('Ideal for freelancers and web agencies, this option hides the plugin from your client\'s dashboard.', 'stylopress') . '</span>' . wp_kses($disabled_text, array('span' => array('style' => array()), 'br' => array()));
    },
    'spss_settings_group_1'
  );
  add_settings_field(
    'spss_hide_plugin_for_other_admins',
    __('Hide Plugin', 'stylopress'),
    'spss_option_1_callback',
    'spss_settings_group_1',
    'spss_role_based_visibility_section'
  );

  register_setting('spss_settings_group_1', 'spss_developer_name', array(
    'type'              => 'string',
    'sanitize_callback' => 'sanitize_text_field',
  ));
  register_setting('spss_settings_group_1', 'spss_developer_email_address', array(
    'type'              => 'string',
    'sanitize_callback' => 'sanitize_email',
  ));
  register_setting('spss_settings_group_1', 'spss_developer_phone_number', array(
    'type'              => 'string',
    'sanitize_callback' => 'sanitize_text_field',
  ));
  register_setting('spss_settings_group_1', 'spss_developer_site_address', array(
    'type'              => 'string',
    'sanitize_callback' => 'sanitize_url',
  ));

  add_settings_section(
    'spss_contact_settings_section',
    __('Contact Information', 'stylopress') . ' 💼🧩',
    function () {
      $disabled_text = spss_fs()->is_free_plan() ? '<span style="color: red;"><br>' . esc_html__("Available only for premium users", 'stylopress') . '</span>' : '';
      echo '<span style="margin-bottom: 0;">' . esc_html__('Provide contact details for the site developer or administrator. Ideal for freelancers and web agencies.', 'stylopress') . '</span>' . wp_kses($disabled_text, array('span' => array('style' => array()), 'br' => array()));
      echo '<br><small><span style="margin-top: 2px; color: #646970; font-style: italic;">' . esc_html__('The data will be displayed in "Developer Contact Info" widget.', 'stylopress') . '</span></small>';
    },
    'spss_settings_group_1'
  );

  add_settings_field(
    'spss_developer_name',
    __('Developer Name', 'stylopress'),
    function () {
      $disabled = spss_fs()->is_free_plan() ? 'disabled' : '';
      $value = get_option('spss_developer_name');
      echo '<input type="text" name="spss_developer_name" value="' . esc_attr($value) . '" class="regular-text" ' . ($disabled ? 'disabled' : '') . '>';
    },
    'spss_settings_group_1',
    'spss_contact_settings_section'
  );

  add_settings_field(
    'spss_developer_email',
    __('Developer Email Address', 'stylopress'),
    function () {
      $disabled = spss_fs()->is_free_plan() ? 'disabled' : '';
      $value = get_option('spss_developer_email_address');
      echo '<input type="email" name="spss_developer_email_address" value="' . esc_attr($value) . '" class="regular-text" ' . ($disabled ? 'disabled' : '') . '>';
    },
    'spss_settings_group_1',
    'spss_contact_settings_section'
  );

  add_settings_field(
    'spss_phone_number',
    __('Developer Phone Number', 'stylopress'),
    function () {
      $disabled = spss_fs()->is_free_plan() ? 'disabled' : '';
      $value = get_option('spss_developer_phone_number', '');
      echo '<input type="text" name="spss_developer_phone_number" value="' . esc_attr($value) . '" class="regular-text" ' . ($disabled ? 'disabled' : '') . '>';
    },
    'spss_settings_group_1',
    'spss_contact_settings_section'
  );

  add_settings_field(
    'spss_website_url',
    __('Developer Website URL', 'stylopress'),
    function () {
      $disabled = spss_fs()->is_free_plan() ? 'disabled' : '';
      $value = get_option('spss_developer_site_address', '');
      echo '<input type="url" name="spss_developer_site_address" value="' . esc_attr($value) . '" class="regular-text" ' . ($disabled ? 'disabled' : '') . '>';
    },
    'spss_settings_group_1',
    'spss_contact_settings_section'
  );
}
add_action('admin_init', 'spss_register_tab1_settings');

function spss_sanitize_admin_plugin_visibility_checkbox($input)
{
  return $input === '1' ? '1' : '0';
}

function spss_option_1_callback()
{
  $disabled = spss_fs()->is_free_plan() ? 'disabled' : '';

  $value = get_option('spss_hide_plugin_for_other_admins', false);
  echo '<input type="checkbox" name="spss_hide_plugin_for_other_admins" value="1" ' . checked($value, true, false) . ' ' . ($disabled ? 'disabled' : '') . '>';
  echo '<label for="spss_hide_plugin_for_other_admins">' . esc_html__('Hide this plugin from other admin users.', 'stylopress') . '</label>';
  echo '<br><small><span style="margin-left: 20px; color: #646970; font-style: italic;">' . esc_html__('- It will be visible only to the admin who installed the plugin.', 'stylopress') . '</span></small>';
  echo '<br><small><span style="margin-left: 20px; color: #646970; font-style: italic;">' . esc_html__('- By default, this plugin is hidden from non-admin users.', 'stylopress') . '</span></small>';
}

function spss_menu_visibility_based_on_role()
{
  $hide_plugin_for_other_admins = get_option('spss_hide_plugin_for_other_admins', false);
  $installer_admin_id = get_option('spss_installer_admin_id');
  $current_user_id = get_current_user_id();

  if ($hide_plugin_for_other_admins && (int) $installer_admin_id && (int) $installer_admin_id !== (int) $current_user_id) {
    remove_menu_page('stylopress');
  }
}
add_action('admin_menu', 'spss_menu_visibility_based_on_role', 999);

function spss_display_tab_1()
{
  do_settings_sections('spss_settings_group_1');
}
