<?php

if (! defined('ABSPATH')) {
  exit;
}

function spss_enqueue_admin_settings_scripts($hook)
{
  if ('stylopress_page_spss_admin_settings' !== $hook) {
    return;
  }

  $plugin_dir = plugin_dir_path(__FILE__);
  $is_css_file_exists = file_exists($plugin_dir . 'assets/css/spss-admin-settings-page-styles.css');

  wp_enqueue_style(
    'spss-admin-settings-page-styles',
    plugin_dir_url(__FILE__) . 'assets/css/spss-admin-settings-page-styles.css',
    array(),
    $is_css_file_exists ? filemtime($plugin_dir . 'assets/css/spss-admin-settings-page-styles.css') : false
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_admin_settings_scripts');

function spss_enqueue_media_uploader_scripts($hook)
{
  if ('stylopress_page_spss_admin_settings' !== $hook) {
    return;
  }

  $plugin_dir = plugin_dir_path(__FILE__);
  $is_js_file_exists = file_exists($plugin_dir . 'assets/javascript/spss-media-uploader.js');

  wp_enqueue_media();
  wp_enqueue_script(
    'spss-media-uploader',
    plugin_dir_url(__FILE__) . 'assets/javascript/spss-media-uploader.js',
    array('jquery'),
    $is_js_file_exists ? filemtime($plugin_dir . 'assets/javascript/spss-media-uploader.js') : false,
    true
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_media_uploader_scripts');

function spss_enqueue_tab_selector_scripts($hook)
{
  if ('stylopress_page_spss_admin_settings' !== $hook) {
    return;
  }

  $plugin_dir = plugin_dir_path(__FILE__);
  $is_js_file_exists = file_exists($plugin_dir . 'assets/javascript/spss-admin-settings-tab-selector.js');

  wp_enqueue_media();
  wp_enqueue_script(
    'spss-admin-settings-tab-selector',
    plugin_dir_url(__FILE__) . 'assets/javascript/spss-admin-settings-tab-selector.js',
    array('jquery'),
    $is_js_file_exists ? filemtime($plugin_dir . 'assets/javascript/spss-admin-settings-tab-selector.js') : false,
    true
  );
}
add_action('admin_enqueue_scripts', 'spss_enqueue_tab_selector_scripts');
