/*!
 * Copyright (c) 2024 StyloPress - CodeWS.online
 * This file is part of StyloPress.
 *
 * This file is licensed under the same terms as the main plugin (GNU GPL v2 or later).
 */

jQuery(document).ready(function ($) {
	const mediaUploader = null;

	$('#spss_image_upload_box').on('click', function (e) {
		e.preventDefault();

		const mediaUploader = wp.media({
			title: 'Select Profile Image',
			button: {
				text: 'Use This Image',
			},
			multiple: false,
		});

		mediaUploader.on('select', function () {
			const attachment = mediaUploader
				.state()
				.get('selection')
				.first()
				.toJSON();
			$('#spss_profile_image').val(attachment.url);
			$('#spss_profile_image_preview').attr('src', attachment.url).show();
			$('#spss_upload_text').hide();
			$('#spss_remove_image_button').show();
		});

		mediaUploader.open();
	});

	$('#spss_remove_image_button').on('click', function (e) {
		e.preventDefault();

		$('#spss_profile_image').val('');
		$('#spss_profile_image_preview').hide();
		$('#spss_upload_text').show();
		$(this).hide();
	});
});

jQuery(document).ready(function ($) {
	var logo_frame;

	$('#spss_logo_upload_box').click(function (e) {
		e.preventDefault();

		if (logo_frame) {
			logo_frame.open();
			return;
		}

		logo_frame = wp.media.frames.logo_frame = wp.media({
			title: spss_upload_text,
			button: {
				text: 'Use This Image',
			},
			multiple: false,
		});

		logo_frame.on('select', function () {
			var attachment = logo_frame
				.state()
				.get('selection')
				.first()
				.toJSON();
			$('#spss_logo_image').val(attachment.url);
			$('#spss_logo_image_preview').attr('src', attachment.url).show();
			$('#spss_upload_text').hide();
			$('#spss_remove_logo_button').show();
		});

		logo_frame.open();
	});

	$('#spss_remove_logo_button').click(function () {
		$('#spss_logo_image').val('');
		$('#spss_logo_image_preview').hide();
		$('#spss_upload_text').show();
		$(this).hide();
	});
});
