<?php

if (!defined('ABSPATH')) {
  exit;
}

define('SPSS_ADMIN_SETTINGS_PATH', plugin_dir_path(__FILE__) . 'admin-settings/');

require_once SPSS_ADMIN_SETTINGS_PATH . 'enqueue-scripts.php';
require_once SPSS_ADMIN_SETTINGS_PATH . 'settings/tab1.php';
require_once SPSS_ADMIN_SETTINGS_PATH . 'settings/tab2.php';
require_once SPSS_ADMIN_SETTINGS_PATH . 'settings/tab3.php';
require_once SPSS_ADMIN_SETTINGS_PATH . 'settings/tab4.php';
require_once SPSS_ADMIN_SETTINGS_PATH . 'settings/tab5.php';
require_once SPSS_ADMIN_SETTINGS_PATH . 'settings/tab6.php';

function spss_admin_settings_page()
{
  $active_tab = isset($_GET['tab']) ? sanitize_text_field(wp_unslash($_GET['tab'])) : 'tab1';

  if ($active_tab === 'tab1' && isset($_POST['spss_tab1_nonce'])) {
    if (!wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['spss_tab1_nonce'])), 'spss_tab1_nonce_action')) {
      wp_die('Security check failed');
    }
  } elseif ($active_tab === 'tab2' && isset($_POST['spss_tab2_nonce'])) {
    if (!wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['spss_tab2_nonce'])), 'spss_tab2_nonce_action')) {
      wp_die('Security check failed');
    }
  } elseif ($active_tab === 'tab3' && isset($_POST['spss_tab3_nonce'])) {
    if (!wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['spss_tab3_nonce'])), 'spss_tab3_nonce_action')) {
      wp_die('Security check failed');
    }
  } elseif ($active_tab === 'tab4' && isset($_POST['spss_tab4_nonce'])) {
    if (!wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['spss_tab4_nonce'])), 'spss_tab4_nonce_action')) {
      wp_die('Security check failed');
    }
  } elseif ($active_tab === 'tab5' && isset($_POST['spss_tab5_nonce'])) {
    if (!wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['spss_tab5_nonce'])), 'spss_tab5_nonce_action')) {
      wp_die('Security check failed');
    }
  } elseif ($active_tab === 'tab6' && isset($_POST['spss_tab6_nonce'])) {
    if (!wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['spss_tab6_nonce'])), 'spss_tab6_nonce_action')) {
      wp_die('Security check failed');
    }
  }

?>
  <div class="spss-admin-settings-container wrap">
    <h1 class="header">
      <?php esc_html_e('Admin Settings', 'stylopress'); ?>
    </h1>
    <p class="description">
      <?php esc_html_e('Manage menus, profiles, and other admin settings to customize your panel/widgets.', 'stylopress'); ?>
    </p>

    <?php if (isset($_GET['settings-updated']) && sanitize_text_field(wp_unslash($_GET['settings-updated'])) === 'true') : ?>
      <div class="notice notice-success is-dismissible">
        <p><?php esc_html_e('Settings saved successfully.', 'stylopress'); ?></p>
      </div>
    <?php endif; ?>

    <div class="form-wrapper">
      <h2 class="nav-tab-wrapper">
        <a href="#" data-tab="tab1" class="nav-tab nav-tab-active" onclick="switchTab(event, 'tab1')">Freelancer/Developer</a>
        <a href="#" data-tab="tab2" class="nav-tab" onclick="switchTab(event, 'tab2')">Notice Messages</a>
        <a href="#" data-tab="tab3" class="nav-tab" onclick="switchTab(event, 'tab3')">Menu Settings</a>
        <a href="#" data-tab="tab4" class="nav-tab" onclick="switchTab(event, 'tab4')">Image Settings</a>
        <a href="#" data-tab="tab5" class="nav-tab" onclick="switchTab(event, 'tab5')">Top Bar Settings</a>
        <a href="#" data-tab="tab6" class="nav-tab" onclick="switchTab(event, 'tab6')">Footer Settings</a>
      </h2>
      <form method="post" action="options.php" id="tab1" class="tab-content tab-content-first">
        <?php
        settings_fields('spss_settings_group_1');
        wp_nonce_field('spss_tab1_nonce_action', 'spss_tab1_nonce');
        spss_display_tab_1();
        submit_button();
        ?>
      </form>
      <form method="post" action="options.php" id="tab2" class="tab-content">
        <?php
        settings_fields('spss_settings_group_2');
        wp_nonce_field('spss_tab2_nonce_action', 'spss_tab2_nonce');
        spss_display_tab_2();
        submit_button();
        ?>
      </form>
      <form method="post" action="options.php" id="tab3" class="tab-content">
        <?php
        settings_fields('spss_settings_group_3');
        wp_nonce_field('spss_tab3_nonce_action', 'spss_tab3_nonce');
        spss_display_tab_3();
        submit_button();
        ?>
      </form>
      <form method="post" action="options.php" id="tab4" class="tab-content">
        <?php
        settings_fields('spss_settings_group_4');
        wp_nonce_field('spss_tab4_nonce_action', 'spss_tab4_nonce');
        spss_display_tab_4();
        submit_button();
        ?>
      </form>
      <form method="post" action="options.php" id="tab5" class="tab-content">
        <?php
        settings_fields('spss_settings_group_5');
        wp_nonce_field('spss_tab5_nonce_action', 'spss_tab5_nonce');
        spss_display_tab_5();
        submit_button();
        ?>
      </form>
      <form method="post" action="options.php" id="tab6" class="tab-content">
        <?php
        settings_fields('spss_settings_group_6');
        wp_nonce_field('spss_tab6_nonce_action', 'spss_tab6_nonce');
        spss_display_tab_6();
        submit_button();
        ?>
      </form>
    </div>
  </div>
<?php
}
