# Studio Immens CSS Classes

⚡️ Create your own set of custom CSS classes, ready to use with one click, to enhance the design of your Gutenberg blocks.

Developed by [Studio Immens](https://www.studioimmens.com) – Modular digital systems for entrepreneurs and professionals.

[Screenshot](https://raw.githubusercontent.com/Immens95/studio-immens-css-classes/main/screenshot.png)

---

## 🚀 Introduction

**Studio Immens CSS Classes** is a WordPress plugin that adds a section where you can build your own CSS arsenal, so you always have it ready to use to quickly optimize and customize the layout of your WordPress pages, with a focus on:

- Gutenberg Editor
- Themes like Blocksy, GeneratePress, Astra
- Mobile-first pages and modular design

This plugin allows you to create custom classes and add them directly to Gutenberg blocks with one click, for better layouts without having to write additional code each time.

---

## ✅ Key Features

- **Compatible** with Gutenberg, Blocksy, Astra, Kadence
- Minimal CSS, **zero JavaScript**
- Ultra-optimized performance

---

## 📦 Installation

### 1. Manual via GitHub

1. Download or clone the repository:
```bash
git clone https://github.com/Immens95/studio-immens-css-classes.git
Copy the studio-immens-css-classes folder to the /wp-content/plugins/ directory

Activate the plugin from Plugins > Installed Plugins in WordPress

2. Alternative
You can zip the folder and upload it via WordPress from
Plugins > Add New > Upload Plugin

🛠️ How to use
After activating the plugin:

Open a page with the Gutenberg editor.

Select a block and open the "CSS Classes" tab.

Select the name of one or more CSS classes

❓ FAQ
Is it compatible with all themes?
Yes, but it has been optimized to integrate seamlessly with Blocksy and other modern themes.

Can I add my own classes?
Yes. Go to the CSS Classes section and create your own classes with the properties you want.

Will it slow down my site?
No. It's a very lightweight plugin, with no complex JavaScript or PHP dependencies.

📈 Why use it?
Save time on visual development

Write less custom CSS

Improve layout consistency

Ideal for those working with modular or white-label templates

🔗 Resources
Studio Immens Official Website

Studio Immens WordPress Plugin

🧑‍💻 Author
Developed by Studio Immens
Modular digital solutions for professionals, businesses, and web agencies.

👉 Visit studioimmens.com to discover plugins, apps, CRMs, and systems ready to sell.

📄 License
GNU General Public License v2.0
For more information: https://www.gnu.org/licenses/gpl-2.0.html