<?php

// File generated from our OpenAPI spec

namespace Stripe\StripeTaxForWooCommerce\SDK\lib\Service;

class ChargeService extends \Stripe\StripeTaxForWooCommerce\SDK\lib\Service\AbstractService {

	/**
	 * Returns a list of charges you’ve previously created. The charges are returned in
	 * sorted order, with the most recent charges appearing first.
	 *
	 * @param null|array                                                             $params
	 * @param null|array|\Stripe\StripeTaxForWooCommerce\SDK\lib\Util\RequestOptions $opts
	 *
	 * @return \Stripe\StripeTaxForWooCommerce\SDK\lib\Collection<\Stripe\StripeTaxForWooCommerce\SDK\lib\Charge>
	 * @throws \Stripe\StripeTaxForWooCommerce\SDK\lib\Exception\ApiErrorException if the request fails
	 */
	public function all( $params = null, $opts = null ) {
		return $this->requestCollection( 'get', '/v1/charges', $params, $opts );
	}

	/**
	 * Capture the payment of an existing, uncaptured charge that was created with the
	 * <code>capture</code> option set to false.
	 *
	 * Uncaptured payments expire a set number of days after they are created (<a
	 * href="/docs/charges/placing-a-hold">7 by default</a>), after which they are
	 * marked as refunded and capture attempts will fail.
	 *
	 * Don’t use this method to capture a PaymentIntent-initiated charge. Use <a
	 * href="/docs/api/payment_intents/capture">Capture a PaymentIntent</a>.
	 *
	 * @param string                                                                 $id
	 * @param null|array                                                             $params
	 * @param null|array|\Stripe\StripeTaxForWooCommerce\SDK\lib\Util\RequestOptions $opts
	 *
	 * @return \Stripe\StripeTaxForWooCommerce\SDK\lib\Charge
	 * @throws \Stripe\StripeTaxForWooCommerce\SDK\lib\Exception\ApiErrorException if the request fails
	 */
	public function capture( $id, $params = null, $opts = null ) {
		return $this->request( 'post', $this->buildPath( '/v1/charges/%s/capture', $id ), $params, $opts );
	}

	/**
	 * Use the <a href="/docs/api/payment_intents">Payment Intents API</a> to initiate
	 * a new payment instead of using this method. Confirmation of the PaymentIntent
	 * creates the <code>Charge</code> object used to request payment, so this method
	 * is limited to legacy integrations.
	 *
	 * @param null|array                                                             $params
	 * @param null|array|\Stripe\StripeTaxForWooCommerce\SDK\lib\Util\RequestOptions $opts
	 *
	 * @return \Stripe\StripeTaxForWooCommerce\SDK\lib\Charge
	 * @throws \Stripe\StripeTaxForWooCommerce\SDK\lib\Exception\ApiErrorException if the request fails
	 */
	public function create( $params = null, $opts = null ) {
		return $this->request( 'post', '/v1/charges', $params, $opts );
	}

	/**
	 * Retrieves the details of a charge that has previously been created. Supply the
	 * unique charge ID that was returned from your previous request, and Stripe\StripeTaxForWooCommerce\SDK\lib will
	 * return the corresponding charge information. The same information is returned
	 * when creating or refunding the charge.
	 *
	 * @param string                                                                 $id
	 * @param null|array                                                             $params
	 * @param null|array|\Stripe\StripeTaxForWooCommerce\SDK\lib\Util\RequestOptions $opts
	 *
	 * @return \Stripe\StripeTaxForWooCommerce\SDK\lib\Charge
	 * @throws \Stripe\StripeTaxForWooCommerce\SDK\lib\Exception\ApiErrorException if the request fails
	 */
	public function retrieve( $id, $params = null, $opts = null ) {
		return $this->request( 'get', $this->buildPath( '/v1/charges/%s', $id ), $params, $opts );
	}

	/**
	 * Search for charges you’ve previously created using Stripe\StripeTaxForWooCommerce\SDK\lib’s <a
	 * href="/docs/search#search-query-language">Search Query Language</a>. Don’t use
	 * search in read-after-write flows where strict consistency is necessary. Under
	 * normal operating conditions, data is searchable in less than a minute.
	 * Occasionally, propagation of new or updated data can be up to an hour behind
	 * during outages. Search functionality is not available to merchants in India.
	 *
	 * @param null|array                                                             $params
	 * @param null|array|\Stripe\StripeTaxForWooCommerce\SDK\lib\Util\RequestOptions $opts
	 *
	 * @return \Stripe\StripeTaxForWooCommerce\SDK\lib\SearchResult<\Stripe\StripeTaxForWooCommerce\SDK\lib\Charge>
	 * @throws \Stripe\StripeTaxForWooCommerce\SDK\lib\Exception\ApiErrorException if the request fails
	 */
	public function search( $params = null, $opts = null ) {
		return $this->requestSearchResult( 'get', '/v1/charges/search', $params, $opts );
	}

	/**
	 * Updates the specified charge by setting the values of the parameters passed. Any
	 * parameters not provided will be left unchanged.
	 *
	 * @param string                                                                 $id
	 * @param null|array                                                             $params
	 * @param null|array|\Stripe\StripeTaxForWooCommerce\SDK\lib\Util\RequestOptions $opts
	 *
	 * @return \Stripe\StripeTaxForWooCommerce\SDK\lib\Charge
	 * @throws \Stripe\StripeTaxForWooCommerce\SDK\lib\Exception\ApiErrorException if the request fails
	 */
	public function update( $id, $params = null, $opts = null ) {
		return $this->request( 'post', $this->buildPath( '/v1/charges/%s', $id ), $params, $opts );
	}
}
