# StreamNexus WordPress Plugin

## English

### Introduction
The StreamNexus WordPress plugin makes it easy to embed videos hosted on StreamNexus.io. Use a simple shortcode to place adaptive HLS players anywhere on your site without needing an API key.

### Features
- Embed videos with a shortcode that accepts a StreamNexus media ID or share link.
- Responsive player that adapts to width, height, and aspect ratio settings.
- Optional debug information for administrators to inspect shortcode output.
- Lightweight implementation that relies on the StreamNexus web player.

### Installation
1. Download or clone this repository into the `wp-content/plugins` directory of your WordPress site.
2. Activate **StreamNexus Video Embed** from the WordPress admin Plugins screen.

### Usage
#### Basic embed with a media ID
```
[streamnexus-video media_id="YOUR_MEDIA_ID"]
```

#### Using a share link
```
[streamnexus-video share_link="https://app.streamnexus.io/player-page.html?mediaId=YOUR_MEDIA_ID"]
```

#### Optional attributes
- `width` – Accepts values such as `100%` or `800` for a fixed width.
- `height` – When provided, renders the iframe at a fixed height (e.g. `450`).
- `aspect_ratio` – Ratio formatted as `16:9`, `4:3`, etc.
- `height_ratio` – Decimal ratio (e.g. `0.5625`) used for responsive embeds.
- `max_width` – Constrains the container width (e.g. `1200`).
- `autoplay` – Set to `true` to enable autoplay.

You can enable **Debug Mode** under *Settings → StreamNexus* to show shortcode details to site administrators while viewing the front end.

### External service and policies
The plugin loads the StreamNexus player from `https://api.streamnexus.io/player-page.html`. Usage of this player is governed by StreamNexus.io:

- Terms of Service: https://www.streamnexus.io/terms-of-service/
- Privacy Policy: https://www.streamnexus.io/privacy-policy/

## Français

### Introduction
Le plugin StreamNexus pour WordPress permet d'intégrer facilement des vidéos hébergées sur StreamNexus.io. Utilisez un simple shortcode pour afficher le lecteur HLS adaptatif, sans clé API.

### Fonctionnalités
- Intégration via un shortcode acceptant un identifiant media StreamNexus ou un lien de partage.
- Lecteur responsive qui s'adapte à la largeur, la hauteur et au ratio configurés.
- Informations de débogage facultatives pour les administrateurs.
- Implémentation légère utilisant le lecteur web StreamNexus.

### Installation
1. Téléchargez ou clonez ce dépôt dans le dossier `wp-content/plugins` de votre site WordPress.
2. Activez **StreamNexus Video Embed** depuis l'écran Extensions de l'administration WordPress.

### Utilisation
#### Intégration de base avec un identifiant media
```
[streamnexus-video media_id="VOTRE_MEDIA_ID"]
```

#### Utilisation d'un lien de partage
```
[streamnexus-video share_link="https://app.streamnexus.io/player-page.html?mediaId=VOTRE_MEDIA_ID"]
```

#### Attributs optionnels
- `width` – Valeurs comme `100%` ou `800` pour une largeur fixe.
- `height` – Fournit une hauteur fixe pour l'iframe (ex. `450`).
- `aspect_ratio` – Ratio au format `16:9`, `4:3`, etc.
- `height_ratio` – Ratio décimal (ex. `0.5625`) pour un rendu responsive.
- `max_width` – Limite la largeur du conteneur (ex. `1200`).
- `autoplay` – Définir sur `true` pour lancer automatiquement la vidéo.

Activez le **mode débogage** dans *Réglages → StreamNexus* pour afficher les détails du shortcode aux administrateurs sur le front-end.
