<?php
namespace Nahiro\InteractiveMap\Frontend;

class MapShortcode {

    public function __construct() {
        add_shortcode('store-locations-map', [$this, 'nahiroimap_widget_shortcode']);
        add_action('plugins_loaded', [$this, 'load_textdomain']);
    }

    public function load_textdomain() {
        load_plugin_textdomain('store-locations-map', false, dirname(plugin_basename(__FILE__)) . '/languages');
    }
    
    public function nahiroimap_widget_shortcode($atts) {
        $circle_coordinates = get_post_meta($atts["id"], '_circle_coordinates', true);
        $normalizedData = $this->nahiroimap_normalizeArray($circle_coordinates);
        $json = wp_json_encode($normalizedData, JSON_UNESCAPED_SLASHES);
        $map_country = get_option('nahiroimap_country_option', 'germany');
        $map_width_cont = get_post_meta($atts["id"], '_map_width_cont', true);
        $map_size_relation = get_post_meta($atts["id"], '_map_size_relation', true);
        $map_color = get_post_meta($atts["id"], '_map_color', true); 
        $map_color_mouse_over = get_post_meta($atts["id"], '_map_color_mouse_over', true); 
        $stroke_color = get_post_meta($atts["id"], '_stroke_color', true); 
        $stroke_width = get_post_meta($atts["id"], '_stroke_width', true); 
        $bound_velocity = get_post_meta($atts["id"], '_bound_velocity', true); 
        $pines_text_color = get_post_meta($atts["id"], '_pines_text_color', true);
        $pines_display_shape = get_post_meta($atts["id"], '_pines_display_shape', true);
        $pines_shape_color = get_post_meta($atts["id"], '_pines_shape_color', true); 
        $pin_width = get_post_meta($atts["id"], '_pin_width', true); 

        $option_card = __("opcionE", 'store-locations-map');
        $un_id = $atts["id"];
        $jo_pin_text_color = sanitize_hex_color($pines_text_color);
        $bound_velocity = $bound_velocity / 1000;
        
        $percent = 1 + ((100 - $map_size_relation) / 1000);
        $display_pin_shape = $pines_display_shape;
        $pin_shape_color = sanitize_hex_color($pines_shape_color);
        
        $pic_position = "left";
        $name_hide = "no";
        $position_hide = "no";
        $email_hide = "no";
        $cel_hide = "no";
        $pic_hide = get_post_meta($atts["id"], '_pic_hide', true);
        $map_width_cont_unit = get_post_meta($atts["id"], '_map_width_cont_unit', true);
        $pic_position = get_post_meta($atts["id"], '_pic_position', true);

        $circle_coordinates_json = $json;
        $circle_coordinates = json_decode($circle_coordinates_json, true);

        ob_start();
        ?>
        <div display_pin_shape='<?php echo esc_attr($display_pin_shape); ?>' stroke_width='<?php echo esc_attr($stroke_width); ?>' stroke_color='<?php echo esc_attr($stroke_color); ?>' 
        map_color_mouse_over='<?php echo esc_attr($map_color_mouse_over); ?>'  map_color='<?php echo esc_attr($map_color); ?>' pin_size='<?php echo esc_attr($pin_width); ?>'  
        map_size='<?php echo esc_attr($map_width_cont); ?>' jo_pin_text_color='<?php echo esc_attr($jo_pin_text_color); ?>' bound_velocity='<?php echo esc_attr($bound_velocity); ?>' 
        pin_shape_color='<?php echo esc_attr($pin_shape_color); ?>' pin_width='<?php echo esc_attr($pin_width); ?>' percent='<?php echo esc_attr($percent); ?>' 
        circlecoordinates='<?php echo esc_attr($json); ?>' optioncard="<?php echo esc_attr($option_card); ?>" class="nhplgmap custom_map_wrap" percent="<?php echo esc_attr($percent); ?>" 
        map_unit="<?php echo esc_attr($map_width_cont_unit); ?>"
        id="<?php echo esc_attr($un_id); ?>"
        class="shortcode-container"
        style="">
        
        <div attrid="<?php echo esc_attr($un_id); ?>" class="cardnc" style="z-index:10000;" id="cardn_<?php echo esc_attr($un_id); ?>">
            <div class="close-btn"
                style="width:12px; position: absolute;top: -3px;right: 5px;cursor: pointer;color: black;font-weight:bold; padding: 1px;z-index: 11;">
                <img src="<?php echo esc_url(NAHIROIMAP_PLUGIN_URL . 'assets/img/Close_Icon_Black.svg'); ?>" />
            </div>
            <?php if ($pic_hide == "no") { ?>
                <div class="text"
                    style="padding-top:10px; padding-left:10px;left:0%; width: 90%; position:absolute;top: 0;display: flex;flex-direction: column;justify-content: space-between;">
            <?php } else { ?>
                <?php if ($pic_position == "left") { ?>
                    <div class="text"
                        style="padding-top:10px; padding-left:10px;left:30%; width: 60%; position:absolute;top: 0;display: flex;flex-direction: column;justify-content: space-between;">
                <?php } else { ?>
                    <div class="text"
                        style="padding-top:10px; padding-left:1px;padding-right:10px;right:31%; width: 60%; position:absolute;top: 0;display: flex;flex-direction: column;justify-content: space-between;">
                <?php } ?>
            <?php } ?>

            <a id="aW_<?php echo esc_attr($un_id); ?>" href="">
                <?php if ($name_hide == "no") { ?>
                    <div style="text-align:left;line-height:1" class="name_style" id="nameW_<?php echo esc_attr($un_id); ?>"></div>
                <?php } ?>
                <?php if ($position_hide == "no") { ?>
                    <div class="position_style" style="text-align:left;line-height:1" id="positionW_<?php echo esc_attr($un_id); ?>"></div>
                <?php } ?>
            </a>
            <?php if ($cel_hide == "no") { ?>
                <div class="cel_style" style="margin-top:10px; text-align:left;line-height:1" id="celW_<?php echo esc_attr($un_id); ?>"></div>
            <?php } ?>
            <?php if ($email_hide == "no") { ?>
                <div class="email_style" style="text-align:left;line-height:1" id="emailW_<?php echo esc_attr($un_id); ?>"></div>
            <?php } ?>
            </div>
            <?php if ($pic_hide == "yes") { ?>
                <div class="imagecrd" style="height:100px; position: absolute; top: 0; left: 0; width: <?php echo '0%'; ?>"></div>
            <?php } else { ?>
                <?php if ($pic_position == "left") { ?>
                    <div class="imagecrd" style="height:100px; position: absolute; top: 0; left: 0; width: <?php echo '30%'; ?>"></div>
                <?php } else { ?>
                    <div class="imagecrd" style="height:100px; position: absolute; top: 0; right: 0; width: <?php echo '30%'; ?>"></div>
                <?php } ?>
            <?php } ?>
        </div>

        <div class="popupnb_class" id="popupnb_<?php echo esc_attr($un_id); ?>"></div>

        <div class="map-contenedor" style="width:<?php echo esc_attr($map_width_cont) . esc_attr($map_width_cont_unit);?>;">
            <?php
            $dom = new \DOMDocument();
            libxml_use_internal_errors(true);
            $dom->loadHTMLFile(NAHIROIMAP_PLUGIN_URL . 'assets/svgs/' . $map_country . '.svg');
            $xpath = new \DOMXPath($dom);
            $svgNodeList = $xpath->query('//svg');
            if ($svgNodeList->length > 0) {
                $svgElement = $svgNodeList->item(0);
                $svgElement->setAttribute('id', 'mapaalemaniab_' . $un_id);
                $svgElement->setAttribute('baseprofile', 'tiny');
                $svgElement->setAttribute('fill', '#7c7c7c');
                $svgElement->setAttribute('stroke', '#E7E2DF');
                $svgElement->setAttribute('stroke-linecap', 'round');
                $svgElement->setAttribute('stroke-linejoin', 'round');
                $svgElement->setAttribute('stroke-width', '2');
                $svgElement->setAttribute('version', '1.2');
                $svgElement->setAttribute('class', 'mapMain');
                $svgContent = $dom->saveXML($svgElement);
                $svgContent = substr($svgContent, 0, -6);
                echo wp_kses($svgContent,
                    array(
                        'svg' => array(
                            'xmlns' => array(),
                            'id' => array(),
                            'baseProfile' => array(),
                            'fill' => array(),
                            'stroke' => array(),
                            'stroke-linecap' => array(),
                            'stroke-linejoin' => array(),
                            'stroke-width' => array(),
                            'version' => array(),
                            'class' => array(),
                            'viewBox' => array(),
                        ),
                        'path' => array(
                            'id' => array(),
                            'title' => array(),
                            'class' => array(),
                            'd' => array(),
                        ),
                        'circle' => array(
                            'style' => array(),
                            'id' => array(),
                            'cx' => array(),
                            'cy' => array(),
                            'r' => array(),
                            'fill' => array(),
                        )
                    )
                );
            } else {
                echo esc_html( __("No se encontró el SVG en la página.", 'store-locations-map') );
            }
            ?>
            <?php
            $index_ori = 1;
            foreach ($circle_coordinates as $coordinate) {
                $circle_x = esc_js($coordinate['cx']);
                $circle_y = esc_js($coordinate['cy']);
                if ($coordinate['circle_hide'] == 'yes') {
                    $circle_color = 'transparent';
                    $circle_radius = '1';
                } else {
                    $circle_color = sanitize_hex_color($coordinate['circle_color']);
                    $circle_radius = absint($coordinate['circle_ratio']);
                }
                if (!isset($circle_radius) || $circle_radius == "") {
                    $circle_radius = '1';
                    $circle_color = 'transparent';
                }
                if ($circle_radius == "0") {
                    $circle_radius = '1';
                    $circle_color = 'transparent';
                }
                $circle = '<circle style="stroke:' . esc_attr($circle_color) . ';" class="' . esc_attr('cir_' . $index_ori . '_' . $un_id) . '" id="' . esc_attr($index_ori . '_' . $un_id) . '" cx="' . esc_attr($circle_x) . '" cy="' . esc_attr($circle_y) . '" r="' . esc_attr($circle_radius) . '" stroke="' . esc_attr($circle_color) . '"fill="' . esc_attr($circle_color) . '" />';
                echo wp_kses($circle, array(
                    'circle' => array(
                        'style' => array(),
                        'id' => array(),
                        'class' => array(),
                        'cx' => array(),
                        'cy' => array(),
                        'r' => array(),
                        'stroke' => array(),
                        'stroke-width' => array(),
                        'fill' => array(),
                    ),
                ));
                $index_ori = $index_ori + 1;
            }
            ?>
            </svg>
        </div>
        <?php
        return ob_get_clean();
    }

    private function nahiroimap_normalizeArray($array) {
        // Normaliza los datos del array aquí
        return $array;
    }
}
