<?php
    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
?>
<div class="main-config">
    <button type="button" class="tablinks tbl-active" data-selected="main-settings">
        <span class="dashicons dashicons-admin-tools"></span>
        <?php esc_html_e('Main Settings', 'store-locations-map'); ?>
    </button>
    <button type="button" class="tablinks" data-selected="size-settings">
        <span class="dashicons dashicons-editor-expand"></span>
        <?php esc_html_e('Size Settings', 'store-locations-map'); ?>
    </button>
    <button type="button" class="tablinks" data-selected="color-settings">
        <span class="dashicons dashicons-color-picker"></span>
        <?php esc_html_e('Color Settings', 'store-locations-map'); ?>
    </button>
    <button type="button" class="tablinks" data-selected="extra-settings">
        <span class="dashicons dashicons-ellipsis"></span>
        <?php esc_html_e('Extra', 'store-locations-map'); ?>
    </button>
</div>

<!-- /////////////// -->
<!-- TABS CONTAINER -->
<!-- ////////////// -->
<tabs-container>
    <!-- Main Settings -->
    <div id="main-settings" class="tabcontent active">
        <div class="tbc-form-field">
            <p>
                <label for="map_id" class="lconfig"><?php esc_html_e('Map ID', 'store-locations-map'); ?></label>
                <input type="text" class="iconfig" id="map_id" name="map_id" value="<?php echo esc_attr(get_the_ID()); ?>" readonly>
            </p>
        </div>
        <div class="tbc-form-field" style="display:none;">
            <p>
                <label for="map_country" class="lconfig"><?php esc_html_e('Countries', 'store-locations-map'); ?></label>
                <select id="map_country" name="map_country" class="sconfig">
                    <option value="<?php echo esc_attr(get_option('nahiroimap_country_option')); ?>" selected></option>
                </select>
            </p>
        </div>
        <div class="tbc-form-field">
            <p>
                <label for="bound_velocity" class="lconfig">
                    <?php esc_html_e('Bound Velocity (ms)', 'store-locations-map'); ?>
                    <span class="nahiro-tooltip-container">
                        <span class="trigger">?
                            <span class="tooltip"><?php esc_html_e('Change the animation speed of the pins/markers (update the map to see the change)', 'store-locations-map'); ?></span>
                        </span>
                    </span>   
                </label>
                <input type="number" class="iconfig" id="bound_velocity" name="bound_velocity" value="<?php echo esc_attr($bound_velocity); ?>" min="0">
            </p>
        </div>
        <div class="tbc-form-field">
            <p>
                <label for="pines_display_shape" class="lconfig">
                    <?php esc_html_e('Display Pin Shape', 'store-locations-map'); ?>
                    <span class="nahiro-tooltip-container">
                        <span class="trigger">?
                            <span class="tooltip"><?php esc_html_e('Hides the marker and shows only the image (update the map to see the change)', 'store-locations-map'); ?></span>
                        </span>
                    </span>   
                </label>
                <select id="pines_display_shape" class="sconfig" name="pines_display_shape">
                    <option value="" <?php selected($pines_display_shape, ''); ?>>
                        <?php esc_html_e('Yes', 'store-locations-map'); ?></option>
                    <option value="no-xpin" <?php selected($pines_display_shape, 'no-xpin'); ?>>
                        <?php esc_html_e('No', 'store-locations-map'); ?></option>
                </select>
            </p>
        </div>
        <div class="tbc-form-field">
            <p>
                <label for="map_shortcode" class="lconfig"><?php esc_html_e('Shortcode', 'store-locations-map'); ?></label>
                <input type="text" class="iconfig" id="map_shortcode" name="map_shortcode" value="<?php echo esc_attr('[store-locations-map id="' . $post->ID . '"]'); ?>" readonly>
            </p>
        </div>
    </div>

    <!-- Size Settings -->
    <div id="size-settings" class="tabcontent inactive">
        <div class="tbc-form-field">
            <p>
                <label for="map_width_cont" class="size-label">
                    <?php esc_html_e('Container Width', 'store-locations-map'); ?>
                    <span class="nahiro-tooltip-container">
                        <span class="trigger">?
                            <span class="tooltip"><?php esc_html_e('This control selects the width of the container of the map, it can be used to modify the height of the map when decreasing its value (changes not available on preview)', 'store-locations-map'); ?></span>
                        </span>
                    </span>    
                </label>
                <input type="number" class="size-input" id="map_width_cont" name="map_width_cont" value="<?php echo esc_attr($map_width_cont); ?>" min="0" max="2000" step="5">
                <select name="map_width_cont_unit" id="map_width_cont_unit">
                    <option value="px" <?php selected($map_width_cont_unit, 'px'); ?>>
                        <?php esc_html_e('px', 'store-locations-map'); ?>
                    </option>
                    <option value="%" <?php selected($map_width_cont_unit, '%'); ?>>
                        <?php esc_html_e('%', 'store-locations-map'); ?>
                    </option>
                </select>
            </p>
        </div>
        <div class="tbc-form-field">
            <p>
                <label for="map_size_relation" class="size-label">
                    <?php esc_html_e('Map Relative Size (%)', 'store-locations-map'); ?>
                    <span class="nahiro-tooltip-container">
                        <span class="trigger">?
                            <span class="tooltip"><?php esc_html_e('This control modifies the size of the map in relation to the container width, to fill the container this should be at 100% (changes not available on preview)', 'store-locations-map'); ?></span>
                        </span>
                    </span>    
                </label>
                <input type="number" class="size-input" id="map_size_relation" name="map_size_relation" value="<?php echo esc_attr($map_size_relation); ?>" min="0" max="100">
            </p>
        </div>
        <div class="tbc-form-field">
            <p>
                <label for="stroke_width" class="size-label"><?php esc_html_e('Stroke Width', 'store-locations-map'); ?></label>
                <input type="number" class="size-input" id="stroke_width" name="stroke_width" value="<?php echo esc_attr($stroke_width); ?>" min="0" max="100">
            </p>
        </div>
        <div class="tbc-form-field">
            <p>
                <label for="pin_width"><?php esc_html_e('Pin Size', 'store-locations-map'); ?></label>
                <input type="number" id="pin_width" class="pin_input" name="pin_width" value="<?php echo esc_attr($pin_width); ?>" min="0" max="100">
            </p>
        </div>
        <div class="tbc-form-field">
            <p>
                <label for="pin_name_text"><?php esc_html_e('Pin Text Size', 'store-locations-map'); ?></label>
                <input type="number" id="pin_name_text" class="pin_input" name="pin_name_text" value="<?php echo esc_attr($pin_name_text); ?>" min="0" max="100">
            </p>
        </div>
    </div>

    <!-- Color Settings -->
    <div id="color-settings" class="tabcontent inactive">
        <div class="tbc-form-field">
            <p>
                <label for="map_color" class="color-label"><?php esc_html_e('Map Color', 'store-locations-map'); ?></label>
                <input type="color" id="map_color" name="map_color" value="<?php echo esc_attr($map_color); ?>" class="color-picker">
            </p>
        </div>
        <div class="tbc-form-field">
            <p>
                <label for="map_color_mouse_over" class="color-label"><?php esc_html_e('Map Color Mouse Over Region', 'store-locations-map'); ?></label>
                <input type="color" id="map_color_mouse_over" name="map_color_mouse_over" value="<?php echo esc_attr($map_color_mouse_over); ?>" class="color-picker">
            </p>
        </div>
        <div class="tbc-form-field">
            <p>
                <label for="stroke_color" class="color-label"><?php esc_html_e('Stroke Color', 'store-locations-map'); ?></label>
                <input type="color" id="stroke_color" name="stroke_color" value="<?php echo esc_attr($stroke_color); ?>" class="color-picker">
            </p>
        </div>
        <div class="tbc-form-field">
            <p>
                <label for="pines_text_color" class="color-label"><?php esc_html_e('Pin Name Color', 'store-locations-map'); ?></label>
                <input type="color" id="pines_text_color" name="pines_text_color" value="<?php echo esc_attr($pines_text_color); ?>" class="color-picker">
            </p>
        </div>
        <div class="tbc-form-field">
            <p>
                <label for="pines_shape_color" class="color-label"><?php esc_html_e('Pin Shape Color', 'store-locations-map'); ?></label>
                <input type="color" id="pines_shape_color" name="pines_shape_color" value="<?php echo esc_attr($pines_shape_color); ?>" class="color-picker">
            </p>
        </div>
    </div>

    <!-- Pin Settings -->
    <div id="extra-settings" class="tabcontent inactive">
        <div class="tbc-form-field">
            <p>
                <label for="pin_padding_top"><?php esc_html_e('Pin Vertical Position', 'store-locations-map'); ?></label>
                <input type="number" id="pin_padding_top" name="pin_padding_top" value="<?php echo esc_attr($pin_padding_top); ?>" min="0" max="200">
            </p>
        </div>
        <div class="tbc-form-field">
            <p>
                <label for="pin_name_vertical_position"><?php esc_html_e('Pin Text Vertical Position', 'store-locations-map'); ?></label>
                <input type="number" id="pin_name_vertical_position" name="pin_name_vertical_position" value="<?php echo esc_attr($pin_name_vertical_position); ?>" min="0" max="200">
            </p>
        </div>
        <h4 style="margin-bottom:8px;margin-top:24px;"><?php esc_html_e('Card Fields', 'store-locations-map'); ?></h4>
        <div class="tbc-form-field">
            <p>
                <label for="pic_hide"><?php esc_html_e('Hide Image', 'store-locations-map'); ?></label>
                <select name="pic_hide" id="pic_hide">
                    <option value="yes" <?php selected($pic_hide, 'yes'); ?>><?php esc_html_e('Yes', 'store-locations-map'); ?></option>
                    <option value="n" <?php selected($pic_hide, 'n'); ?>><?php esc_html_e('No', 'store-locations-map'); ?></option>
                </select>
            </p>
        </div>
        <div class="tbc-form-field">
            <p>
                <label for="pic_position"><?php esc_html_e('Picture Position', 'store-locations-map'); ?></label>
                <select name="pic_position" id="pic_position">
                    <option value="left" <?php selected($pic_position, 'left'); ?>><?php esc_html_e('Left', 'store-locations-map'); ?></option>
                    <option value="right" <?php selected($pic_position, 'right'); ?>><?php esc_html_e('Right', 'store-locations-map'); ?></option>
                </select>
            </p>
        </div>
    </div>
</tabs-container>

<!-- PINS SECTION -->
<h3><?php esc_html_e('Pins', 'store-locations-map'); ?></h3>
<div id="pin-coordinates-repeater">
    <button type="button" id="add-pin-item"><?php esc_html_e('Add Pin', 'store-locations-map'); ?></button>
    <div id="pin-coordinates-container">
        <?php if (is_array($circle_coordinates) && count($circle_coordinates) > 0): ?>
            <?php foreach ($circle_coordinates as $index => $circle_coordinate): ?>
                <div class="pin-item">
                    <button type="button" class="accordion"><span class="dashicons dashicons-arrow-right-alt2"></span><?php esc_html_e('Pin ', 'store-locations-map'); echo esc_attr($index+1); ?></button>
                    <div class="pin-accordion">
                        <p>
                            <label for="circle_coordinates[<?php echo esc_attr($index); ?>][cx]"><?php esc_html_e('Horizontal Position', 'store-locations-map'); ?></label>
                            <input type="number" name="circle_coordinates[<?php echo esc_attr($index); ?>][cx]" value="<?php echo esc_attr($circle_coordinate['cx']); ?>" />
                        </p>
                        <p>
                            <label for="circle_coordinates[<?php echo esc_attr($index); ?>][cy]"><?php esc_html_e('Vertical Position', 'store-locations-map'); ?></label>
                            <input type="number" name="circle_coordinates[<?php echo esc_attr($index); ?>][cy]" value="<?php echo esc_attr($circle_coordinate['cy']); ?>" />
                        </p>
                        <p>
                            <label for="circle_coordinates[<?php echo esc_attr($index); ?>][circle_name]"><?php esc_html_e('Pin Name', 'store-locations-map'); ?></label>
                            <input type="text" name="circle_coordinates[<?php echo esc_attr($index); ?>][circle_name]" value="<?php echo esc_attr($circle_coordinate['circle_name']); ?>" />
                        </p>
                        <div class="image-form-control">
                            <label for="circle_coordinates[<?php echo esc_attr($index); ?>][circle_image][url]"><?php esc_html_e('Pin Image', 'store-locations-map'); ?> <div class="nahiro-control-desc"><?php esc_html_e('Click the box to select an image', 'store-locations-map'); ?></div></label>
                            <div class="nahiro-img-control pin<?php echo esc_attr($index); ?>-image">
                                <input type="hidden" name="circle_coordinates[<?php echo esc_attr($index); ?>][circle_image][url]" value="<?php echo esc_attr($circle_coordinate['circle_image']['url']); ?>" class="pin<?php echo esc_attr($index); ?>-image-upload-field" />
                                <?php if(isset($circle_coordinate['circle_image']['url']) && !empty($circle_coordinate['circle_image']['url'])): ?>
                                    <div class="nahiro-img-preview pin<?php echo esc_attr($index); ?>-image-preview">
                                        <img src="<?php echo esc_attr($circle_coordinate['circle_image']['url']); ?>" />
                                    </div>
                                    <a href="#" class="nahiro-img-delete pin<?php echo esc_attr($index); ?>-delete-img"><span class="dashicons dashicons-trash"></span></a>
                                <?php else: ?>
                                    <div class="nahiro-img-preview pin<?php echo esc_attr($index); ?>-image-preview"></div>
                                    <a href="#" class="nahiro-img-delete pin<?php echo esc_attr($index); ?>-delete-img hidden"><span class="dashicons dashicons-trash"></span></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <p>
                            <label for="circle_coordinates[<?php echo esc_attr($index); ?>][circle_hide]"><?php esc_html_e('Hide Circle', 'store-locations-map'); ?></label>
                            <select name="circle_coordinates[<?php echo esc_attr($index); ?>][circle_hide]">
                                <option value="yes" <?php selected($circle_coordinate['circle_hide'], 'yes'); ?>><?php esc_html_e('Yes', 'store-locations-map'); ?></option>
                                <option value="no" <?php selected($circle_coordinate['circle_hide'], 'no'); ?>><?php esc_html_e('No', 'store-locations-map'); ?></option>
                            </select>
                        </p>
                        <p>
                            <label for="circle_coordinates[<?php echo esc_attr($index); ?>][circle_color]"><?php esc_html_e('Circle Color', 'store-locations-map'); ?></label>
                            <input class="icolor" type="color" name="circle_coordinates[<?php echo esc_attr($index); ?>][circle_color]" value="<?php echo esc_attr($circle_coordinate['circle_color']); ?>" />
                        </p>
                        <p>
                            <label for="circle_coordinates[<?php echo esc_attr($index); ?>][circle_ratio]"><?php esc_html_e('Circle Size', 'store-locations-map'); ?></label>
                            <input type="number" name="circle_coordinates[<?php echo esc_attr($index); ?>][circle_ratio]" value="<?php echo esc_attr($circle_coordinate['circle_ratio']); ?>" min="1" max="5" />
                        </p>
                        <p>
                            <label for="circle_coordinates[<?php echo esc_attr($index); ?>][left]"><?php esc_html_e('Position Left Name', 'store-locations-map'); ?></label>
                            <input type="number" name="circle_coordinates[<?php echo esc_attr($index); ?>][left]" value="<?php echo esc_attr($circle_coordinate['left']); ?>" />
                        </p>
                        <p>
                            <label for="circle_coordinates[<?php echo esc_attr($index); ?>][top]"><?php esc_html_e('Position Top Name', 'store-locations-map'); ?></label>
                            <input type="number" name="circle_coordinates[<?php echo esc_attr($index); ?>][top]" value="<?php echo esc_attr($circle_coordinate['top']); ?>" />
                        </p>
                        <h4><?php esc_html_e('Cards', 'store-locations-map'); ?></h4>
                        <div class="card-repeater">
                            <div class="card-container">
                                <?php if (isset($circle_coordinate['people']) && is_array($circle_coordinate['people'])): ?>
                                    <?php for ($c_index = 0; $c_index < count($circle_coordinate['people']); $c_index++): ?>
                                        <div class="card-item">
                                            <p>
                                                <label for="circle_coordinates[<?php echo esc_attr($index); ?>][people][<?php echo esc_attr($c_index); ?>][person_name]"><?php esc_html_e('Name', 'store-locations-map'); ?></label>
                                                <input type="text" name="circle_coordinates[<?php echo esc_attr($index); ?>][people][<?php echo esc_attr($c_index); ?>][person_name]" value="<?php echo esc_attr($circle_coordinate['people'][$c_index]['person_name']); ?>" maxlength="23" />
                                            </p>
                                            <p>
                                                <label for="circle_coordinates[<?php echo esc_attr($index); ?>][people][<?php echo esc_attr($c_index); ?>][person_position]"><?php esc_html_e('Information', 'store-locations-map'); ?></label>
                                                <input type="text" name="circle_coordinates[<?php echo esc_attr($index); ?>][people][<?php echo esc_attr($c_index); ?>][person_position]" value="<?php echo esc_attr($circle_coordinate['people'][$c_index]['person_position']); ?>" maxlength="53" />
                                            </p>
                                            <p>
                                                <label for="circle_coordinates[<?php echo esc_attr($index); ?>][people][<?php echo esc_attr($c_index); ?>][person_phone]"><?php esc_html_e('Phone', 'store-locations-map'); ?></label>
                                                <input type="text" name="circle_coordinates[<?php echo esc_attr($index); ?>][people][<?php echo esc_attr($c_index); ?>][person_phone]" value="<?php echo esc_attr($circle_coordinate['people'][$c_index]['person_phone']); ?>" maxlength="30" />
                                            </p>
                                            <p>
                                                <label for="circle_coordinates[<?php echo esc_attr($index); ?>][people][<?php echo esc_attr($c_index); ?>][person_email]"><?php esc_html_e('Email', 'store-locations-map'); ?></label>
                                                <input type="text" name="circle_coordinates[<?php echo esc_attr($index); ?>][people][<?php echo esc_attr($c_index); ?>][person_email]" value="<?php echo esc_attr($circle_coordinate['people'][$c_index]['person_email']); ?>" maxlength="30" />
                                            </p>
                                            <div class="image-form-control">
                                                <label for="circle_coordinates[<?php echo esc_attr($index); ?>][people][<?php echo esc_attr($c_index); ?>][person_image][url]"><?php esc_html_e('Image', 'store-locations-map'); ?></label>
                                                <div class="nahiro-img-control card<?php echo esc_attr($index.$c_index); ?>-image">
                                                    <input type="hidden" name="circle_coordinates[<?php echo esc_attr($index); ?>][people][<?php echo esc_attr($c_index); ?>][person_image][url]" value="<?php echo esc_attr($circle_coordinate['people'][$c_index]['person_image']['url']); ?>" class="card<?php echo esc_attr($index.$c_index); ?>-image-upload-field" />
                                                    <?php if( isset($circle_coordinate['people'][$c_index]['person_image']['url']) && !empty($circle_coordinate['people'][$c_index]['person_image']['url']) ): ?>
                                                        <div class="nahiro-img-preview card<?php echo esc_attr($index.$c_index); ?>-image-preview">
                                                            <img src="<?php echo esc_attr($circle_coordinate['people'][$c_index]['person_image']['url']); ?>" />
                                                        </div>
                                                        <a href="#" class="nahiro-img-delete card<?php echo esc_attr($index.$c_index); ?>-delete-img"><span class="dashicons dashicons-trash"></span></a>
                                                    <?php else: ?>
                                                        <div class="nahiro-img-preview card<?php echo esc_attr($index.$c_index); ?>-image-preview"></div>
                                                        <a href="#" class="nahiro-img-delete card<?php echo esc_attr($index.$c_index); ?>-delete-img hidden"><span class="dashicons dashicons-trash"></span></a>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <button type="button" class="remove-card"><?php esc_html_e('Remove', 'store-locations-map'); ?></button>
                                        </div>
                                    <?php endfor; ?>
                                <?php endif; ?>
                            </div>
                            <button type="button" class="add-card"><?php esc_html_e('Add Card', 'store-locations-map'); ?></button>
                        </div>
                    </div>
                    <button type="button" class="remove-circle-coordinate"><span class="dashicons dashicons-trash"></span></button>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>
<!-- FIN PINS SECTION -->
