<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
?>
<menu>
    <div>
        <img src="<?php echo esc_url(plugin_dir_url(__FILE__) . '../assets/img/Logo-Nahiro.Net-Color.png'); ?>">
    </div>
    <div class="menu-buttons">
        <a href="https://nahiro.net/wordpress-plugins/wordpress-karte-mit-standorten/"
            class="button button-primary upgrade">
            <?php esc_html_e('Upgrade', 'store-locations-map'); ?>
        </a>
        <a href="https://my.nahiro.net/register.php" class="nahiro-link">
            <?php esc_html_e('Create an account', 'store-locations-map'); ?>
        </a>
    </div>
</menu>
<div class="wrap">
    <div class='content'>
        <h1><?php esc_html_e('Welcome to Nahiro.net Shortcode', 'store-locations-map'); ?></h1>
        <form method="post">
            <?php wp_nonce_field('nahiroimap_shortcode_setup'); // Security nonce ?>
            <p><?php esc_html_e('Thank you for installing our Plugin! To begin please select the country you wish to use on your widget:', 'store-locations-map'); ?>
            </p>

            <?php
            require_once 'country-list.php';
            submit_button( esc_html( __('Complete Setup', 'store-locations-map') ) );
            ?>
        </form>
    </div>
    <div class='img-container'>
        <img src="<?php echo esc_url(plugin_dir_url(__FILE__) . '../assets/img/WordPress-Hilfe-Berlin-8.png'); ?>">
    </div>
</div>
